/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.church;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.IViewChangeEvent;
import ch.sahits.game.event.NoticeBoardUpdate;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.dialog.CloseButtonDialog;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.graphic.event.task.ClientTaskFactory;
import ch.sahits.game.graphic.event.task.PostponedDisplayDialogMessage;
import ch.sahits.game.graphic.image.IFontLoader;
import ch.sahits.game.graphic.image.impl.XMLImageLoader;
import ch.sahits.game.javafx.control.BaleAmountAlwaysVisible;
import ch.sahits.game.javafx.control.BarrelAmountAlwaysVisible;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.javafx.control.OpenPatricianSmallWaxButton;
import ch.sahits.game.javafx.model.ControlTableCell;
import ch.sahits.game.javafx.model.ITableCell;
import ch.sahits.game.javafx.model.StaticTextTableCell;
import ch.sahits.game.javafx.model.Table;
import ch.sahits.game.javafx.model.TableHeader;
import ch.sahits.game.javafx.model.TableRow;
import ch.sahits.game.javafx.service.DecoratedTextFactory;
import ch.sahits.game.javafx.util.JavaFXUtils;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.MapType;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.dialog.DialogTemplate;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.util.ModelTranslations;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.MapChangeListener;
import javafx.collections.ObservableMap;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class ChurchFeedingDialog
extends CloseButtonDialog {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private final ICityPlayerProxyJFX city;
    private final Font font;
    @Autowired
    private ClientViewState viewState;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private Locale locale;
    @Autowired
    @Qualifier(value="resourceReference")
    private MessageSource resources;
    @Autowired
    @Qualifier(value="mainScreenXMLImageLoader")
    private XMLImageLoader imageLoader;
    @Autowired
    private JavaFXUtils fxUtils;
    @Autowired
    private IFontLoader fontLoader;
    @Autowired
    private ModelTranslations translator;
    @Autowired
    private DecoratedTextFactory textFactory;
    @Autowired
    private Random rnd;
    @Autowired
    private Date date;
    @Autowired
    private TimedUpdatableTaskList timedTaskListener;
    @Autowired
    private ClientTaskFactory taskFactory;
    private int numberOfColumns;
    private int mainTableYPosition;
    private final ITradingOffice office;
    private static final EWare[] MATERIALS = new EWare[]{EWare.GRAIN, EWare.MEAT, EWare.FISH, EWare.BEER, EWare.WINE};
    @MapType(key=IWare.class, value=IntegerProperty.class)
    private ObservableMap<IWare, IntegerProperty> availableMap = FXCollections.observableMap(new HashMap());

    public ChurchFeedingDialog(Font font, ICityPlayerProxyJFX city) {
        super(font);
        this.city = city;
        this.font = font;
        List offices = city.getCity().findBuilding(ITradingOffice.class, Optional.of(city.getPlayer()));
        this.office = offices.isEmpty() ? null : (ITradingOffice)offices.get(0);
        this.mainTableYPosition = 286;
        this.clearMap();
    }

    private void clearMap() {
        for (EWare ware : MATERIALS) {
            this.availableMap.put((Object)ware, (Object)new SimpleIntegerProperty(0));
        }
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.church.ChurchFeedingDialog.title", new Object[0], this.locale.getCurrentLocal()));
        String template = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.church.ChurchFeedingDialog.introText", new Object[0], this.locale.getCurrentLocal());
        DecoratedText text = this.textFactory.createDecoratedText(template, new HashMap());
        VBox box = new VBox(new Node[]{text});
        Table mainTable = this.createMainTable();
        GridPane mainTablePane = new GridPane();
        mainTablePane.setLayoutX(30.0);
        mainTablePane.setLayoutY((double)this.mainTableYPosition);
        RowConstraints rowConstraint = this.getRowConstraints();
        mainTablePane.getRowConstraints().add((Object)rowConstraint);
        TableHeader header = mainTable.getHeader();
        this.numberOfColumns = mainTable.getNumberOfColumns();
        int currentCol = 0;
        for (int i = 0; i < this.numberOfColumns && header.size() > 0; ++i) {
            int colWidth = mainTable.getColumnWidth(i);
            ColumnConstraints colConstraint = new ColumnConstraints((double)colWidth);
            colConstraint.setHalignment(header.getAligenment(i));
            mainTablePane.getColumnConstraints().add((Object)colConstraint);
            ITableCell cell = header.get(i);
            String textStyleClass = "tableHeader";
            this.fxUtils.addCellToGridPane(this.font, mainTablePane, -1, null, currentCol++, cell, header.getAligenment(i), "tableHeader");
        }
        for (int rowNum = 0; rowNum < mainTable.getNumberOfRows(); ++rowNum) {
            TableRow row = mainTable.get(rowNum);
            mainTablePane.getRowConstraints().add((Object)rowConstraint);
            int iterationLimit = Math.min(mainTable.getNumberOfColumns(), row.size());
            for (int col = 0; col < iterationLimit; ++col) {
                ITableCell cell = row.get(col);
                HPos hAlignment = mainTable.getAligenment(col);
                String textStyleClass = "tableCell";
                this.fxUtils.addCellToGridPane(this.font, mainTablePane, rowNum, row, col, cell, hAlignment, "tableCell");
            }
        }
        box.setLayoutX(50.0);
        box.setLayoutY(127.0);
        box.getChildren().addAll((Object[])new Node[]{mainTablePane});
        int actionButtonX = 197;
        String s = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.church.ChurchFeedingDialog.donate", new Object[0], this.locale.getCurrentLocal());
        final OpenPatricianLargeWaxButton action = new OpenPatricianLargeWaxButton(s, this.font);
        action.setOnAction(this.getAction());
        action.setLayoutX(197.0);
        action.setLayoutY(603.0);
        BooleanBinding actionEnabled = this.actionEnabledBinding();
        action.setDisable(!actionEnabled.get());
        actionEnabled.addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean oldValue, Boolean newValue) {
                action.setDisable(newValue == false);
            }
        });
        this.getContent().addAll((Object[])new Node[]{box, action});
    }

    private BooleanBinding actionEnabledBinding() {
        return new BooleanBinding(){

            protected boolean computeValue() {
                if (ChurchFeedingDialog.this.availableMap.isEmpty()) {
                    return false;
                }
                for (IntegerProperty amount : ChurchFeedingDialog.this.availableMap.values()) {
                    if (amount.get() <= 0) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private EventHandler<MouseEvent> getAction() {
        return evt -> {
            final int amountBeggers = this.rnd.nextInt(this.city.getCity().getPopulationBinding().get() / 70);
            int amountWares = 0;
            for (IWare ware : this.availableMap.keySet()) {
                if (ware.isBarrelSizedWare()) {
                    amountWares += ((IntegerProperty)this.availableMap.get((Object)ware)).get();
                    continue;
                }
                amountWares += ((IntegerProperty)this.availableMap.get((Object)ware)).get() * 10;
            }
            boolean sufficient = amountBeggers * 5 <= amountWares;
            final DateTime execution = this.date.getCurrentDate().plusDays(this.rnd.nextInt(30));
            Object[] args = new Object[]{amountBeggers};
            if (sufficient) {
                DialogTemplate template = DialogTemplate.builder().closable(true).titleKey("ch.sahits.game.graphic.display.dialog.church.ChurchFeedingDialog.successfulFeedingTitle").messageKey("ch.sahits.game.graphic.display.dialog.church.ChurchFeedingDialog.successfulFeeding").messageArgs(args).build();
                TimedTask task = this.taskFactory.getPostponedDisplayDialogMessage(execution, template);
                this.timedTaskListener.add(task);
                task = new TimedTask(){
                    {
                        this.setExecutionTime(execution);
                    }

                    public void run() {
                        ChurchFeedingDialog.this.city.getCity().getReputation(ChurchFeedingDialog.this.city.getPlayer()).update(7 * amountBeggers);
                    }
                };
                this.timedTaskListener.add(task);
            } else {
                DialogTemplate template = DialogTemplate.builder().closable(true).titleKey("ch.sahits.game.graphic.display.dialog.church.ChurchFeedingDialog.unsuccessfulFeedingTitle").messageKey("ch.sahits.game.graphic.display.dialog.church.ChurchFeedingDialog.unsuccessfulFeeding").messageArgs(args).build();
                PostponedDisplayDialogMessage task = this.taskFactory.getPostponedDisplayDialogMessage(execution, template);
                this.timedTaskListener.add((TimedTask)task);
            }
            this.availableMap.clear();
            this.executeOnCloseButtonClicked();
        };
    }

    private Table createMainTable() {
        Table model = new Table();
        TableHeader header = new TableHeader(5);
        String s = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.BaseTradeDialog.ware", new Object[0], this.locale.getCurrentLocal());
        header.add((ITableCell)new StaticTextTableCell(s));
        s = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.CityStorageTradeDialog.storage", new Object[0], this.locale.getCurrentLocal());
        header.add((ITableCell)new StaticTextTableCell(s));
        header.add((ITableCell)new StaticTextTableCell(""));
        header.add((ITableCell)new StaticTextTableCell(""));
        s = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.church.ChurchFeedingDialog.donation", new Object[0], this.locale.getCurrentLocal());
        header.add((ITableCell)new StaticTextTableCell(s));
        header.setAligenment(0, HPos.LEFT);
        header.setAligenment(1, HPos.CENTER);
        header.setAligenment(4, HPos.LEFT);
        model.setHeader(header);
        model.setAligenment(0, HPos.LEFT);
        model.setAligenment(1, HPos.CENTER);
        model.setAligenment(3, HPos.RIGHT);
        model.setAligenment(4, HPos.CENTER);
        model.setColumnWidth(new Integer[]{70, 70, 70, 70, 70});
        for (final EWare ware : MATERIALS) {
            SimpleIntegerProperty stored;
            TableRow row = new TableRow();
            row.add((ITableCell)new StaticTextTableCell(this.translator.getLocalDisplayName(ware)));
            Object object = stored = this.office != null ? this.office.getWare((IWare)ware).amountProperty() : new SimpleIntegerProperty(0);
            if (ware.isBarrelSizedWare()) {
                BarrelAmountAlwaysVisible barrelAmount = new BarrelAmountAlwaysVisible(this.font);
                barrelAmount.amountProperty().bind((ObservableValue)stored.asString());
                row.add((ITableCell)new ControlTableCell((Node)barrelAmount));
            } else {
                BaleAmountAlwaysVisible baleAmount = new BaleAmountAlwaysVisible(this.font);
                baleAmount.amountProperty().bind((ObservableValue)stored.asString());
                row.add((ITableCell)new ControlTableCell((Node)baleAmount));
            }
            BooleanBinding removeEnabled = new BooleanBinding(){
                {
                    super.bind(new Observable[]{ChurchFeedingDialog.this.availableMap});
                }

                protected boolean computeValue() {
                    return ChurchFeedingDialog.this.availableMap.get((Object)ware) == null || ((IntegerProperty)ChurchFeedingDialog.this.availableMap.get((Object)ware)).get() <= 0;
                }
            };
            BooleanBinding donateEnabled = Bindings.lessThan((int)1, (ObservableNumberValue)stored).not();
            OpenPatricianSmallWaxButton previous = new OpenPatricianSmallWaxButton("<", this.font);
            previous.setOnAction(this.createPreviousAction(ware));
            previous.disableProperty().bind((ObservableValue)removeEnabled);
            row.add((ITableCell)new ControlTableCell((Node)previous));
            OpenPatricianSmallWaxButton next = new OpenPatricianSmallWaxButton(">", this.font);
            next.setOnAction(this.createNextAction(ware));
            next.disableProperty().bind((ObservableValue)donateEnabled);
            row.add((ITableCell)new ControlTableCell((Node)next));
            if (ware.isBarrelSizedWare()) {
                final BarrelAmountAlwaysVisible barrelAmount = new BarrelAmountAlwaysVisible(this.font);
                barrelAmount.setAmount(Integer.valueOf(0));
                this.availableMap.addListener((MapChangeListener)new MapChangeListener<IWare, IntegerProperty>(){

                    public void onChanged(MapChangeListener.Change<? extends IWare, ? extends IntegerProperty> change) {
                        IntegerProperty valueAdded = (IntegerProperty)change.getValueAdded();
                        if (ware.equals(change.getKey()) && valueAdded != null) {
                            barrelAmount.amountProperty().setValue(String.valueOf(valueAdded.get()));
                        }
                    }
                });
                row.add((ITableCell)new ControlTableCell((Node)barrelAmount));
            } else {
                final BaleAmountAlwaysVisible baleAmount = new BaleAmountAlwaysVisible(this.font);
                baleAmount.setAmount(Integer.valueOf(0));
                this.availableMap.addListener((MapChangeListener)new MapChangeListener<IWare, IntegerProperty>(){

                    public void onChanged(MapChangeListener.Change<? extends IWare, ? extends IntegerProperty> change) {
                        IntegerProperty valueAdded = (IntegerProperty)change.getValueAdded();
                        if (ware.equals(change.getKey()) && valueAdded != null) {
                            baleAmount.amountProperty().setValue(String.valueOf(valueAdded.get()));
                        }
                    }
                });
                row.add((ITableCell)new ControlTableCell((Node)baleAmount));
            }
            model.add(row);
        }
        return model;
    }

    private EventHandler<MouseEvent> createNextAction(EWare ware) {
        return evt -> {
            this.office.move((IWare)ware, -1);
            IntegerProperty donated = (IntegerProperty)this.availableMap.get((Object)ware);
            this.availableMap.put((Object)ware, (Object)new SimpleIntegerProperty(donated.add(1).intValue()));
        };
    }

    private EventHandler<MouseEvent> createPreviousAction(EWare ware) {
        return evt -> {
            this.office.move((IWare)ware, 1);
            IntegerProperty donated = (IntegerProperty)this.availableMap.get((Object)ware);
            this.availableMap.put((Object)ware, (Object)new SimpleIntegerProperty(donated.subtract(1).intValue()));
        };
    }

    private RowConstraints getRowConstraints() {
        RowConstraints rowConstraint = new RowConstraints(24.0);
        return rowConstraint;
    }

    @Override
    protected void executeOnCloseButtonClicked() {
        for (IWare ware : this.availableMap.keySet()) {
            IntegerProperty amount = (IntegerProperty)this.availableMap.get((Object)ware);
            this.office.move(ware, amount.intValue());
        }
        this.availableMap.clear();
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.MAIN_VIEW_CHURCH);
        this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
        super.executeOnCloseButtonClicked();
    }

    @VisibleForTesting
    int getAmountDonated(IWare ware) {
        return ((IntegerProperty)this.availableMap.get((Object)ware)).get();
    }
}

