/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.cityhall;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.IViewChangeEvent;
import ch.sahits.game.event.NoticeBoardUpdate;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.dialog.CloseButtonDialog;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.graphic.image.impl.XMLImageLoader;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.javafx.service.DecoratedTextFactory;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.engine.land.city.CityHallEngine;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityHall;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.Treasury;
import ch.sahits.game.openpatrician.model.city.impl.CityWall;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class CityWallBuildingDialog
extends CloseButtonDialog {
    @Autowired
    private ClientViewState viewState;
    @Autowired
    private CityHallEngine cityHallEngine;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private DecoratedTextFactory textFactory;
    @Autowired
    @Qualifier(value="mainScreenXMLImageLoader")
    private XMLImageLoader imageLoader;
    @Autowired
    private Date date;
    private final ICityPlayerProxyJFX city;
    private IntegerProperty numberOfBricks;
    private StyleableObjectProperty<Font> font;

    public CityWallBuildingDialog(Font font, ICityPlayerProxyJFX city) {
        super(font);
        this.city = city;
        this.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("/styles/base.css").toExternalForm());
        this.getStyleClass().add((Object)"dialog");
    }

    @PostConstruct
    private void initializeDialog() {
        Object[] args;
        VBox box;
        boolean upgrading;
        ICitizen mayor;
        ICityHall cityHall;
        CityWall cityWall;
        block12: {
            String template;
            block11: {
                this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.CityWallBuildingDialog.title", new Object[0], this.locale.getCurrentLocal()));
                cityWall = this.city.getCity().getCityState().getCityWall();
                cityHall = this.cityHallEngine.findCityHall(this.city.getCity());
                mayor = cityHall.getMayor();
                upgrading = cityWall.getBoughtBricks() < cityWall.getRequiredBricks();
                box = this.textFactory.createMultiParagraphContainer();
                args = new Object[]{};
                if (!upgrading) break block11;
                switch (cityWall.getExtension()) {
                    case EXTENDED_ONCE: {
                        template = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.CityWallBuildingDialog.notExtended", args, this.locale.getCurrentLocal());
                        DecoratedText text = this.textFactory.createDecoratedText(template, new HashMap());
                        box.getChildren().add((Object)text);
                        break block12;
                    }
                    case EXTENDED_TWICE: {
                        template = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.CityWallBuildingDialog.extensionOne", args, this.locale.getCurrentLocal());
                        DecoratedText text = this.textFactory.createDecoratedText(template, new HashMap());
                        box.getChildren().add((Object)text);
                        break block12;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled extension state " + cityWall.getExtension() + " for upgrading");
                    }
                }
            }
            switch (cityWall.getExtension()) {
                case NOT_EXTENDED: {
                    template = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.CityWallBuildingDialog.notExtended", args, this.locale.getCurrentLocal());
                    DecoratedText text = this.textFactory.createDecoratedText(template, new HashMap());
                    box.getChildren().add((Object)text);
                    break;
                }
                case EXTENDED_ONCE: {
                    template = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.CityWallBuildingDialog.extensionOne", args, this.locale.getCurrentLocal());
                    DecoratedText text = this.textFactory.createDecoratedText(template, new HashMap());
                    box.getChildren().add((Object)text);
                    break;
                }
                case EXTENDED_TWICE: {
                    template = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.CityWallBuildingDialog.extensionTwo", args, this.locale.getCurrentLocal());
                    DecoratedText text = this.textFactory.createDecoratedText(template, new HashMap());
                    box.getChildren().add((Object)text);
                }
            }
        }
        if (upgrading) {
            double progress = 1.0 * (double)cityWall.getRequiredBricks() / (double)cityWall.getUsedBricks();
            args = new Object[]{progress};
            String template = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.CityWallBuildingDialog.upgrade", args, this.locale.getCurrentLocal());
            DecoratedText text = this.textFactory.createDecoratedText(template, new HashMap());
            box.getChildren().add((Object)text);
            if (mayor.equals(this.city.getPlayer())) {
                args = new Object[]{cityWall.getRequiredBricks() - cityWall.getBoughtBricks()};
                template = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.CityWallBuildingDialog.missingBricks", args, this.locale.getCurrentLocal());
                text = this.textFactory.createDecoratedText(template, new HashMap());
                box.getChildren().add((Object)text);
                HBox buyBrickBox = new HBox();
                template = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.CityWallBuildingDialog.buyBricks", new Object[0], this.locale.getCurrentLocal());
                text = this.textFactory.createDecoratedText(template, new HashMap());
                this.numberOfBricks = new SimpleIntegerProperty(0);
                Image img = this.imageLoader.getImage("icons/plusIcon");
                ImageView plusIcon = new ImageView(img);
                plusIcon.setId("plusIcon");
                plusIcon.setOnMouseReleased(e -> {
                    int newValue = Math.min(cityWall.getRequiredBricks(), this.numberOfBricks.get() + 1);
                    int amount = this.city.getCity().getWare((IWare)EWare.BRICK).getAmount();
                    newValue = Math.min(newValue, amount);
                    this.numberOfBricks.setValue((Number)newValue);
                });
                Label nbBricks = new Label();
                nbBricks.textProperty().bind((ObservableValue)this.numberOfBricks.asString());
                img = this.imageLoader.getImage("icons/minusIcon");
                ImageView minusIcon = new ImageView(img);
                minusIcon.setId("minusIcon");
                minusIcon.setOnMouseReleased(e -> {
                    int newValue = Math.max(0, this.numberOfBricks.get() - 1);
                    newValue = Math.min(newValue, this.city.getCity().getWare((IWare)EWare.BRICK).getAmount());
                    this.numberOfBricks.setValue((Number)newValue);
                });
                buyBrickBox.getChildren().addAll((Object[])new Node[]{text, minusIcon, nbBricks, plusIcon});
                box.getChildren().add((Object)buyBrickBox);
                OpenPatricianLargeWaxButton action = new OpenPatricianLargeWaxButton(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.BaseTradeDialog.buy", new Object[0], this.locale.getCurrentLocal()), this.getFont());
                action.setId("action");
                action.setOnAction(e -> {
                    if (this.numberOfBricks.get() > 0) {
                        AmountablePrice amount = this.city.getCity().getWare((IWare)EWare.BRICK);
                        int price = EWare.BRICK.buyPrice(amount.amountProperty(), new IntegerBinding(){

                            protected int computeValue() {
                                return CityWallBuildingDialog.this.numberOfBricks.get();
                            }
                        });
                        int moved = this.city.getCity().move((IWare)EWare.BRICK, -this.numberOfBricks.get(), mayor);
                        int totalPrice = price * -moved;
                        ((Treasury)cityHall.getTreasury()).subtractBuildingCosts(totalPrice);
                        cityWall.setBoughtBricks(cityWall.getBoughtBricks() - moved);
                    }
                    this.executeOnCloseButtonClicked();
                });
                box.getChildren().add((Object)action);
            }
        }
        this.getContent().addAll((Object[])new Node[]{box});
    }

    @Override
    protected void executeOnCloseButtonClicked() {
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_CITY_HALL_ELDERMAN);
        this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
        super.executeOnCloseButtonClicked();
    }

    public Font getFont() {
        return this.font == null ? Font.getDefault() : (Font)this.font.get();
    }

    public void setFont(Font font) {
        this.font.set((Object)font);
    }

    public StyleableObjectProperty<Font> fontProperty() {
        if (this.font == null) {
            this.font = new SimpleStyleableObjectProperty(StyleableProperties.FONT, (Object)this, "font", (Object)Font.getDefault());
        }
        return this.font;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return CityWallBuildingDialog.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    private static class StyleableProperties {
        private static final CssMetaData<CityWallBuildingDialog, Font> FONT = new CssMetaData<CityWallBuildingDialog, Font>("-fx-font", StyleConverter.getFontConverter(), Font.getDefault()){

            public boolean isSettable(CityWallBuildingDialog control) {
                return control.font == null || !control.font.isBound();
            }

            public StyleableProperty<Font> getStyleableProperty(CityWallBuildingDialog control) {
                return control.fontProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(styleables, FONT);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

