/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.cityhall;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.IViewChangeEvent;
import ch.sahits.game.event.NoticeBoardUpdate;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.dialog.CloseButtonDialog;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.service.DecoratedTextFactory;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.engine.land.city.CityHallEngine;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityHall;
import ch.sahits.game.openpatrician.model.personal.EEconomicCareer;
import ch.sahits.game.openpatrician.model.personal.ICareer;
import ch.sahits.game.openpatrician.model.util.ModelTranslations;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javax.annotation.PostConstruct;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class HanseaticInfoDialog
extends CloseButtonDialog {
    @Autowired
    private ClientViewState viewState;
    @Autowired
    private CityHallEngine cityHallEngine;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private DecoratedTextFactory textFactory;
    @Autowired
    private ModelTranslations modelTranslator;
    @Autowired
    private Date date;
    private final ICityPlayerProxyJFX city;
    private StyleableObjectProperty<Font> font;

    public HanseaticInfoDialog(Font font, ICityPlayerProxyJFX city) {
        super(font);
        this.city = city;
        this.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("/styles/base.css").toExternalForm());
        this.getStyleClass().add((Object)"dialog");
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.HanseaticInfoDialog.title", new Object[0], this.locale.getCurrentLocal()));
        VBox box = this.textFactory.createMultiParagraphContainer();
        ICity town = this.city.getCity();
        IPlayer player = this.city.getPlayer();
        ICityHall cityHall = this.cityHallEngine.findCityHall(town);
        System.out.println(cityHall);
        ICitizen elderman = cityHall.getElderman();
        boolean articleMale = true;
        if (elderman instanceof IPlayer && !((IPlayer)elderman).isMale()) {
            articleMale = false;
        }
        String attribute = this.modelTranslator.getLocalDisplayName((ICareer)EEconomicCareer.HONEST);
        if (elderman instanceof IPlayer) {
            attribute = this.modelTranslator.getLocalDisplayName(((IPlayer)elderman).getCareerLevel());
        }
        System.out.println(elderman);
        Object[] args = new Object[]{this.modelTranslator.getLocalDisplayDistinctArticle(articleMale, false), attribute, elderman.getName() + " " + elderman.getLastName(), elderman.getHometown().getName()};
        String template = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.HanseaticInfoDialog.paragraph1", args, this.locale.getCurrentLocal());
        DecoratedText text = this.textFactory.createDecoratedText(template, new HashMap());
        box.getChildren().add((Object)text);
        DateTime electionDate = cityHall.getEldermanElectionDate();
        template = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.HanseaticInfoDialog.paragraph2", new Object[]{this.date.todisplayString(electionDate.getDayOfMonth(), electionDate.getMonthOfYear(), electionDate.getYear()), elderman.getHometown().getName()}, this.locale.getCurrentLocal());
        text = this.textFactory.createDecoratedText(template, new HashMap());
        box.getChildren().add((Object)text);
        List candidates = cityHall.getEldermanCandidates().getAll();
        for (ICitizen candidate : candidates) {
            text = this.getCandidateRow(candidate);
            box.getChildren().add((Object)text);
        }
        this.getContent().addAll((Object[])new Node[]{box});
    }

    private DecoratedText getCandidateRow(ICitizen candidate) {
        Object[] args;
        if (candidate instanceof IPlayer) {
            IPlayer p = (IPlayer)candidate;
            args = new Object[]{this.modelTranslator.getLocalDisplayDistinctArticle(p.isMale(), true), this.modelTranslator.getLocalDisplayName(p.getCareerLevel()), this.modelTranslator.getLocalDisplayName(p.getRank()), p.getName() + " " + p.getLastName()};
        } else {
            args = new Object[]{this.modelTranslator.getLocalDisplayDistinctArticle(true, true), this.modelTranslator.getLocalDisplayName((ICareer)EEconomicCareer.SMART), this.modelTranslator.getLocalDisplayName(candidate.getRank()), candidate.getName() + " " + candidate.getLastName()};
        }
        String template = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.TownInfoNotice.candidate", args, this.locale.getCurrentLocal());
        DecoratedText text = this.textFactory.createDecoratedText(template, new HashMap());
        return text;
    }

    @Override
    protected void executeOnCloseButtonClicked() {
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_CITY_HALL_ELDERMAN);
        this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
        super.executeOnCloseButtonClicked();
    }

    public Font getFont() {
        return this.font == null ? Font.getDefault() : (Font)this.font.get();
    }

    public void setFont(Font font) {
        this.font.set((Object)font);
    }

    public StyleableObjectProperty<Font> fontProperty() {
        if (this.font == null) {
            this.font = new SimpleStyleableObjectProperty(StyleableProperties.FONT, (Object)this, "font", (Object)Font.getDefault());
        }
        return this.font;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return HanseaticInfoDialog.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    private static class StyleableProperties {
        private static final CssMetaData<HanseaticInfoDialog, Font> FONT = new CssMetaData<HanseaticInfoDialog, Font>("-fx-font", StyleConverter.getFontConverter(), Font.getDefault()){

            public boolean isSettable(HanseaticInfoDialog control) {
                return control.font == null || !control.font.isBound();
            }

            public StyleableProperty<Font> getStyleableProperty(HanseaticInfoDialog control) {
                return control.fontProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(styleables, FONT);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

