/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.cityhall;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.IViewChangeEvent;
import ch.sahits.game.event.NoticeBoardUpdate;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.dialog.CloseButtonDialog;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.graphic.image.IDataImageLoader;
import ch.sahits.game.graphic.image.impl.XMLImageLoader;
import ch.sahits.game.javafx.control.CoinPriceAlwaysVisible;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.control.MoneyTransfer;
import ch.sahits.game.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.javafx.model.ControlTableCell;
import ch.sahits.game.javafx.model.ITableCell;
import ch.sahits.game.javafx.model.StaticTextTableCell;
import ch.sahits.game.javafx.model.Table;
import ch.sahits.game.javafx.model.TableHeader;
import ch.sahits.game.javafx.model.TableRow;
import ch.sahits.game.javafx.service.DecoratedTextFactory;
import ch.sahits.game.javafx.util.JavaFXUtils;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.engine.land.city.CityHallEngine;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.ICompany;
import ch.sahits.game.openpatrician.model.city.cityhall.ICityHall;
import ch.sahits.game.openpatrician.model.city.cityhall.ITreasury;
import ch.sahits.game.openpatrician.model.city.cityhall.impl.Treasury;
import ch.sahits.game.openpatrician.model.personal.ESocialRank;
import ch.sahits.game.openpatrician.model.util.CityUtilities;
import ch.sahits.game.openpatrician.model.util.ModelTranslations;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.text.Font;
import javax.annotation.PostConstruct;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TreasuryDialog
extends CloseButtonDialog {
    @Autowired
    private ClientViewState viewState;
    @Autowired
    private CityHallEngine cityHallEngine;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private DecoratedTextFactory textFactory;
    @Autowired
    private ModelTranslations modelTranslator;
    @Autowired
    private Date date;
    @Autowired
    private CityUtilities cityService;
    @Autowired
    private JavaFXUtils fxUtils;
    @Autowired
    @Qualifier(value="mainScreenXMLImageLoader")
    private XMLImageLoader imageLoader;
    private final ICityPlayerProxyJFX city;
    private HBox selectionBox = null;
    private GridPane grid;
    private StyleableObjectProperty<Font> font;

    public TreasuryDialog(Font font, ICityPlayerProxyJFX city) {
        super(font);
        this.fontProperty().set((Object)font);
        this.city = city;
        this.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("/styles/base.css").toExternalForm());
        this.getStyleClass().add((Object)"dialog");
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.TreasuryDialog.title", new Object[0], this.locale.getCurrentLocal()));
        DateTime now = this.date.getCurrentDate();
        DateTime firstOfMont = now.minusDays(now.getDayOfMonth() - 1);
        Object[] args = new Object[]{this.date.toShortDate(firstOfMont)};
        String template = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.TreasuryDialog.subtitle", args, this.locale.getCurrentLocal());
        DecoratedText text = this.textFactory.createDecoratedText(template, new HashMap());
        text.setLayoutX(30.0);
        this.getContent().add((Object)text);
        long total = 0L;
        Table tableModel = new Table();
        TableHeader header = new TableHeader(2);
        header.add((ITableCell)new StaticTextTableCell(""));
        header.add((ITableCell)new StaticTextTableCell(""));
        tableModel.setHeader(header);
        tableModel.setColumnWidth(new Integer[]{300, 100});
        tableModel.setAligenment(0, HPos.LEFT);
        tableModel.setAligenment(1, HPos.RIGHT);
        ICityHall cityHall = this.cityHallEngine.findCityHall(this.city.getCity());
        ITreasury treasury = cityHall.getTreasury();
        TableRow row = new TableRow();
        template = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.TreasuryDialog.headAndPropertyTax", new Object[0], this.locale.getCurrentLocal());
        row.add((ITableCell)new StaticTextTableCell(template));
        Font font1 = this.getFont();
        CoinPriceAlwaysVisible control = new CoinPriceAlwaysVisible(font1);
        control.setAmount(Integer.valueOf((int)treasury.getPaidTaxes()));
        row.add((ITableCell)new ControlTableCell((Node)control));
        tableModel.add(row);
        total += treasury.getPaidTaxes();
        row = new TableRow();
        template = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.TreasuryDialog.specialTaxes", new Object[0], this.locale.getCurrentLocal());
        row.add((ITableCell)new StaticTextTableCell(template));
        control = new CoinPriceAlwaysVisible(font1);
        control.setAmount(Integer.valueOf((int)treasury.getPaidSpecialTaxes()));
        row.add((ITableCell)new ControlTableCell((Node)control));
        tableModel.add(row);
        total += treasury.getPaidSpecialTaxes();
        row = new TableRow();
        template = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.TreasuryDialog.donation", new Object[0], this.locale.getCurrentLocal());
        row.add((ITableCell)new StaticTextTableCell(template));
        control = new CoinPriceAlwaysVisible(font1);
        control.setAmount(Integer.valueOf(treasury.getDonations()));
        row.add((ITableCell)new ControlTableCell((Node)control));
        tableModel.add(row);
        total += (long)treasury.getDonations();
        row = new TableRow();
        template = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.TreasuryDialog.donation.guardsCost", new Object[0], this.locale.getCurrentLocal());
        row.add((ITableCell)new StaticTextTableCell(template));
        control = new CoinPriceAlwaysVisible(font1);
        control.setAmount(Integer.valueOf(treasury.getCityGuardCosts()));
        row.add((ITableCell)new ControlTableCell((Node)control));
        tableModel.add(row);
        total += (long)treasury.getCityGuardCosts();
        row = new TableRow();
        template = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.TreasuryDialog.buildCosts", new Object[0], this.locale.getCurrentLocal());
        row.add((ITableCell)new StaticTextTableCell(template));
        control = new CoinPriceAlwaysVisible(font1);
        control.setAmount(Integer.valueOf(treasury.getBuildingCosts()));
        row.add((ITableCell)new ControlTableCell((Node)control));
        tableModel.add(row);
        total += (long)treasury.getBuildingCosts();
        row = new TableRow();
        template = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.TreasuryDialog.outriggerCosts", new Object[0], this.locale.getCurrentLocal());
        row.add((ITableCell)new StaticTextTableCell(template));
        control = new CoinPriceAlwaysVisible(font1);
        control.setAmount(Integer.valueOf(treasury.getOutriggerCosts()));
        row.add((ITableCell)new ControlTableCell((Node)control));
        tableModel.add(row);
        total += (long)treasury.getOutriggerCosts();
        row = new TableRow();
        template = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.TreasuryDialog.siege", new Object[0], this.locale.getCurrentLocal());
        row.add((ITableCell)new StaticTextTableCell(template));
        control = new CoinPriceAlwaysVisible(font1);
        control.setAmount(Integer.valueOf(treasury.getOtherCosts()));
        row.add((ITableCell)new ControlTableCell((Node)control));
        tableModel.add(row);
        total += (long)treasury.getOutriggerCosts();
        row = new TableRow();
        template = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.TreasuryDialog.otherCosts", new Object[0], this.locale.getCurrentLocal());
        row.add((ITableCell)new StaticTextTableCell(template));
        control = new CoinPriceAlwaysVisible(font1);
        control.setAmount(Integer.valueOf(treasury.getOtherCosts() + treasury.getOtherIncome()));
        row.add((ITableCell)new ControlTableCell((Node)control));
        tableModel.add(row);
        total += (long)treasury.getOtherCosts();
        row = new TableRow();
        tableModel.add(row);
        row = new TableRow();
        template = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.TreasuryDialog.total", new Object[0], this.locale.getCurrentLocal());
        row.add((ITableCell)new StaticTextTableCell(template));
        control = new CoinPriceAlwaysVisible(font1);
        control.setAmount(Integer.valueOf((int)total));
        row.add((ITableCell)new ControlTableCell((Node)control));
        tableModel.add(row);
        row = new TableRow();
        tableModel.add(row);
        row = new TableRow();
        template = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.TreasuryDialog.available", new Object[0], this.locale.getCurrentLocal());
        row.add((ITableCell)new StaticTextTableCell(template));
        control = new CoinPriceAlwaysVisible(font1);
        control.setAmount(Integer.valueOf((int)treasury.getCash()));
        row.add((ITableCell)new ControlTableCell((Node)control));
        tableModel.add(row);
        row = new TableRow();
        tableModel.add(row);
        row = new TableRow();
        tableModel.add(row);
        row = new TableRow();
        tableModel.add(row);
        template = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.TreasuryDialog.donate", new Object[0], this.locale.getCurrentLocal());
        OpenPatricianLargeWaxButton donate = new OpenPatricianLargeWaxButton(template, font1);
        donate.setId("donate");
        template = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.TreasuryDialog.withdraw", new Object[0], this.locale.getCurrentLocal());
        OpenPatricianLargeWaxButton withdraw = new OpenPatricianLargeWaxButton(template, font1);
        if (!this.city.getPlayer().getRank().equals((Object)ESocialRank.MAYOR) || !this.city.getPlayer().getHometown().equals(this.city.getCity())) {
            withdraw.setVisible(false);
        }
        withdraw.setId("withdraw");
        donate.setOnAction(this.getDonateAction(donate, withdraw));
        withdraw.setOnAction(this.getWithdrawalAction(donate, withdraw));
        row = new TableRow();
        row.add((ITableCell)new ControlTableCell((Node)donate));
        row.add((ITableCell)new ControlTableCell((Node)withdraw));
        tableModel.add(row);
        this.grid = this.fxUtils.createGridPaneFromModel(tableModel, font1);
        this.grid.setLayoutX(50.0);
        this.grid.setLayoutY(127.0);
        this.getContent().add((Object)this.grid);
    }

    private EventHandler<MouseEvent> getWithdrawalAction(OpenPatricianLargeWaxButton donation, OpenPatricianLargeWaxButton withdraw) {
        return mouseEvent -> {
            this.grid.getChildren().removeAll((Object[])new Node[]{donation, withdraw});
            Treasury treasury = (Treasury)this.cityHallEngine.findCityHall(this.city.getCity()).getTreasury();
            MoneyTransfer moneyTransfer = this.fxUtils.getMoneyTransfer((IDataImageLoader)this.imageLoader);
            moneyTransfer.setStepSize(100);
            moneyTransfer.maxTransfereableProperty().bind((ObservableValue)treasury.cashProperty());
            moneyTransfer.setAmount(0);
            this.selectionBox = new HBox(5.0);
            String template = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.TreasuryDialog.withdraw", new Object[0], this.locale.getCurrentLocal());
            OpenPatricianLargeWaxButton action = new OpenPatricianLargeWaxButton(template, this.getFont());
            action.setId("withdrawlButton");
            this.selectionBox.getChildren().addAll((Object[])new Node[]{moneyTransfer, action});
            this.selectionBox.setLayoutX(100.0);
            this.selectionBox.setLayoutY(577.0);
            this.getContent().add((Object)this.selectionBox);
            action.setOnAction(e -> {
                int withdrawl = moneyTransfer.getAmount();
                treasury.subtractOtherCosts(withdrawl);
                this.city.getPlayer().getCompany().updateCash((long)withdrawl);
                this.executeOnCloseButtonClicked();
            });
        };
    }

    private EventHandler<MouseEvent> getDonateAction(OpenPatricianLargeWaxButton donation, OpenPatricianLargeWaxButton withdraw) {
        return mouseEvent -> {
            this.grid.getChildren().removeAll((Object[])new Node[]{donation, withdraw});
            ICompany company = this.city.getPlayer().getCompany();
            MoneyTransfer moneyTransfer = this.fxUtils.getMoneyTransfer((IDataImageLoader)this.imageLoader);
            moneyTransfer.setStepSize(100);
            moneyTransfer.maxTransfereableProperty().bind((ObservableValue)company.cashProperty());
            moneyTransfer.setAmount(0);
            this.selectionBox = new HBox(5.0);
            String template = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.TreasuryDialog.donate", new Object[0], this.locale.getCurrentLocal());
            OpenPatricianLargeWaxButton action = new OpenPatricianLargeWaxButton(template, this.getFont());
            action.setId("donateButton");
            this.selectionBox.getChildren().addAll((Object[])new Node[]{moneyTransfer, action});
            this.selectionBox.setLayoutX(100.0);
            this.selectionBox.setLayoutY(577.0);
            this.getContent().add((Object)this.selectionBox);
            action.setOnAction(e -> {
                Treasury treasury = (Treasury)this.cityHallEngine.findCityHall(this.city.getCity()).getTreasury();
                int donations = moneyTransfer.getAmount();
                treasury.addDonations(donations);
                company.updateCash((long)(-donations));
                this.executeOnCloseButtonClicked();
            });
        };
    }

    @Override
    protected void executeOnCloseButtonClicked() {
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_CITY_HALL_TREASURY);
        this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
        super.executeOnCloseButtonClicked();
    }

    public Font getFont() {
        return this.font == null ? Font.getDefault() : (Font)this.font.get();
    }

    public void setFont(Font font) {
        this.font.set((Object)font);
    }

    public StyleableObjectProperty<Font> fontProperty() {
        if (this.font == null) {
            this.font = new SimpleStyleableObjectProperty(StyleableProperties.FONT, (Object)this, "font", (Object)Font.getDefault());
        }
        return this.font;
    }

    public List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return TreasuryDialog.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    private static class StyleableProperties {
        private static final CssMetaData<TreasuryDialog, Font> FONT = new CssMetaData<TreasuryDialog, Font>("-fx-font", StyleConverter.getFontConverter(), Font.getDefault()){

            public boolean isSettable(TreasuryDialog control) {
                return control.font == null || !control.font.isBound();
            }

            public StyleableProperty<Font> getStyleableProperty(TreasuryDialog control) {
                return control.fontProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(styleables, FONT);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

