/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.loaner;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.IViewChangeEvent;
import ch.sahits.game.event.NoticeBoardUpdate;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.dialog.CloseButtonDialog;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.graphic.image.impl.XMLImageLoader;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.javafx.service.DecoratedTextFactory;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ListType;
import ch.sahits.game.openpatrician.annotation.ObjectPropertyType;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.engine.land.city.LoanerEngine;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.city.ICreditor;
import ch.sahits.game.openpatrician.model.city.ILoanRequest;
import ch.sahits.game.openpatrician.model.city.impl.Debt;
import ch.sahits.game.openpatrician.model.city.impl.IDebt;
import ch.sahits.game.openpatrician.model.city.impl.LoanerState;
import ch.sahits.game.openpatrician.model.util.ModelTranslations;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javax.annotation.PostConstruct;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class LoanerGiveLoanDialog
extends CloseButtonDialog {
    private final int BUTTON_X = 197;
    private final int BUTTON_Y = 603;
    public static final String DEFAULT_NON_SELECTED_STYLE = "-fx-fill: dimgray; -fx-text-fill: dimgray;";
    public static final String SELECTED_STYLE = "-fx-font-weight: bolder; -fx-fill: black;  -fx-text-fill: black;";
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private Locale locale;
    @Autowired
    private LoanerEngine loanerEngine;
    @Autowired
    private DecoratedTextFactory textFactory;
    @Autowired
    private ModelTranslations translator;
    @Autowired
    @Qualifier(value="mainScreenXMLImageLoader")
    private XMLImageLoader imageLoader;
    @Autowired
    private Date date;
    @Autowired
    private ClientViewState viewState;
    private LoanerState loaner;
    private final ICityPlayerProxyJFX city;
    private final Font font;
    @ObjectPropertyType(value=ILoanRequest.class)
    private ObjectProperty<ILoanRequest> selectedRequest = new SimpleObjectProperty(null);
    private VBox box;
    private OpenPatricianLargeWaxButton acceptBtn;
    private DecoratedText loanAgreement;
    @ListType(value=Double.class)
    private List<Double> interestLevels;
    private IntegerProperty selectedInterestLevel;

    public LoanerGiveLoanDialog(Font font, ICityPlayerProxyJFX city) {
        super(font);
        this.city = city;
        this.font = font;
    }

    @PostConstruct
    private void initializeDialog() {
        this.loaner = (LoanerState)this.loanerEngine.getLoaner(this.city.getCity());
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.giveLoan", new Object[0], this.locale.getCurrentLocal()));
        String header = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.LoanerGiveLoanDialog.subHeader", new Object[0], this.locale.getCurrentLocal());
        this.box = new VBox(5.0);
        this.box.setLayoutX(30.0);
        this.box.setLayoutY(200.0);
        DecoratedText subHeading = this.textFactory.createDecoratedText(header, new HashMap());
        this.box.getChildren().add((Object)subHeading);
        int index = 0;
        for (final ILoanRequest request : this.loaner.getRequests()) {
            if (index >= 4) continue;
            ICitizen citizen = request.getCitizen();
            String rank = this.translator.getLocalDisplayName(citizen.getRank());
            String s = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.LoanerGiveLoanDialog.request", new Object[]{rank, citizen.getName(), citizen.getLastName(), request.getSum(), request.getDurationInWeeks()}, this.locale.getCurrentLocal());
            final DecoratedText entry = this.textFactory.createDecoratedText(s, new HashMap());
            entry.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    LoanerGiveLoanDialog.this.selectedRequest.setValue((Object)request);
                    LoanerGiveLoanDialog.this.deactivateAll();
                    entry.applyStyle(LoanerGiveLoanDialog.SELECTED_STYLE);
                }
            });
            entry.applyStyle(DEFAULT_NON_SELECTED_STYLE);
            this.box.getChildren().add((Object)entry);
            ++index;
        }
        this.acceptBtn = new OpenPatricianLargeWaxButton(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.LoanerGiveLoanDialog.btnLabel", new Object[0], this.locale.getCurrentLocal()), this.font);
        this.acceptBtn.setLayoutX(197.0);
        this.acceptBtn.setLayoutY(603.0);
        this.acceptBtn.setDisable(true);
        this.selectedRequest.addListener((ChangeListener)new ChangeListener<ILoanRequest>(){

            public void changed(ObservableValue<? extends ILoanRequest> observableValue, ILoanRequest oldRequest, ILoanRequest newRequest) {
                if (newRequest != null) {
                    LoanerGiveLoanDialog.this.acceptBtn.setDisable(false);
                }
            }
        });
        this.acceptBtn.setOnAction(this.createAcceptHandlerPage1());
        this.getContent().addAll((Object[])new Node[]{this.box, this.acceptBtn});
    }

    private void deactivateAll() {
        for (Node node : this.box.getChildren()) {
            if (!(node instanceof DecoratedText)) continue;
            ((DecoratedText)node).applyStyle(DEFAULT_NON_SELECTED_STYLE);
        }
    }

    private EventHandler<MouseEvent> createAcceptHandlerPage1() {
        return new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                LoanerGiveLoanDialog.this.getContent().remove((Object)LoanerGiveLoanDialog.this.box);
                LoanerGiveLoanDialog.this.box = new VBox(5.0);
                LoanerGiveLoanDialog.this.box.setLayoutX(30.0);
                LoanerGiveLoanDialog.this.box.setLayoutY(200.0);
                LoanerGiveLoanDialog.this.getContent().add(LoanerGiveLoanDialog.this.getContent().size() - 2, (Object)LoanerGiveLoanDialog.this.box);
                String header = LoanerGiveLoanDialog.this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.LoanerGiveLoanDialog.subHeader2", new Object[0], LoanerGiveLoanDialog.this.locale.getCurrentLocal());
                Text subHeading = new Text();
                subHeading.setText(header);
                subHeading.setFont(LoanerGiveLoanDialog.this.font);
                StackPane interestSelectionPane = new StackPane();
                Image minus = LoanerGiveLoanDialog.this.imageLoader.getImage("icons/minusIcon");
                Image plus = LoanerGiveLoanDialog.this.imageLoader.getImage("icons/plusIcon");
                Label reduceInterestLbl = new Label("", (Node)new ImageView(minus));
                Label increaseInterestLbl = new Label("", (Node)new ImageView(plus));
                LoanerGiveLoanDialog.this.interestLevels = new ArrayList();
                LoanerGiveLoanDialog.this.interestLevels.add(0.011);
                LoanerGiveLoanDialog.this.interestLevels.add(0.013);
                LoanerGiveLoanDialog.this.interestLevels.add(0.016);
                LoanerGiveLoanDialog.this.interestLevels.add(0.019);
                LoanerGiveLoanDialog.this.interestLevels.add(0.025);
                LoanerGiveLoanDialog.this.selectedInterestLevel = (IntegerProperty)new SimpleIntegerProperty(2);
                final Text interstLbl = new Text();
                interstLbl.setFont(LoanerGiveLoanDialog.this.font);
                interstLbl.setText(LoanerGiveLoanDialog.this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.LoanerGiveLoanDialog.interestLevel2", new Object[0], LoanerGiveLoanDialog.this.locale.getCurrentLocal()));
                BorderPane interestPane = new BorderPane();
                interestPane.setLeft((Node)reduceInterestLbl);
                interestPane.setRight((Node)increaseInterestLbl);
                interestPane.setCenter((Node)interstLbl);
                interestSelectionPane.getChildren().add((Object)interestPane);
                LoanerGiveLoanDialog.this.loanAgreement = LoanerGiveLoanDialog.this.createLoanAggreement(LoanerGiveLoanDialog.this.interestLevels, LoanerGiveLoanDialog.this.selectedInterestLevel);
                reduceInterestLbl.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

                    public void handle(MouseEvent mouseEvent) {
                        int selectedIndex = LoanerGiveLoanDialog.this.selectedInterestLevel.get();
                        if (selectedIndex > 0) {
                            LoanerGiveLoanDialog.this.selectedInterestLevel.setValue((Number)(selectedIndex - 1));
                            LoanerGiveLoanDialog.this.box.getChildren().remove((Object)LoanerGiveLoanDialog.this.loanAgreement);
                            LoanerGiveLoanDialog.this.loanAgreement = LoanerGiveLoanDialog.this.createLoanAggreement(LoanerGiveLoanDialog.this.interestLevels, LoanerGiveLoanDialog.this.selectedInterestLevel);
                            LoanerGiveLoanDialog.this.box.getChildren().add((Object)LoanerGiveLoanDialog.this.loanAgreement);
                            interstLbl.setText(LoanerGiveLoanDialog.this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.LoanerGiveLoanDialog.interestLevel" + LoanerGiveLoanDialog.this.selectedInterestLevel.get(), new Object[0], LoanerGiveLoanDialog.this.locale.getCurrentLocal()));
                        }
                    }
                });
                increaseInterestLbl.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

                    public void handle(MouseEvent mouseEvent) {
                        int selectedIndex = LoanerGiveLoanDialog.this.selectedInterestLevel.get();
                        if (selectedIndex < LoanerGiveLoanDialog.this.interestLevels.size() - 1) {
                            LoanerGiveLoanDialog.this.selectedInterestLevel.setValue((Number)(selectedIndex + 1));
                            LoanerGiveLoanDialog.this.box.getChildren().remove((Object)LoanerGiveLoanDialog.this.loanAgreement);
                            LoanerGiveLoanDialog.this.loanAgreement = LoanerGiveLoanDialog.this.createLoanAggreement(LoanerGiveLoanDialog.this.interestLevels, LoanerGiveLoanDialog.this.selectedInterestLevel);
                            LoanerGiveLoanDialog.this.box.getChildren().add((Object)LoanerGiveLoanDialog.this.loanAgreement);
                            interstLbl.setText(LoanerGiveLoanDialog.this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.LoanerGiveLoanDialog.interestLevel" + LoanerGiveLoanDialog.this.selectedInterestLevel.get(), new Object[0], LoanerGiveLoanDialog.this.locale.getCurrentLocal()));
                        }
                    }
                });
                LoanerGiveLoanDialog.this.box.getChildren().addAll((Object[])new Node[]{subHeading, interestSelectionPane, LoanerGiveLoanDialog.this.loanAgreement});
                LoanerGiveLoanDialog.this.acceptBtn.setText(LoanerGiveLoanDialog.this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernBaseSideRoomPersonDialog.accept", new Object[0], LoanerGiveLoanDialog.this.locale.getCurrentLocal()));
                LoanerGiveLoanDialog.this.acceptBtn.setOnAction(LoanerGiveLoanDialog.this.createAcceptHandlerPage2());
            }
        };
    }

    private DecoratedText createLoanAggreement(List<Double> interestLevels, IntegerProperty selectedInterestLevel) {
        double interestSmall = interestLevels.get(selectedInterestLevel.get());
        String interest = String.format("%.1f", interestSmall * 100.0);
        int sum = ((ILoanRequest)this.selectedRequest.get()).getSum();
        int paybacksum = (int)((1.0 + interestSmall) * (double)sum);
        String s = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.LoanerGiveLoanDialog.loanAgreement", new Object[]{sum, ((ILoanRequest)this.selectedRequest.get()).getDurationInWeeks(), interest, paybacksum}, this.locale.getCurrentLocal());
        return this.textFactory.createDecoratedText(s, new HashMap());
    }

    private EventHandler<MouseEvent> createAcceptHandlerPage2() {
        return new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                ILoanRequest request = (ILoanRequest)LoanerGiveLoanDialog.this.selectedRequest.get();
                double interest = (Double)LoanerGiveLoanDialog.this.interestLevels.get(LoanerGiveLoanDialog.this.selectedInterestLevel.get()) + 1.0;
                DateTime now = LoanerGiveLoanDialog.this.date.getCurrentDate();
                Debt debt = Debt.builder().debitor(request.getCitizen()).creditor((ICreditor)LoanerGiveLoanDialog.this.city.getPlayer()).interest(interest).dueDate(now.plusWeeks(request.getDurationInWeeks())).amount(request.getSum()).loanTakeOut(now).build();
                LoanerGiveLoanDialog.this.loaner.addDebt((IDebt)debt);
                LoanerGiveLoanDialog.this.loaner.getRequests().remove(request);
                LoanerGiveLoanDialog.this.executeOnCloseButtonClicked();
            }
        };
    }

    @Override
    protected void executeOnCloseButtonClicked() {
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_LOANER);
        this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
        super.executeOnCloseButtonClicked();
    }
}

