/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.shipyard;

import ch.sahits.game.event.NoticeBoardClose;
import ch.sahits.game.graphic.display.dialog.CloseButtonDialog;
import ch.sahits.game.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ObjectPropertyType;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.city.IShipDueDate;
import ch.sahits.game.openpatrician.model.city.IShipyard;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import java.util.Arrays;
import java.util.List;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javax.annotation.PostConstruct;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="shipyardRepairListDialog")
@Scope(value="prototype")
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.SINGLETON_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class ShipyardRepairListDialogV2
extends CloseButtonDialog {
    private final ICityPlayerProxyJFX city;
    private final Font font;
    @ObjectPropertyType(value=IShipDueDate.class)
    private final ObjectProperty<IShipDueDate> selectedShip;
    @Autowired
    private Date date;
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    private GridPane grid;

    public ShipyardRepairListDialogV2(Font font, ICityPlayerProxyJFX city) {
        super(font);
        this.font = font;
        this.city = city;
        this.selectedShip = new SimpleObjectProperty((Object)this, "selectedShip", null);
    }

    @PostConstruct
    private void initializeModelAndDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.ShipyardRepairListDialogV2.title", new Object[0], this.locale.getCurrentLocal()));
        final IShipyard state = this.city.getCity().getCityState().getShipyardState();
        if (state.getShipRepairList().isEmpty()) {
            Text text = new Text(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.ShipyardRepairListDialogV2.noShipsRepairing", new Object[0], this.locale.getCurrentLocal()));
            text.setFont(this.font);
            text.setLayoutX(50.0);
            text.setLayoutY(100.0);
            this.getContent().addAll((Object[])new Node[]{text});
        } else {
            this.grid = new GridPane();
            this.grid.setLayoutX(30.0);
            this.grid.setLayoutY(100.0);
            Text headerCol1 = new Text(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.ShipyardConstructionListDialogV2.dueDate", new Object[0], this.locale.getCurrentLocal()));
            headerCol1.setFont(this.font);
            this.grid.add((Node)headerCol1, 0, 0);
            this.grid.getColumnConstraints().add((Object)new ColumnConstraints(100.0));
            Text headerCol2 = new Text(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.ShipyardRenameDialogV2.shipName", new Object[0], this.locale.getCurrentLocal()));
            headerCol2.setFont(this.font);
            this.grid.add((Node)headerCol2, 1, 0);
            this.grid.getColumnConstraints().add((Object)new ColumnConstraints(250.0));
            Text headerCol3 = new Text(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.ShipyardConstructionListDialogV2.shipType", new Object[0], this.locale.getCurrentLocal()));
            headerCol3.setFont(this.font);
            this.grid.add((Node)headerCol3, 2, 0);
            this.grid.getColumnConstraints().add((Object)new ColumnConstraints(100.0));
            for (int row = 1; row <= state.getShipRepairList().size(); ++row) {
                int index = row - 1;
                IShipDueDate dueDate = (IShipDueDate)state.getShipRepairList().get(index);
                DateTime time = dueDate.getDueDate();
                IShip ship = dueDate.getShip();
                boolean isOwnedByPlayer = ship.getOwner().equals(this.city.getPlayer());
                Text text1 = new Text(this.date.todisplayString(time.getDayOfMonth(), time.getMonthOfYear(), time.getYear()));
                text1.setFont(this.font);
                text1.setLayoutY(15.0);
                Pane col1 = new Pane();
                col1.getChildren().add((Object)text1);
                this.grid.add((Node)col1, 0, row);
                Text text2 = new Text(ship.getName());
                text2.setFont(this.font);
                text2.setLayoutY(15.0);
                Pane col2 = new Pane();
                col2.getChildren().add((Object)text2);
                this.grid.add((Node)col2, 1, row);
                Text text3 = new Text(ship.getShipType().name());
                text3.setFont(this.font);
                text3.setLayoutY(15.0);
                Pane col3 = new Pane();
                col3.getChildren().add((Object)text3);
                this.grid.add((Node)col3, 2, row);
                SelectLineEventHandler selectionLineEventHandler = new SelectLineEventHandler(dueDate, new Pane[]{col1, col2, col3});
                if (!isOwnedByPlayer) continue;
                text1.setOnMouseReleased((EventHandler)selectionLineEventHandler);
                text2.setOnMouseReleased((EventHandler)selectionLineEventHandler);
                text3.setOnMouseReleased((EventHandler)selectionLineEventHandler);
            }
            final OpenPatricianLargeWaxButton action = new OpenPatricianLargeWaxButton(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.ShipyardRepairListDialogV2.cancel", new Object[0], this.locale.getCurrentLocal()), this.font);
            action.setOnAction((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    state.cancelRepair(((IShipDueDate)ShipyardRepairListDialogV2.this.selectedShip.get()).getShip());
                    ShipyardRepairListDialogV2.this.city.getPlayersShips().add((Object)((IShipDueDate)ShipyardRepairListDialogV2.this.selectedShip.get()).getShip());
                    ShipyardRepairListDialogV2.this.executeOnCloseButtonClicked();
                }
            });
            int actionButtonX = 197;
            action.setLayoutX(197.0);
            action.setLayoutY(603.0);
            BooleanBinding actionEnabled = new BooleanBinding(){

                protected boolean computeValue() {
                    return ShipyardRepairListDialogV2.this.selectedShip.get() != null;
                }
            };
            action.setDisable(true);
            actionEnabled.addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observableValue, Boolean oldValue, Boolean newValue) {
                    action.setDisable(newValue == false);
                }
            });
            this.getContent().addAll((Object[])new Node[]{this.grid, action});
        }
    }

    @Override
    protected void executeOnCloseButtonClicked() {
        this.clientEventBus.post((Object)new NoticeBoardClose());
        super.executeOnCloseButtonClicked();
    }

    private class SelectLineEventHandler
    implements EventHandler<MouseEvent> {
        private final IShipDueDate ship;
        private final List<Pane> row;

        private SelectLineEventHandler(IShipDueDate ship, Pane ... row) {
            this.ship = ship;
            this.row = Arrays.asList(row);
        }

        public void handle(MouseEvent mouseEvent) {
            ShipyardRepairListDialogV2.this.selectedShip.set((Object)this.ship);
            for (Node node : ShipyardRepairListDialogV2.this.grid.getChildren()) {
                if (this.row.contains(node)) {
                    node.setStyle("-fx-background-color: grey");
                    continue;
                }
                node.setStyle("-fx-background-color: transparent");
            }
        }
    }
}

