/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.tavern;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.IViewChangeEvent;
import ch.sahits.game.event.NoticeBoardUpdate;
import ch.sahits.game.event.ViewChangeEvent;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.dialog.CloseButtonDialog;
import ch.sahits.game.graphic.display.dialog.util.TavernDialogUtil;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.graphic.display.notice.ENoticeItem;
import ch.sahits.game.graphic.javafx.display.MainGameView;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;
import ch.sahits.game.openpatrician.model.people.IInformant;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import java.util.HashMap;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WeakChangeListener;
import javafx.scene.Node;
import javafx.scene.text.Font;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernInformantDialogPageOne
extends CloseButtonDialog {
    private final ICityPlayerProxyJFX city;
    private final Font font;
    private final IInformant informant;
    @Autowired
    private TavernDialogUtil tavernDialogUtil;
    @Autowired
    private ClientViewState viewState;
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    private final TavernState tavernState;
    private ChangeListener<Boolean> leaving;

    public TavernInformantDialogPageOne(Font font, ICityPlayerProxyJFX city) {
        super(font);
        this.city = city;
        this.font = font;
        this.tavernState = city.getCity().getCityState().getTavernState();
        this.informant = this.tavernState.getInformant();
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernInformantDialogPageOne.title", new Object[]{this.informant.getName()}, this.locale.getCurrentLocal()));
        String loadedText = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernInformantDialogPageOne.dialog", new Object[0], this.locale.getCurrentLocal());
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        int price = this.informant.getPrice(this.city.getPlayer());
        parameters.put("price", price);
        DecoratedText dt = this.decoratedTextFactory.createDecoratedText(loadedText, parameters);
        OpenPatricianLargeWaxButton acceptButton = new OpenPatricianLargeWaxButton(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernInformantDialogPageOne.buy", new Object[0], this.locale.getCurrentLocal()), this.font);
        int BUTTON_X = 197;
        acceptButton.setLayoutX((double)BUTTON_X);
        int LOWER_BUTTON_Y = 603;
        acceptButton.setLayoutY((double)LOWER_BUTTON_Y);
        acceptButton.setOnAction(mouseEvent -> {
            this.city.getPlayer().getCompany().updateCash((long)(-price));
            this.clientEventBus.post((Object)new ViewChangeEvent(MainGameView.class, (Object)ENoticeItem.TAVERN_INFORMANT_2));
        });
        this.leaving = (observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.executeOnCloseButtonClicked();
            }
        };
        this.informant.isPresentProperty().addListener((ChangeListener)new WeakChangeListener(this.leaving));
        this.getContent().addAll((Object[])new Node[]{dt, acceptButton});
    }

    @Override
    protected void executeOnCloseButtonClicked() {
        this.tavernDialogUtil.stopTalkingToPerson(this.tavernState, this.city.getPlayer());
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_TAVERN);
        this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
        super.executeOnCloseButtonClicked();
    }
}

