/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.tavern;

import ch.sahits.game.event.data.PatrolInternalState;
import ch.sahits.game.event.handler.IAttackListener;
import ch.sahits.game.event.handler.impl.EventHandlerFactory;
import ch.sahits.game.graphic.display.dialog.tavern.TavernBaseSideRoomPersonDialog;
import ch.sahits.game.graphic.event.task.ClientTaskFactory;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.people.IPatrol;
import ch.sahits.game.openpatrician.model.people.ISideRoomPerson;
import ch.sahits.game.openpatrician.model.ship.IShip;
import com.google.common.eventbus.AsyncEventBus;
import java.util.HashMap;
import java.util.Random;
import javafx.beans.binding.BooleanBinding;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.text.Font;
import javax.annotation.PostConstruct;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernPatrolDialog
extends TavernBaseSideRoomPersonDialog {
    @Autowired
    private Random rnd;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    private EventHandlerFactory eventHandlerFactory;
    @Autowired
    private ClientTaskFactory taskFactory;

    public TavernPatrolDialog(Font font, ICityPlayerProxyJFX city) {
        super(font, city, (ISideRoomPerson)city.getCity().getCityState().getTavernState().getPatrol());
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.openpatrician.model.people.impl.PatrolState.noticeboardTitle", new Object[0], this.locale.getCurrentLocal()));
        this.initializeButtons();
        IPatrol patrol = (IPatrol)this.currentPerson.get();
        String loadedText = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernPatrolDialog.dialog", new Object[0], this.locale.getCurrentLocal());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("patrolName", patrol.getName());
        parameters.put("price", patrol.getPremium());
        DecoratedText dt = this.decoratedTextFactory.createDecoratedText(loadedText, parameters);
        this.getContent().addAll((Object[])new Node[]{dt});
    }

    @Override
    protected EventHandler<MouseEvent> createAcceptHandler() {
        return new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                IPatrol patrol = (IPatrol)TavernPatrolDialog.this.currentPerson.get();
                PatrolInternalState patrolState = new PatrolInternalState(patrol.getPremium(), patrol.getBonus(), patrol.getDestinations());
                IShip ship = TavernPatrolDialog.this.city.getActiveShip();
                IPlayer player = TavernPatrolDialog.this.city.getPlayer();
                IAttackListener attackListener = TavernPatrolDialog.this.eventHandlerFactory.getAttackListener(ship, patrolState);
                int minutes = TavernPatrolDialog.this.rnd.nextInt(600);
                DateTime postMessage = TavernPatrolDialog.this.date.getCurrentDate().plusMinutes(minutes);
                String cityName = patrolState.nextDestination().get().getName();
                String message = TavernPatrolDialog.this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernPatrolDialog.acceptMessage", new Object[]{ship.getName(), cityName}, TavernPatrolDialog.this.locale.getCurrentLocal());
                TavernPatrolDialog.this.taskFactory.getPostponedDisplayMessage(postMessage, message);
                DateTime firstDeadline = TavernPatrolDialog.this.date.getCurrentDate().plusDays(6);
                TavernPatrolDialog.this.eventHandlerFactory.getNextPatrolStateion(ship, patrolState.nextDestination().get(), patrolState, player, firstDeadline, attackListener);
                patrol.leave();
                TavernPatrolDialog.this.executeOnCloseButtonClicked();
            }
        };
    }

    @Override
    protected BooleanBinding disableAcceptButton() {
        return new BooleanBinding(){

            protected boolean computeValue() {
                for (IShip ship : TavernPatrolDialog.this.city.getPlayersShips()) {
                    if (ship.getCaptian() == null) continue;
                    return false;
                }
                return true;
            }
        };
    }
}

