/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.tavern;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.IViewChangeEvent;
import ch.sahits.game.event.NoticeBoardUpdate;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.dialog.CloseButtonDialog;
import ch.sahits.game.graphic.display.dialog.util.DialogUtil;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.javafx.control.OpenPatricianSmallWaxButton;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ObjectPropertyType;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.people.ISailorState;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernSailorDialog
extends CloseButtonDialog {
    private final ICityPlayerProxyJFX city;
    private final Font font;
    private final ISailorState sailorState;
    @ObjectPropertyType(value=IShip.class)
    private final ObjectProperty<IShip> currentShip;
    @Autowired
    private DialogUtil dialogUtil;
    @Autowired
    private ClientViewState viewState;
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    private ChangeListener<Number> sailorNumberListener;

    public TavernSailorDialog(Font font, ICityPlayerProxyJFX city) {
        super(font);
        this.city = city;
        this.font = font;
        this.sailorState = city.getCity().getCityState().getTavernState().getSailors();
        this.currentShip = new SimpleObjectProperty((Object)this, "currentShip", (Object)city.getActiveShip());
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernSailorDialog.title", new Object[0], this.locale.getCurrentLocal()));
        VBox topText = new VBox();
        topText.setLayoutX(30.0);
        topText.setLayoutY(100.0);
        Text firstLine = new Text();
        firstLine.setFont(this.font);
        StringBinding firstLineBinding = new StringBinding(){

            protected String computeValue() {
                if (TavernSailorDialog.this.sailorState.getNumberOfSailors() > 1) {
                    return TavernSailorDialog.this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernSailorDialog.dialog1", new Object[]{TavernSailorDialog.this.sailorState.getNumberOfSailors()}, TavernSailorDialog.this.locale.getCurrentLocal());
                }
                if (TavernSailorDialog.this.sailorState.getNumberOfSailors() == 1) {
                    return TavernSailorDialog.this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernSailorDialog.dialog2", new Object[0], TavernSailorDialog.this.locale.getCurrentLocal());
                }
                return TavernSailorDialog.this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernSailorDialog.dialog3", new Object[0], TavernSailorDialog.this.locale.getCurrentLocal());
            }
        };
        firstLine.textProperty().bind((ObservableValue)firstLineBinding);
        Text secondLine = new Text();
        secondLine.setFont(this.font);
        secondLine.setText(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernSailorDialog.dialog4", new Object[0], this.locale.getCurrentLocal()));
        topText.getChildren().addAll((Object[])new Node[]{firstLine, secondLine});
        this.getContent().add((Object)topText);
        SimpleIntegerProperty sailorsAdditionalOnShip = new SimpleIntegerProperty(0);
        SimpleIntegerProperty sailorsInTavern = new SimpleIntegerProperty(this.sailorState.getNumberOfSailors());
        this.currentShip.addListener((arg_0, arg_1, arg_2) -> this.lambda$initializeDialog$89((IntegerProperty)sailorsAdditionalOnShip, (IntegerProperty)sailorsInTavern, arg_0, arg_1, arg_2));
        this.sailorNumberListener = (arg_0, arg_1, arg_2) -> TavernSailorDialog.lambda$initializeDialog$90((IntegerProperty)sailorsAdditionalOnShip, (IntegerProperty)sailorsInTavern, arg_0, arg_1, arg_2);
        this.sailorState.numberOfSailorsProperty().addListener((ChangeListener)new WeakChangeListener(this.sailorNumberListener));
        GridPane sailorsPane = this.createSailorMoveControls((IntegerProperty)sailorsAdditionalOnShip, (IntegerProperty)sailorsInTavern);
        this.getContent().add((Object)sailorsPane);
        Text selectedShip = new Text(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernSailorDialog.dialog5", new Object[0], this.locale.getCurrentLocal()));
        selectedShip.setFont(this.font);
        selectedShip.setLayoutX(30.0);
        selectedShip.setLayoutY(250.0);
        this.getContent().add((Object)selectedShip);
        if (this.currentShip.get() == null) {
            Text noShip = new Text(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernCaptainDialog.noShip", new Object[0], this.locale.getCurrentLocal()));
            noShip.setFont(this.font);
            noShip.setLayoutX(30.0);
            noShip.setLayoutY(300.0);
            this.getContent().add((Object)noShip);
        } else {
            GridPane shipSelectionPane = this.dialogUtil.createShipSelection3Lines(this.city, this.currentShip, this.font);
            shipSelectionPane.setLayoutX(30.0);
            shipSelectionPane.setLayoutY(300.0);
            this.getContent().add((Object)shipSelectionPane);
        }
        int actionButtonX = 197;
        OpenPatricianLargeWaxButton action = new OpenPatricianLargeWaxButton(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernSailorDialog.hire", new Object[0], this.locale.getCurrentLocal()), this.font);
        action.setOnAction(arg_0 -> this.lambda$initializeDialog$91((IntegerProperty)sailorsAdditionalOnShip, (IntegerProperty)sailorsInTavern, arg_0));
        action.setLayoutX(197.0);
        action.setLayoutY(603.0);
        BooleanBinding enableAction = new BooleanBinding((IntegerProperty)sailorsAdditionalOnShip){
            final /* synthetic */ IntegerProperty val$sailorsAdditionalOnShip;
            {
                this.val$sailorsAdditionalOnShip = integerProperty;
                super.bind(new Observable[]{TavernSailorDialog.this.currentShip, this.val$sailorsAdditionalOnShip});
            }

            protected boolean computeValue() {
                return TavernSailorDialog.this.currentShip.get() != null && this.val$sailorsAdditionalOnShip.get() > 0;
            }
        };
        action.setDisable(!enableAction.get());
        enableAction.addListener((observableValue, oldValue, newValue) -> action.setDisable(newValue == false));
        this.getContent().add((Object)action);
    }

    private GridPane createSailorMoveControls(final IntegerProperty sailorsOnShip, final IntegerProperty sailorsInTavern) {
        GridPane sailorsPane = new GridPane();
        sailorsPane.setLayoutX(100.0);
        sailorsPane.setLayoutY(150.0);
        RowConstraints rowConstraint = new RowConstraints(24.0);
        sailorsPane.getRowConstraints().addAll((Object[])new RowConstraints[]{rowConstraint, rowConstraint});
        ColumnConstraints colConstraint = new ColumnConstraints(64.0);
        sailorsPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{colConstraint, colConstraint, colConstraint, colConstraint});
        Text tavernTxt = new Text(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernSailorDialog.tavern", new Object[0], this.locale.getCurrentLocal()));
        tavernTxt.setFont(this.font);
        sailorsPane.add((Node)tavernTxt, 0, 0);
        GridPane.setHalignment((Node)tavernTxt, (HPos)HPos.CENTER);
        Text shipTxt = new Text(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.BaseTradeDialog.ship", new Object[0], this.locale.getCurrentLocal()));
        shipTxt.setFont(this.font);
        sailorsPane.add((Node)shipTxt, 3, 0);
        GridPane.setHalignment((Node)shipTxt, (HPos)HPos.CENTER);
        Text nbInTavern = new Text();
        nbInTavern.setFont(this.font);
        nbInTavern.textProperty().bind((ObservableValue)sailorsInTavern.asString());
        sailorsPane.add((Node)nbInTavern, 0, 1);
        GridPane.setHalignment((Node)nbInTavern, (HPos)HPos.CENTER);
        final OpenPatricianSmallWaxButton toTavernBtn = new OpenPatricianSmallWaxButton("<");
        toTavernBtn.setOnAction((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (sailorsOnShip.get() > 0) {
                    sailorsOnShip.set(sailorsOnShip.get() - 1);
                    sailorsInTavern.set(sailorsInTavern.get() + 1);
                }
            }
        });
        if (sailorsOnShip.get() < 1 || this.currentShip.get() == null) {
            toTavernBtn.setDisable(true);
        }
        sailorsPane.add((Node)toTavernBtn, 1, 1);
        GridPane.setHalignment((Node)toTavernBtn, (HPos)HPos.CENTER);
        final OpenPatricianSmallWaxButton toShipBtn = new OpenPatricianSmallWaxButton(">");
        toShipBtn.setOnAction((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (sailorsInTavern.get() > 0) {
                    sailorsOnShip.set(sailorsOnShip.get() + 1);
                    sailorsInTavern.set(sailorsInTavern.get() - 1);
                }
            }
        });
        sailorsOnShip.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number oldValue, Number newValue) {
                if (newValue.intValue() <= 0) {
                    toTavernBtn.setDisable(true);
                } else {
                    toTavernBtn.setDisable(false);
                }
                if (sailorsInTavern.get() <= 0 || newValue.intValue() + ((IShip)TavernSailorDialog.this.currentShip.get()).getNumberOfSailors() >= ((IShip)TavernSailorDialog.this.currentShip.get()).getMaxNumberOfSailors()) {
                    toShipBtn.setDisable(true);
                } else {
                    toShipBtn.setDisable(false);
                }
            }
        });
        sailorsInTavern.addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number oldValue, Number newValue) {
                if (newValue.intValue() <= 0 || sailorsOnShip.get() + ((IShip)TavernSailorDialog.this.currentShip.get()).getNumberOfSailors() >= ((IShip)TavernSailorDialog.this.currentShip.get()).getMaxNumberOfSailors()) {
                    toShipBtn.setDisable(true);
                } else {
                    toShipBtn.setDisable(false);
                }
            }
        });
        if (sailorsInTavern.get() < 1 || this.currentShip.get() == null || ((IShip)this.currentShip.get()).getNumberOfSailors() == ((IShip)this.currentShip.get()).getMaxNumberOfSailors()) {
            toShipBtn.setDisable(true);
        }
        sailorsPane.add((Node)toShipBtn, 2, 1);
        GridPane.setHalignment((Node)toShipBtn, (HPos)HPos.CENTER);
        Text nbInShip = new Text();
        nbInShip.setFont(this.font);
        nbInShip.textProperty().bind((ObservableValue)sailorsOnShip.asString());
        sailorsPane.add((Node)nbInShip, 3, 1);
        GridPane.setHalignment((Node)nbInShip, (HPos)HPos.CENTER);
        return sailorsPane;
    }

    @Override
    protected void executeOnCloseButtonClicked() {
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_TAVERN);
        this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
        super.executeOnCloseButtonClicked();
    }

    private /* synthetic */ void lambda$initializeDialog$91(IntegerProperty sailorsAdditionalOnShip, IntegerProperty sailorsInTavern, MouseEvent mouseEvent) {
        ((IShip)this.currentShip.get()).setNumberOfSailors(sailorsAdditionalOnShip.get() + ((IShip)this.currentShip.get()).getNumberOfSailors());
        sailorsAdditionalOnShip.setValue((Number)0);
        this.sailorState.setNumberOfSailors(sailorsInTavern.get());
        this.executeOnCloseButtonClicked();
    }

    private static /* synthetic */ void lambda$initializeDialog$90(IntegerProperty sailorsAdditionalOnShip, IntegerProperty sailorsInTavern, ObservableValue observableValue, Number oldValue, Number newValue) {
        int inTavern = newValue.intValue() - sailorsAdditionalOnShip.get();
        if (inTavern < 0) {
            sailorsAdditionalOnShip.set(Math.max(sailorsAdditionalOnShip.get() + inTavern, 0));
            inTavern = 0;
        }
        sailorsInTavern.set(inTavern);
    }

    private /* synthetic */ void lambda$initializeDialog$89(IntegerProperty sailorsAdditionalOnShip, IntegerProperty sailorsInTavern, ObservableValue observableValue, IShip oldValue, IShip newValue) {
        sailorsAdditionalOnShip.set(newValue.getNumberOfSailors());
        sailorsInTavern.set(this.sailorState.getNumberOfSailors());
    }
}

