/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.tavern;

import ch.sahits.game.event.handler.impl.EventHandlerFactory;
import ch.sahits.game.graphic.display.dialog.tavern.TavernBaseSideRoomPersonDialog;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.people.ISideRoomPerson;
import ch.sahits.game.openpatrician.model.people.ISmuggler;
import ch.sahits.game.openpatrician.model.ship.IShip;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import javafx.beans.binding.BooleanBinding;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.text.Font;
import javax.annotation.PostConstruct;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernSmugglerDialog
extends TavernBaseSideRoomPersonDialog {
    @Autowired
    private EventHandlerFactory eventHandlerFactory;

    public TavernSmugglerDialog(Font font, ICityPlayerProxyJFX city) {
        super(font, city, (ISideRoomPerson)city.getCity().getCityState().getTavernState().getSmuggler());
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernSmugglerDialog.title", new Object[0], this.locale.getCurrentLocal()));
        this.initializeButtons();
        ISmuggler smuggler = (ISmuggler)this.currentPerson.get();
        String loadedText = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernSmugglerDialog.dialog", new Object[0], this.locale.getCurrentLocal());
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("amount", smuggler.getAmount());
        DecoratedText dt = this.decoratedTextFactory.createDecoratedText(loadedText, parameters);
        this.getContent().addAll((Object[])new Node[]{dt});
    }

    @Override
    protected EventHandler<MouseEvent> createAcceptHandler() {
        return mouseEvent -> {
            ArrayList ships = Lists.newArrayList((Iterable)this.city.getPlayersShips());
            Collections.shuffle(ships);
            ISmuggler smuggler = (ISmuggler)this.currentPerson.get();
            boolean shipFound = false;
            for (IShip ship : ships) {
                if (ship.getCapacity() <= smuggler.getAmount()) continue;
                ship.setOccupiedSpace(smuggler.getAmount());
                shipFound = true;
                break;
            }
            if (!shipFound) {
                DateTime deadline = this.date.getCurrentDate().plusDays(10);
                this.eventHandlerFactory.getShipArrivalForLoadingHandler(this.city.getCity(), this.city.getPlayer(), deadline, smuggler.getAmount(), smuggler.getPremium());
            }
            smuggler.leave();
            this.executeOnCloseButtonClicked();
        };
    }

    @Override
    protected BooleanBinding disableAcceptButton() {
        return new BooleanBinding(){

            protected boolean computeValue() {
                ISmuggler smuggler = (ISmuggler)TavernSmugglerDialog.this.currentPerson.get();
                return TavernSmugglerDialog.this.tavernDialogUtil.noShipWithEnoughCapacityAvailable(TavernSmugglerDialog.this.city, smuggler.getAmount() / 10);
            }
        };
    }
}

