/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.tavern;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.IViewChangeEvent;
import ch.sahits.game.event.NoticeBoardUpdate;
import ch.sahits.game.event.handler.impl.EventHandlerFactory;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.dialog.CloseButtonDialog;
import ch.sahits.game.graphic.display.dialog.util.TavernDialogUtil;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;
import ch.sahits.game.openpatrician.model.people.IPerson;
import ch.sahits.game.openpatrician.model.people.ITraveler;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.util.ModelTranslations;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import java.util.HashMap;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WeakChangeListener;
import javafx.scene.Node;
import javafx.scene.text.Font;
import javax.annotation.PostConstruct;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernTravelerDialog
extends CloseButtonDialog {
    @Autowired
    private TavernDialogUtil tavernUtil;
    @Autowired
    private Date date;
    @Autowired
    private ClientViewState viewState;
    @Autowired
    private EventHandlerFactory eventHandlerFactory;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private ModelTranslations modelTranslator;
    private final ICityPlayerProxyJFX city;
    private final Font font;
    private final TavernState tavernState;
    private final ITraveler traveler;
    private ChangeListener<Boolean> leaving;

    public TavernTravelerDialog(Font font, ICityPlayerProxyJFX city) {
        super(font);
        this.font = font;
        this.city = city;
        this.tavernState = city.getCity().getCityState().getTavernState();
        this.traveler = this.tavernState.getTraveler();
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernTravelerDialog.title", new Object[0], this.locale.getCurrentLocal()));
        IPlayer player = this.city.getPlayer();
        DateTime arrivalDate = this.traveler.getArrivalDate();
        String d = this.date.todisplayString(arrivalDate.getDayOfMonth(), arrivalDate.getMonthOfYear(), arrivalDate.getYear());
        String loadedText = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernTravelerDialog.dialog", new Object[]{this.city.getPlayer().getLastName(), this.modelTranslator.getLocalDisplayName(player.getCareerLevel()), player.getName(), this.traveler.getDestination().getName(), d}, this.locale.getCurrentLocal());
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("amount", this.traveler.getPremium());
        DecoratedText dt = this.decoratedTextFactory.createDecoratedText(loadedText, parameters);
        OpenPatricianLargeWaxButton acceptButton = new OpenPatricianLargeWaxButton(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernBaseSideRoomPersonDialog.accept", new Object[0], this.locale.getCurrentLocal()), this.font);
        int BUTTON_X = 197;
        acceptButton.setLayoutX((double)BUTTON_X);
        int LOWER_BUTTON_Y = 603;
        acceptButton.setLayoutY((double)LOWER_BUTTON_Y);
        acceptButton.setOnAction(mouseEvent -> {
            IShip ship = this.city.getActiveShip();
            if (ship != null) {
                ship.addPassenger((IPerson)this.traveler);
                this.eventHandlerFactory.getPassengerLeavingOnShipArrivalHandler(ship, this.traveler.getDestination(), this.city.getPlayer(), this.traveler.getPremium());
                this.clientEventBus.post((Object)new DisplayMessage(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernBaseSideRoomPersonDialog.acceptMessage", new Object[]{ship.getName()}, this.locale.getCurrentLocal())));
                this.executeOnCloseButtonClicked();
                this.traveler.leave();
            }
        });
        BooleanBinding disable = this.disableAcceptBinding();
        acceptButton.setDisable(disable.get());
        disable.addListener((observableValue, oldValue, newValue) -> acceptButton.setDisable(newValue.booleanValue()));
        this.leaving = (observable, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.executeOnCloseButtonClicked();
            }
        };
        this.traveler.isPresentProperty().addListener((ChangeListener)new WeakChangeListener(this.leaving));
        this.getContent().addAll((Object[])new Node[]{dt, acceptButton});
    }

    private BooleanBinding disableAcceptBinding() {
        return new BooleanBinding(){

            protected boolean computeValue() {
                return TavernTravelerDialog.this.city.getActiveShip() == null;
            }
        };
    }

    @Override
    protected void executeOnCloseButtonClicked() {
        this.tavernUtil.stopTalkingToPerson(this.tavernState, this.city.getPlayer());
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_TAVERN);
        this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
        super.executeOnCloseButtonClicked();
    }
}

