/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.tavern;

import ch.sahits.game.graphic.display.dialog.tavern.TavernBaseSideRoomPersonDialog;
import ch.sahits.game.graphic.event.task.ClientTaskFactory;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.MapSegmentedImage;
import ch.sahits.game.openpatrician.model.people.ISideRoomPerson;
import ch.sahits.game.openpatrician.model.people.ITreasureMapOwner;
import ch.sahits.game.openpatrician.util.MapSegmentImageFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import javafx.application.Platform;
import javafx.beans.binding.BooleanBinding;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.text.Font;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernTreasureMapOwnerDialog
extends TavernBaseSideRoomPersonDialog {
    @Autowired
    private Random rnd;
    @Autowired
    private ClientTaskFactory taskFactory;
    @Autowired
    private MapSegmentImageFactory segmentFactory;

    public TavernTreasureMapOwnerDialog(Font font, ICityPlayerProxyJFX city) {
        super(font, city, (ISideRoomPerson)city.getCity().getCityState().getTavernState().getTreasureMap());
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernTreasureMapOwnerDialog.title", new Object[0], this.locale.getCurrentLocal()));
        this.initializeButtons();
        ITreasureMapOwner mapOwner = (ITreasureMapOwner)this.currentPerson.get();
        String loadedText = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernTreasureMapOwnerDialog.dialog", new Object[]{this.city.getPlayer().getLastName()}, this.locale.getCurrentLocal());
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("price", mapOwner.getPrice());
        DecoratedText dt = this.decoratedTextFactory.createDecoratedText(loadedText, parameters);
        this.getContent().addAll((Object[])new Node[]{dt});
    }

    @Override
    protected EventHandler<MouseEvent> createAcceptHandler() {
        return new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                TavernTreasureMapOwnerDialog.this.removeDecoratedContent();
                TavernTreasureMapOwnerDialog.this.removeAcceptButton();
                MapSegmentedImage imageMap = TavernTreasureMapOwnerDialog.this.segmentFactory.getRandomTreasureNest();
                String loadedText = TavernTreasureMapOwnerDialog.this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernTreasureMapOwnerDialog.acceptMessage", new Object[]{imageMap.getImageName()}, TavernTreasureMapOwnerDialog.this.locale.getCurrentLocal());
                HashMap parameters = new HashMap();
                ArrayList visibleSegs = new ArrayList();
                visibleSegs.addAll(imageMap.getSegmentIndices());
                parameters.put("visibleSegments", visibleSegs);
                final DecoratedText dt = TavernTreasureMapOwnerDialog.this.decoratedTextFactory.createDecoratedText(loadedText, parameters);
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        TavernTreasureMapOwnerDialog.this.getContent().add((Object)dt);
                    }
                });
                IPlayer player = TavernTreasureMapOwnerDialog.this.city.getPlayer();
                player.setSegmentedMap(imageMap);
                ITreasureMapOwner mapOwner = (ITreasureMapOwner)TavernTreasureMapOwnerDialog.this.currentPerson.get();
                player.getCompany().updateCash((long)(-mapOwner.getPrice()));
                mapOwner.leave();
                TavernTreasureMapOwnerDialog.this.executeOnCloseButtonClicked();
            }
        };
    }

    @Override
    protected BooleanBinding disableAcceptButton() {
        return new BooleanBinding(){

            protected boolean computeValue() {
                return false;
            }
        };
    }
}

