/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.util;

import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.dialog.AutomaticTradingOverviewDialog;
import ch.sahits.game.graphic.display.dialog.CityProductionConsumptionDialog;
import ch.sahits.game.graphic.display.dialog.CityShipTradeDialog;
import ch.sahits.game.graphic.display.dialog.CityStorageTradeDialog;
import ch.sahits.game.graphic.display.dialog.GenericCloseButtonDialog;
import ch.sahits.game.graphic.display.dialog.HistoryStandaloneDialog;
import ch.sahits.game.graphic.display.dialog.PersonalDialog;
import ch.sahits.game.graphic.display.dialog.StorageOverviewDialog;
import ch.sahits.game.graphic.display.dialog.StorageShipTradeDialog;
import ch.sahits.game.graphic.display.dialog.TradeOfficeBalanceDialog;
import ch.sahits.game.graphic.display.dialog.WareInStockDialog;
import ch.sahits.game.graphic.display.dialog.WeaponInventoryDialog;
import ch.sahits.game.graphic.display.dialog.church.ChurchExtensionDialog;
import ch.sahits.game.graphic.display.dialog.church.ChurchFeedingDialog;
import ch.sahits.game.graphic.display.dialog.church.ChurchGiftDialog;
import ch.sahits.game.graphic.display.dialog.cityhall.CityWallBuildingDialog;
import ch.sahits.game.graphic.display.dialog.cityhall.EldermanOfficeDialog;
import ch.sahits.game.graphic.display.dialog.cityhall.HanseaticInfoDialog;
import ch.sahits.game.graphic.display.dialog.cityhall.MeetingRoomDialog;
import ch.sahits.game.graphic.display.dialog.cityhall.OutriggerNoticeDialog;
import ch.sahits.game.graphic.display.dialog.cityhall.PublicNoticeDialog;
import ch.sahits.game.graphic.display.dialog.cityhall.TownInfoDialog;
import ch.sahits.game.graphic.display.dialog.cityhall.TreasuryDialog;
import ch.sahits.game.graphic.display.dialog.loaner.LoanerGiveLoanDialog;
import ch.sahits.game.graphic.display.dialog.loaner.LoanerListLoansDialog;
import ch.sahits.game.graphic.display.dialog.loaner.LoanerPaybackDialog;
import ch.sahits.game.graphic.display.dialog.loaner.LoanerTakeLoanDialog;
import ch.sahits.game.graphic.display.dialog.shipyard.ShipRepairDialogV2;
import ch.sahits.game.graphic.display.dialog.shipyard.ShipyardConstructionDialogV2;
import ch.sahits.game.graphic.display.dialog.shipyard.ShipyardConstructionListDialogV2;
import ch.sahits.game.graphic.display.dialog.shipyard.ShipyardRenameDialogV2;
import ch.sahits.game.graphic.display.dialog.shipyard.ShipyardRepairListDialogV2;
import ch.sahits.game.graphic.display.dialog.shipyard.ShipyardUpgradeDialogV2;
import ch.sahits.game.graphic.display.dialog.tavern.TavernBurglarDialog;
import ch.sahits.game.graphic.display.dialog.tavern.TavernBuyerDialog;
import ch.sahits.game.graphic.display.dialog.tavern.TavernCaptainDialog;
import ch.sahits.game.graphic.display.dialog.tavern.TavernConcurrentDialog;
import ch.sahits.game.graphic.display.dialog.tavern.TavernCourierDialog;
import ch.sahits.game.graphic.display.dialog.tavern.TavernEscortDialog;
import ch.sahits.game.graphic.display.dialog.tavern.TavernFugativeDialog;
import ch.sahits.game.graphic.display.dialog.tavern.TavernInformantDialogPageOne;
import ch.sahits.game.graphic.display.dialog.tavern.TavernInformantDialogPageTwo;
import ch.sahits.game.graphic.display.dialog.tavern.TavernPatrolDialog;
import ch.sahits.game.graphic.display.dialog.tavern.TavernPirateDialog;
import ch.sahits.game.graphic.display.dialog.tavern.TavernPirateHunterDialog;
import ch.sahits.game.graphic.display.dialog.tavern.TavernSailorDialog;
import ch.sahits.game.graphic.display.dialog.tavern.TavernSmugglerDialog;
import ch.sahits.game.graphic.display.dialog.tavern.TavernTraderDialog;
import ch.sahits.game.graphic.display.dialog.tavern.TavernTransportTraderDialog;
import ch.sahits.game.graphic.display.dialog.tavern.TavernTravelerDialog;
import ch.sahits.game.graphic.display.dialog.tavern.TavernTreasureMapOwnerDialog;
import ch.sahits.game.graphic.display.dialog.tavern.TavernWarehouseTenantDialog;
import ch.sahits.game.graphic.display.dialog.tavern.TavernWeaponsDealerDialog;
import ch.sahits.game.graphic.display.dialog.util.EDialogType;
import ch.sahits.game.graphic.image.IFontLoader;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.dialog.Dialog;
import ch.sahits.game.openpatrician.dialog.DialogTemplate;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;
import ch.sahits.game.openpatrician.model.people.IBuyer;
import ch.sahits.game.openpatrician.model.people.IConcurrent;
import ch.sahits.game.openpatrician.model.people.ICourier;
import ch.sahits.game.openpatrician.model.people.IEscorte;
import ch.sahits.game.openpatrician.model.people.IFugitive;
import ch.sahits.game.openpatrician.model.people.IPatrol;
import ch.sahits.game.openpatrician.model.people.IPirateHunter;
import ch.sahits.game.openpatrician.model.people.ISideRoomPerson;
import ch.sahits.game.openpatrician.model.people.ISmuggler;
import ch.sahits.game.openpatrician.model.people.IThieve;
import ch.sahits.game.openpatrician.model.people.ITransportTrader;
import ch.sahits.game.openpatrician.model.people.ITreasureMapOwner;
import ch.sahits.game.openpatrician.model.people.IWarehouseTenant;
import ch.sahits.game.openpatrician.util.StartNewGameBean;
import java.util.List;
import javafx.scene.text.Font;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class DialogFactory {
    @Autowired
    private ApplicationContext context;
    @Autowired
    private IFontLoader fontLoader;
    @Autowired
    private ClientViewState clientViewState;

    public Dialog getDialog(DialogTemplate template) {
        Font font = this.fontLoader.createDefaultFont(18);
        System.out.println("Create a dialog from a template");
        return (GenericCloseButtonDialog)((Object)this.context.getBean("genericCloseButtonDialog", new Object[]{font, template}));
    }

    private HistoryStandaloneDialog getHistoryDialog(ICityPlayerProxyJFX cityProxy, String resourceName) {
        Font font = this.fontLoader.createDefaultFont(18);
        return (HistoryStandaloneDialog)((Object)this.context.getBean("historyStandaloneDialog", new Object[]{font, cityProxy, resourceName}));
    }

    private String getHistoryResourceName(String name) {
        return "history." + name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dialog getDialog(EDialogType dialogType, ICityPlayerProxyJFX cityProxy) {
        Font font = this.fontLoader.createDefaultFont(18);
        switch (dialogType) {
            case CITY_TO_SHIP: {
                return (CityShipTradeDialog)this.context.getBean("cityShipTradeDialog", new Object[]{font, cityProxy});
            }
            case CITY_TO_STORAGE: {
                return (CityStorageTradeDialog)this.context.getBean("cityStorageTradeDialog", new Object[]{font, cityProxy});
            }
            case STORAGE_TO_SHIP: {
                return (StorageShipTradeDialog)this.context.getBean("storageShipTradeDialog", new Object[]{font, cityProxy});
            }
            case TO_BALANCE: {
                return (TradeOfficeBalanceDialog)((Object)this.context.getBean("tradeOfficeBalanceDialog", new Object[]{font, cityProxy}));
            }
            case TO_PERSONAL: {
                return (PersonalDialog)((Object)this.context.getBean("personalDialog", new Object[]{font, cityProxy}));
            }
            case TO_CONSUMPTION_PRODUCTION: 
            case MB_CONSUMPTION_PRODUCTION: {
                return (CityProductionConsumptionDialog)((Object)this.context.getBean("cityProductionConsumptionDialog", new Object[]{font, cityProxy}));
            }
            case TO_WEAPONS: {
                return (WeaponInventoryDialog)((Object)this.context.getBean("weaponInventoryDialog", new Object[]{font, cityProxy}));
            }
            case TO_WAREHOUSES: {
                return (StorageOverviewDialog)((Object)this.context.getBean("storageOverviewDialog", new Object[]{font, cityProxy}));
            }
            case TO_OFFICE_TRADING: {
                return (AutomaticTradingOverviewDialog)((Object)this.context.getBean("automaticTradingOverviewDialog", new Object[]{font, cityProxy}));
            }
            case MB_STOCK_PRICES: {
                return (WareInStockDialog)((Object)this.context.getBean("wareInStockDialog", new Object[]{font, cityProxy}));
            }
            case SHIPYARD_CONSTRUCTION: {
                return (ShipyardConstructionDialogV2)((Object)this.context.getBean("shipyardConstructionDialog", new Object[]{font, cityProxy}));
            }
            case SHIPYARD_REPAIR: {
                return (ShipRepairDialogV2)((Object)this.context.getBean("shipRepairDialog", new Object[]{font, cityProxy}));
            }
            case SHIPYARD_CONSTRUCTION_LIST: {
                return (ShipyardConstructionListDialogV2)((Object)this.context.getBean("shipyardConstructionListDialog", new Object[]{font, cityProxy}));
            }
            case SHIPYARD_REPAIR_LIST: {
                return (ShipyardRepairListDialogV2)((Object)this.context.getBean("shipyardRepairListDialog", new Object[]{font, cityProxy}));
            }
            case SHIPYARD_UPGRADE: {
                return (ShipyardUpgradeDialogV2)((Object)this.context.getBean("shipyardUpgradeDialog", new Object[]{font, cityProxy}));
            }
            case SHIPYARD_RENAME: {
                return (ShipyardRenameDialogV2)((Object)this.context.getBean("shipyardRenameDialog", new Object[]{font, cityProxy}));
            }
            case TAVERN_SAILORS: {
                return (TavernSailorDialog)((Object)this.context.getBean("tavernSailorDialog", new Object[]{font, cityProxy}));
            }
            case TAVERN_CAPTAIN: {
                return (TavernCaptainDialog)((Object)this.context.getBean("tavernCaptainDialog", new Object[]{font, cityProxy}));
            }
            case TAVERN_WEAPONS_DEALER: {
                return (TavernWeaponsDealerDialog)((Object)this.context.getBean("tavernWeaponsDealerDialog", new Object[]{font, cityProxy}));
            }
            case TAVERN_PIRATE: {
                return (TavernPirateDialog)this.context.getBean("tavernPirateDialog", new Object[]{font, cityProxy});
            }
            case TAVERN_TRADER: {
                return (TavernTraderDialog)((Object)this.context.getBean("tavernTraderDialog", new Object[]{font, cityProxy}));
            }
            case TAVERN_TRAVELER: {
                return (TavernTravelerDialog)((Object)this.context.getBean("tavernTravelerDialog", new Object[]{font, cityProxy}));
            }
            case TAVERN_TREASUREMAP_OWNER: {
                return (TavernTreasureMapOwnerDialog)((Object)this.context.getBean("tavernTreasureMapOwnerDialog", new Object[]{font, cityProxy}));
            }
            case TAVERN_INFORMANT_1: {
                return (TavernInformantDialogPageOne)((Object)this.context.getBean("tavernInformantDialogPageOne", new Object[]{font, cityProxy}));
            }
            case TAVERN_INFORMANT_2: {
                return (TavernInformantDialogPageTwo)((Object)this.context.getBean("tavernInformantDialogPageTwo", new Object[]{font, cityProxy}));
            }
            case TAVERN_SIDE_ROOM: {
                TavernState tavernState;
                TavernState tavernState2 = tavernState = cityProxy.getCity().getCityState().getTavernState();
                synchronized (tavernState2) {
                    ISideRoomPerson sideRoomPerson = (ISideRoomPerson)((List)tavernState.presentPersonsInSideRoomBinding().get()).get(0);
                    return this.createDialogForSideRoom(sideRoomPerson, font, cityProxy);
                }
            }
            case TAVERN_COURIER: {
                return (TavernCourierDialog)((Object)this.context.getBean("tavernCourierDialog", new Object[]{font, cityProxy}));
            }
            case TAVERN_BURGLAR: {
                return (TavernBurglarDialog)((Object)this.context.getBean("tavernBurglarDialog", new Object[]{font, cityProxy}));
            }
            case TAVERN_TRANSPORT_TRADER: {
                return (TavernTransportTraderDialog)((Object)this.context.getBean("tavernTransportTraderDialog", new Object[]{font, cityProxy}));
            }
            case TAVERN_WAREHOUSE_TENANT: {
                return (TavernWarehouseTenantDialog)((Object)this.context.getBean("tavernWarehouseTenantDialog", new Object[]{font, cityProxy}));
            }
            case TAVERN_SMUGGLER: {
                return (TavernSmugglerDialog)((Object)this.context.getBean("tavernSmugglerDialog", new Object[]{font, cityProxy}));
            }
            case TAVERN_PIRATE_HUNTER: {
                return (TavernPirateHunterDialog)((Object)this.context.getBean("tavernPirateHunterDialog", new Object[]{font, cityProxy}));
            }
            case TAVERN_PATROL: {
                return (TavernPatrolDialog)((Object)this.context.getBean("tavernPatrolDialog", new Object[]{font, cityProxy}));
            }
            case TAVERN_BUYER: {
                return (TavernBuyerDialog)((Object)this.context.getBean("tavernBuyerDialog", new Object[]{font, cityProxy}));
            }
            case TAVERN_CONCURRENT: {
                return (TavernConcurrentDialog)((Object)this.context.getBean("tavernConcurrentDialog", new Object[]{font, cityProxy}));
            }
            case TAVERN_ESCORTE: {
                return (TavernEscortDialog)((Object)this.context.getBean("tavernEscortDialog", new Object[]{font, cityProxy}));
            }
            case TAVERN_FUGATIVE: {
                return (TavernFugativeDialog)((Object)this.context.getBean("tavernFugativeDialog", new Object[]{font, cityProxy}));
            }
            case LOANER_TAKE: {
                return (LoanerTakeLoanDialog)((Object)this.context.getBean("loanerTakeLoanDialog", new Object[]{font, cityProxy}));
            }
            case LOANER_GIVE: {
                return (LoanerGiveLoanDialog)((Object)this.context.getBean("loanerGiveLoanDialog", new Object[]{font, cityProxy}));
            }
            case LOANER_REPAY: {
                return (LoanerPaybackDialog)((Object)this.context.getBean("loanerPaybackDialog", new Object[]{font, cityProxy}));
            }
            case LOANER_LIST: {
                return (LoanerListLoansDialog)((Object)this.context.getBean("loanerListLoansDialog", new Object[]{font, cityProxy}));
            }
            case CITY_HALL_NOTICE: {
                return (PublicNoticeDialog)((Object)this.context.getBean("publicNoticeDialog", new Object[]{font, cityProxy}));
            }
            case CITY_HALL_OUTRIGGER: {
                return (OutriggerNoticeDialog)((Object)this.context.getBean("outriggerNoticeDialog", new Object[]{font, cityProxy}));
            }
            case CITY_HALL_TOWN_INFO: {
                return (TownInfoDialog)((Object)this.context.getBean("townInfoDialog", new Object[]{font, cityProxy}));
            }
            case CITY_HALL_TREASURY: {
                return (TreasuryDialog)((Object)this.context.getBean("treasuryDialog", new Object[]{font, cityProxy}));
            }
            case CITY_HALL_HANSEATIC_INFO: {
                return (HanseaticInfoDialog)((Object)this.context.getBean("hanseaticInfoDialog", new Object[]{font, cityProxy}));
            }
            case CITY_HALL_ALDERMAN_OFFICE: {
                return (EldermanOfficeDialog)((Object)this.context.getBean("eldermanOfficeDialog", new Object[]{font, cityProxy}));
            }
            case CITY_HALL_MEETING_ROOM: {
                return (MeetingRoomDialog)((Object)this.context.getBean("meetingRoomDialog", new Object[]{font, cityProxy}));
            }
            case CITY_HALL_CITY_WALL: {
                return (CityWallBuildingDialog)((Object)this.context.getBean("cityWallBuildingDialog", new Object[]{font, cityProxy}));
            }
            case CHURCH_FEED: {
                return (ChurchFeedingDialog)((Object)this.context.getBean("churchFeedingDialog", new Object[]{font, cityProxy}));
            }
            case CHURCH_GIFT: {
                return (ChurchGiftDialog)((Object)this.context.getBean("churchGiftDialog", new Object[]{font, cityProxy}));
            }
            case CHURCH_EXTENSION: {
                return (ChurchExtensionDialog)((Object)this.context.getBean("churchExtensionDialog", new Object[]{font, cityProxy}));
            }
            case CITY_HISTORY: {
                String resourceName = this.getHistoryResourceName(cityProxy.getCity().getNameTemplate());
                HistoryStandaloneDialog dialog = this.getHistoryDialog(cityProxy, resourceName);
                return dialog;
            }
        }
        throw new RuntimeException("Not yet implemented: " + (Object)((Object)dialogType));
    }

    private Dialog createDialogForSideRoom(ISideRoomPerson sideRoomPerson, Font font, ICityPlayerProxyJFX cityProxy) {
        if (sideRoomPerson instanceof ICourier) {
            return (TavernCourierDialog)((Object)this.context.getBean("tavernCourierDialog", new Object[]{font, cityProxy}));
        }
        if (sideRoomPerson instanceof IThieve) {
            return (TavernBurglarDialog)((Object)this.context.getBean("tavernBurglarDialog", new Object[]{font, cityProxy}));
        }
        if (sideRoomPerson instanceof ITransportTrader) {
            return (TavernTransportTraderDialog)((Object)this.context.getBean("tavernTransportTraderDialog", new Object[]{font, cityProxy}));
        }
        if (sideRoomPerson instanceof IWarehouseTenant) {
            return (TavernWarehouseTenantDialog)((Object)this.context.getBean("tavernWarehouseTenantDialog", new Object[]{font, cityProxy}));
        }
        if (sideRoomPerson instanceof ISmuggler) {
            return (TavernSmugglerDialog)((Object)this.context.getBean("tavernSmugglerDialog", new Object[]{font, cityProxy}));
        }
        if (sideRoomPerson instanceof IPirateHunter) {
            return (TavernPirateHunterDialog)((Object)this.context.getBean("tavernPirateHunterDialog", new Object[]{font, cityProxy}));
        }
        if (sideRoomPerson instanceof IPatrol) {
            return (TavernPatrolDialog)((Object)this.context.getBean("tavernPatrolDialog", new Object[]{font, cityProxy}));
        }
        if (sideRoomPerson instanceof IBuyer) {
            return (TavernBuyerDialog)((Object)this.context.getBean("tavernBuyerDialog", new Object[]{font, cityProxy}));
        }
        if (sideRoomPerson instanceof IConcurrent) {
            return (TavernConcurrentDialog)((Object)this.context.getBean("tavernConcurrentDialog", new Object[]{font, cityProxy}));
        }
        if (sideRoomPerson instanceof IEscorte) {
            return (TavernEscortDialog)((Object)this.context.getBean("tavernEscortDialog", new Object[]{font, cityProxy}));
        }
        if (sideRoomPerson instanceof IFugitive) {
            return (TavernFugativeDialog)((Object)this.context.getBean("tavernFugativeDialog", new Object[]{font, cityProxy}));
        }
        if (sideRoomPerson instanceof ITreasureMapOwner) {
            return (TavernTreasureMapOwnerDialog)((Object)this.context.getBean("tavernTreasureMapOwnerDialog", new Object[]{font, cityProxy}));
        }
        throw new RuntimeException("Not yet implemented: " + sideRoomPerson.getClass().getName());
    }
}

