/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.model;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ListType;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.IShip;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

@ClassCategory(value={EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
public class CityPlayerProxyJFX
implements ICityPlayerProxyJFX {
    private final ICity city;
    private final IPlayer player;
    @ListType(value=IShip.class)
    private ObservableList<IShip> shipList = FXCollections.observableArrayList();
    @ListType(value=IShip.class)
    private ObservableList<IShip> playerShips = FXCollections.observableArrayList();
    private IShip activeShip = null;

    public CityPlayerProxyJFX(ICity city, IPlayer player, IShip activeShip) {
        this.city = city;
        this.player = player;
        this.activeShip = activeShip;
        this.shipList.add((Object)activeShip);
        this.playerShips.add((Object)activeShip);
    }

    public IShip getActiveShip() {
        return this.activeShip;
    }

    public void activateShip(IShip ship) {
        for (IShip s : this.playerShips) {
            if (!s.equals(ship) || !s.isAvailable()) continue;
            this.activeShip = s;
            break;
        }
        if (this.getActiveShip() == null) {
            throw new IllegalArgumentException("The ship " + ship + " of the player is not in port");
        }
    }

    public ObservableList<IShip> getPlayersShips() {
        return this.playerShips;
    }

    public void arrive(IShip ship) {
        this.shipList.add((Object)ship);
        if (this.player.getFleet().contains(ship)) {
            this.playerShips.add((Object)ship);
            if (this.playerShips.size() == 1) {
                this.activeShip = ship;
            }
        }
    }

    public void leave(IShip ship) {
        if (this.activeShip == ship) {
            this.activeShip = null;
        }
        this.playerShips.remove((Object)ship);
        this.shipList.remove((Object)ship);
    }

    public ICity getCity() {
        return this.city;
    }

    public IPlayer getPlayer() {
        return this.player;
    }
}

