/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.notice;

import ch.sahits.game.event.handler.impl.EventHandlerFactory;
import ch.sahits.game.event.handler.impl.ViewChangeActionRunnable;
import ch.sahits.game.graphic.display.dialog.util.DialogFactory;
import ch.sahits.game.graphic.display.notice.CityHallNoticeMetaData;
import ch.sahits.game.graphic.display.notice.ECityHallBoard;
import ch.sahits.game.graphic.display.notice.EGeneralNoticeBoard;
import ch.sahits.game.graphic.display.notice.ELoanerSceneNoticeBoard;
import ch.sahits.game.graphic.display.notice.EMarketPlaceNoticeBoard;
import ch.sahits.game.graphic.display.notice.ENoticeItem;
import ch.sahits.game.graphic.display.notice.EPortSceneNoticeBoard;
import ch.sahits.game.graphic.display.notice.EShipyardNoticeBoard;
import ch.sahits.game.graphic.display.notice.EStringSelectionState;
import ch.sahits.game.graphic.display.notice.ETavernNoticeBoard;
import ch.sahits.game.graphic.display.notice.LoanerNoticeMetaData;
import ch.sahits.game.graphic.display.notice.MarketBoothDialogMetaDataJFX;
import ch.sahits.game.graphic.display.notice.ShipYardMetaDataJFX;
import ch.sahits.game.graphic.display.notice.TavernNoticeMetaDataJFX;
import ch.sahits.game.graphic.display.notice.TradeDialogMetaDataJFX;
import ch.sahits.game.graphic.display.notice.TradingOfficeDialogMataDataJFX;
import ch.sahits.game.graphic.display.util.TextEllipsisCalculator;
import ch.sahits.game.javafx.control.ScrollPaneContent;
import ch.sahits.game.javafx.control.TextSizingUtility;
import ch.sahits.game.javafx.model.DisplayMessages;
import ch.sahits.game.javafx.util.INoticeBoardDestinction;
import ch.sahits.game.javafx.util.INoticeBoardFactory;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;
import ch.sahits.game.openpatrician.model.people.IPerson;
import ch.sahits.game.openpatrician.model.people.IPirateHunter;
import ch.sahits.game.openpatrician.model.people.ISideRoomPerson;
import ch.sahits.game.openpatrician.model.people.ITavernPerson;
import ch.sahits.game.openpatrician.model.people.ITreasureMapOwner;
import ch.sahits.game.openpatrician.model.personal.ESocialRank;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.util.javafx.IJavaFXApplicationThreadExecution;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import javafx.scene.text.Font;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class NoticeBoardFactory
implements INoticeBoardFactory {
    static final Logger logger = LogManager.getLogger(NoticeBoardFactory.class);
    @Autowired
    private EventHandlerFactory eventHandlerFactory;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private IJavaFXApplicationThreadExecution threadExecutor;
    @Autowired
    private DisplayMessages displayMessages;
    @Autowired
    private TextEllipsisCalculator ellipsisCalculator;
    @Autowired
    private TextSizingUtility sizeing;
    @Autowired
    private DialogFactory dialogFactory;

    public void populateNoticeBoardContent(ScrollPaneContent content, INoticeBoardDestinction destinction, ICityPlayerProxyJFX proxy, Font font) {
        block23: {
            block29: {
                block28: {
                    block27: {
                        block26: {
                            block25: {
                                block24: {
                                    block22: {
                                        if (!(destinction instanceof EPortSceneNoticeBoard)) break block22;
                                        switch ((EPortSceneNoticeBoard)destinction) {
                                            case TRADING: {
                                                this.fillTradingContent(content, proxy, font);
                                                break block23;
                                            }
                                            case TRADING_OFFICE: {
                                                this.fillTradingOfficeContent(content, proxy, font);
                                                break block23;
                                            }
                                            default: {
                                                throw new RuntimeException("Not implemented: " + destinction);
                                            }
                                        }
                                    }
                                    if (!(destinction instanceof EMarketPlaceNoticeBoard)) break block24;
                                    switch ((EMarketPlaceNoticeBoard)destinction) {
                                        case MARKET_BOOTH: {
                                            this.fillMarketPlaceBoothContent(content, proxy, font);
                                            break block23;
                                        }
                                        default: {
                                            throw new RuntimeException("Not implemented: " + destinction);
                                        }
                                    }
                                }
                                if (!(destinction instanceof EShipyardNoticeBoard)) break block25;
                                switch ((EShipyardNoticeBoard)destinction) {
                                    case SHIPYARD: {
                                        this.fillShipYardContent(content, proxy, font);
                                        break block23;
                                    }
                                    default: {
                                        throw new RuntimeException("Not implemented: " + destinction);
                                    }
                                }
                            }
                            if (!(destinction instanceof ETavernNoticeBoard)) break block26;
                            switch ((ETavernNoticeBoard)destinction) {
                                case TAVERN: {
                                    this.fillTavernContent(content, proxy, font);
                                    break block23;
                                }
                                default: {
                                    throw new RuntimeException("Not implemented: " + destinction);
                                }
                            }
                        }
                        if (!(destinction instanceof ELoanerSceneNoticeBoard)) break block27;
                        switch ((ELoanerSceneNoticeBoard)destinction) {
                            case LOANER: {
                                this.fillLoanerContent(content, proxy, font);
                                break block23;
                            }
                            default: {
                                throw new RuntimeException("Not implemented: " + destinction);
                            }
                        }
                    }
                    if (!(destinction instanceof EGeneralNoticeBoard)) break block28;
                    switch ((EGeneralNoticeBoard)destinction) {
                        case MESSAGES: 
                        case CHURCH: {
                            this.fillMessagesContent(content, (EGeneralNoticeBoard)destinction);
                            break block23;
                        }
                        default: {
                            throw new RuntimeException("Not implemented: " + destinction);
                        }
                    }
                }
                if (!(destinction instanceof ECityHallBoard)) break block29;
                switch ((ECityHallBoard)destinction) {
                    case NOTICE_BOARD: 
                    case MAYORS_OFFICE: 
                    case ALDERMAN_OFFICE: 
                    case MEETING_ROOM: {
                        this.fillCityHallNoticeboard(content, (ECityHallBoard)destinction, proxy);
                        break block23;
                    }
                    default: {
                        throw new RuntimeException("Not implemented: " + destinction);
                    }
                }
            }
            throw new RuntimeException("Not yet implemented destinction type: " + destinction.getClass());
        }
    }

    private void fillCityHallNoticeboard(ScrollPaneContent content, ECityHallBoard type, ICityPlayerProxyJFX proxy) {
        CityHallNoticeMetaData metaData = new CityHallNoticeMetaData(proxy, type);
        this.initializeNoticeBoard(content, metaData);
    }

    private void fillMessagesContent(ScrollPaneContent content, EGeneralNoticeBoard type) {
        this.initializeNoticeBoard(content, type);
    }

    private void fillLoanerContent(ScrollPaneContent content, ICityPlayerProxyJFX proxy, Font font) {
        LoanerNoticeMetaData metaData = new LoanerNoticeMetaData(proxy);
        this.initializeNoticeBoard(content, metaData);
    }

    private void fillTavernContent(ScrollPaneContent content, ICityPlayerProxyJFX proxy, Font font) {
        TavernNoticeMetaDataJFX metaData = new TavernNoticeMetaDataJFX(proxy);
        this.initializeNoticeBoard(content, metaData);
    }

    private void fillShipYardContent(ScrollPaneContent content, ICityPlayerProxyJFX proxy, Font font) {
        ShipYardMetaDataJFX metaData = new ShipYardMetaDataJFX(proxy);
        this.initializeNoticeBoard(content, metaData);
    }

    private void fillMarketPlaceBoothContent(ScrollPaneContent content, ICityPlayerProxyJFX proxy, Font font) {
        MarketBoothDialogMetaDataJFX metaData = new MarketBoothDialogMetaDataJFX(proxy, EStringSelectionState.ACTIVE, EStringSelectionState.INACTIVE);
        this.initializeNoticeBoard(content, metaData);
    }

    private void fillTradingOfficeContent(ScrollPaneContent content, ICityPlayerProxyJFX proxy, Font font) {
        EStringSelectionState inact = EStringSelectionState.INACTIVE;
        TradingOfficeDialogMataDataJFX metaData = new TradingOfficeDialogMataDataJFX(proxy, EStringSelectionState.ACTIVE, inact, inact, inact, inact, inact);
        this.initializeNoticeBoard(content, metaData);
    }

    private void fillTradingContent(ScrollPaneContent content, ICityPlayerProxyJFX proxy, Font font) {
        boolean hasWeapons;
        ICity city = proxy.getCity();
        ITradingOffice office = proxy.getPlayer().findTradingOffice(city);
        IShip ship = proxy.getActiveShip();
        boolean city2ShipFlag = proxy.getActiveShip() != null;
        boolean hasTradingOffice = office != null;
        boolean bl = hasWeapons = city2ShipFlag && hasTradingOffice && office.hasWeapons() && ship.getUpgradeSpaceReduction() > 0 && ship.hasWeapons();
        EStringSelectionState city2ship = city2ShipFlag ? EStringSelectionState.ACTIVE : (proxy.getPlayersShips().isEmpty() ? EStringSelectionState.DISABLE : EStringSelectionState.INACTIVE);
        EStringSelectionState city2office = hasTradingOffice && city2ShipFlag ? EStringSelectionState.INACTIVE : EStringSelectionState.DISABLE;
        EStringSelectionState office2ship = hasTradingOffice && !proxy.getPlayersShips().isEmpty() && !city2ShipFlag ? EStringSelectionState.ACTIVE : (hasTradingOffice && city2ShipFlag ? EStringSelectionState.INACTIVE : EStringSelectionState.DISABLE);
        EStringSelectionState weapons = hasWeapons && city2ShipFlag ? EStringSelectionState.INACTIVE : EStringSelectionState.DISABLE;
        TradeDialogMetaDataJFX metaData = new TradeDialogMetaDataJFX(city2ship, office2ship, city2office, weapons, proxy, font);
        this.initializeNoticeBoard(content, metaData);
    }

    private void initializeNoticeBoard(ScrollPaneContent content, EGeneralNoticeBoard type) {
        switch (type) {
            case MESSAGES: {
                this.initializeMessagesNoticeBoard(content);
                break;
            }
            case CHURCH: {
                this.initializeChurchNotizeBoard(content);
                break;
            }
            default: {
                throw new RuntimeException("Not implemented: " + (Object)((Object)type));
            }
        }
    }

    private void initializeChurchNotizeBoard(ScrollPaneContent content) {
        this.threadExecutor.execute(() -> {
            String s = this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.church", new Object[0], this.locale.getCurrentLocal());
            content.setTitle(s);
            s = this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.church.pray", new Object[0], this.locale.getCurrentLocal());
            content.addEntry(s, this.createEventHandlerFromRunnable(this.eventHandlerFactory.getViewChangeActionRunnable(ENoticeItem.CHURCH_PRAY)), false, false);
            s = this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.church.feed", new Object[0], this.locale.getCurrentLocal());
            content.addEntry(s, this.createEventHandlerFromRunnable(this.eventHandlerFactory.getViewChangeActionRunnable(ENoticeItem.CHURCH_FEED)), false, false);
            s = this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.church.gift", new Object[0], this.locale.getCurrentLocal());
            content.addEntry(s, this.createEventHandlerFromRunnable(this.eventHandlerFactory.getViewChangeActionRunnable(ENoticeItem.CHURCH_GIFT)), false, false);
            s = this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.church.donation", new Object[0], this.locale.getCurrentLocal());
            content.addEntry(s, this.createEventHandlerFromRunnable(this.eventHandlerFactory.getViewChangeActionRunnable(ENoticeItem.CHURCH_EXTENSION)), false, false);
        });
    }

    private void initializeMessagesNoticeBoard(ScrollPaneContent content) {
        this.threadExecutor.execute(() -> {
            ObservableList<DisplayMessage> messages = this.displayMessages.messagesProperty();
            EventHandler<MouseEvent> nopEvenHandler = this.createEventHandlerFromRunnable(this.eventHandlerFactory.createNOPRunnable());
            double maxWidth = content.getParentWidth() - 30.0;
            String s = this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.messages", new Object[0], this.locale.getCurrentLocal());
            Font font = (Font)content.fontProperty().get();
            content.setTitle(s);
            for (DisplayMessage message : messages) {
                String messageString = this.ellipsisCalculator.calculateEllipsis(font, message.getMessage(), maxWidth);
                EventHandler<MouseEvent> onMouseFocus = this.eventHandlerFactory.getDisplaMessageMouseEnterFocusEventHandler(content, message.getMessage());
                EventHandler<MouseEvent> onMouseExitFocus = this.eventHandlerFactory.getDisplayMessageMouseExitFocusEventHandler(content);
                if (message.hasDialogTemplate()) {
                    EventHandler<MouseEvent> openDialogEvenHandler = this.createEventHandlerFromRunnable(this.eventHandlerFactory.getViewChangeActionRunnable(message.getDialogTemplate()));
                    content.addEntry(messageString, false, true, openDialogEvenHandler, onMouseFocus, onMouseExitFocus);
                    continue;
                }
                content.addEntry(messageString, false, true, nopEvenHandler, onMouseFocus, onMouseExitFocus);
            }
        });
    }

    private void initializeNoticeBoard(ScrollPaneContent content, CityHallNoticeMetaData metaData) {
        if (metaData.getType() == ECityHallBoard.NOTICE_BOARD) {
            this.threadExecutor.execute(() -> {
                String s = this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.cityHallNoticeBoard", new Object[0], this.locale.getCurrentLocal());
                content.setTitle(s);
                s = this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.cityHallPublicNotice", new Object[0], this.locale.getCurrentLocal());
                content.addEntry(s, this.createEventHandlerFromRunnable(this.eventHandlerFactory.getViewChangeActionRunnable(ENoticeItem.CITY_HALL_NOTICE)), false, false);
                s = this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.cityHallOutriggerNotice", new Object[0], this.locale.getCurrentLocal());
                content.addEntry(s, this.createEventHandlerFromRunnable(this.eventHandlerFactory.getViewChangeActionRunnable(ENoticeItem.CITY_HALL_OUTRIGGER)), false, false);
            });
        } else if (metaData.getType() == ECityHallBoard.MAYORS_OFFICE) {
            this.threadExecutor.execute(() -> {
                String s = this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.mayorsOffice", new Object[0], this.locale.getCurrentLocal());
                content.setTitle(s);
                s = this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.townInfo", new Object[0], this.locale.getCurrentLocal());
                content.addEntry(s, this.createEventHandlerFromRunnable(this.eventHandlerFactory.getViewChangeActionRunnable(ENoticeItem.CITY_HALL_TOWN_INFO)), false, false);
                s = this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.treasury", new Object[0], this.locale.getCurrentLocal());
                content.addEntry(s, this.createEventHandlerFromRunnable(this.eventHandlerFactory.getViewChangeActionRunnable(ENoticeItem.CITY_HALL_TREASURY)), false, false);
                s = this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.cityWall", new Object[0], this.locale.getCurrentLocal());
                content.addEntry(s, this.createEventHandlerFromRunnable(this.eventHandlerFactory.getViewChangeActionRunnable(ENoticeItem.CITY_HALL_CITY_WALL)), false, false);
            });
        } else if (metaData.getType() == ECityHallBoard.ALDERMAN_OFFICE) {
            this.threadExecutor.execute(() -> {
                String s = this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.alderman", new Object[0], this.locale.getCurrentLocal());
                content.setTitle(s);
                s = this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.hanseaticInfo", new Object[0], this.locale.getCurrentLocal());
                content.addEntry(s, this.createEventHandlerFromRunnable(this.eventHandlerFactory.getViewChangeActionRunnable(ENoticeItem.CITY_HALL_HANSEATIC_INFO)), false, false);
                if (metaData.getCityProxy().getPlayer().getRank() == ESocialRank.ALDERMAN && metaData.getCityProxy().getPlayer().getHometown().equals(metaData.getCityProxy().getCity())) {
                    s = this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.aldermanOffice", new Object[0], this.locale.getCurrentLocal());
                    content.addEntry(s, this.createEventHandlerFromRunnable(this.eventHandlerFactory.getViewChangeActionRunnable(ENoticeItem.CITY_HALL_ELDERMAN_OFFICE)), false, false);
                }
            });
        } else if (metaData.getType() == ECityHallBoard.MEETING_ROOM) {
            this.threadExecutor.execute(() -> {
                String s = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.cityhall.MeetingRoomDialog.title", new Object[0], this.locale.getCurrentLocal());
                content.setTitle(s);
                ViewChangeActionRunnable runnable = this.eventHandlerFactory.getViewChangeActionRunnable(ENoticeItem.CITY_HALL_MEETING_ROOM);
                runnable.run();
            });
        }
    }

    private void initializeNoticeBoard(ScrollPaneContent content, TradeDialogMetaDataJFX metaData) {
        this.threadExecutor.execute(() -> {
            String s = this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.city2ship", new Object[0], this.locale.getCurrentLocal());
            if (metaData.getCityProxy().getActiveShip() instanceof IConvoy) {
                s = this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.city2convoy", new Object[0], this.locale.getCurrentLocal());
            }
            content.addEntry(s, this.createEventHandlerFromRunnable(this.eventHandlerFactory.getViewChangeActionRunnable(ENoticeItem.PORT_CITY_TO_SHIP)), false, true);
            s = this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.ship2tradingOffice", new Object[0], this.locale.getCurrentLocal());
            if (metaData.getCityProxy().getActiveShip() instanceof IConvoy) {
                s = this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.convoy2tradingOffice", new Object[0], this.locale.getCurrentLocal());
            }
            content.addEntry(s, this.createEventHandlerFromRunnable(this.eventHandlerFactory.getViewChangeActionRunnable(ENoticeItem.PORT_STORAGE_TO_SHIP)), false, false);
            s = this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.city2tradingOffice", new Object[0], this.locale.getCurrentLocal());
            content.addEntry(s, this.createEventHandlerFromRunnable(this.eventHandlerFactory.getViewChangeActionRunnable(ENoticeItem.PORT_CITY_TO_STORAGE)), false, false);
            s = this.messageSource.getMessage("ch.sahits.game.openpatrician.model.people.impl.WeaponsDealerState.noticeboardTitle", new Object[0], this.locale.getCurrentLocal());
            content.addEntry(s, this.createEventHandlerFromRunnable(this.eventHandlerFactory.getViewChangeActionRunnable(ENoticeItem.PORT_WEAPON)), true, false);
        });
    }

    private void initializeNoticeBoard(final ScrollPaneContent content, LoanerNoticeMetaData metaData) {
        this.threadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                String s = NoticeBoardFactory.this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.takeLoan", new Object[0], NoticeBoardFactory.this.locale.getCurrentLocal());
                content.addEntry(s, NoticeBoardFactory.this.createEventHandlerFromRunnable(NoticeBoardFactory.this.eventHandlerFactory.getViewChangeActionRunnable(ENoticeItem.LOANER_TAKE)), false, false);
                s = NoticeBoardFactory.this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.giveLoan", new Object[0], NoticeBoardFactory.this.locale.getCurrentLocal());
                content.addEntry(s, NoticeBoardFactory.this.createEventHandlerFromRunnable(NoticeBoardFactory.this.eventHandlerFactory.getViewChangeActionRunnable(ENoticeItem.LOANER_GIVE)), false, false);
                s = NoticeBoardFactory.this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.repayLoan", new Object[0], NoticeBoardFactory.this.locale.getCurrentLocal());
                content.addEntry(s, NoticeBoardFactory.this.createEventHandlerFromRunnable(NoticeBoardFactory.this.eventHandlerFactory.getViewChangeActionRunnable(ENoticeItem.LOANER_REPAY)), false, false);
                s = NoticeBoardFactory.this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.listLoans", new Object[0], NoticeBoardFactory.this.locale.getCurrentLocal());
                content.addEntry(s, NoticeBoardFactory.this.createEventHandlerFromRunnable(NoticeBoardFactory.this.eventHandlerFactory.getViewChangeActionRunnable(ENoticeItem.LOANER_LIST)), false, false);
            }
        });
    }

    private void initializeNoticeBoard(final ScrollPaneContent content, TradingOfficeDialogMataDataJFX metaData) {
        this.threadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                String s = NoticeBoardFactory.this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.balanceSheet", new Object[0], NoticeBoardFactory.this.locale.getCurrentLocal());
                content.addEntry(s, NoticeBoardFactory.this.createEventHandlerFromRunnable(NoticeBoardFactory.this.eventHandlerFactory.getViewChangeActionRunnable(ENoticeItem.TO_BALANCE)), false, true);
                s = NoticeBoardFactory.this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.PersonalDialog.personal", new Object[0], NoticeBoardFactory.this.locale.getCurrentLocal());
                content.addEntry(s, NoticeBoardFactory.this.createEventHandlerFromRunnable(NoticeBoardFactory.this.eventHandlerFactory.getViewChangeActionRunnable(ENoticeItem.TO_PERSONAL)), false, false);
                s = NoticeBoardFactory.this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.consumptionProduction", new Object[0], NoticeBoardFactory.this.locale.getCurrentLocal());
                content.addEntry(s, NoticeBoardFactory.this.createEventHandlerFromRunnable(NoticeBoardFactory.this.eventHandlerFactory.getViewChangeActionRunnable(ENoticeItem.TO_CONSUMPTION_PRODUCTION)), false, false);
                s = NoticeBoardFactory.this.messageSource.getMessage("ch.sahits.game.openpatrician.model.people.impl.WeaponsDealerState.noticeboardTitle", new Object[0], NoticeBoardFactory.this.locale.getCurrentLocal());
                content.addEntry(s, NoticeBoardFactory.this.createEventHandlerFromRunnable(NoticeBoardFactory.this.eventHandlerFactory.getViewChangeActionRunnable(ENoticeItem.TO_WEAPONS)), true, false);
                s = NoticeBoardFactory.this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.warehouses", new Object[0], NoticeBoardFactory.this.locale.getCurrentLocal());
                content.addEntry(s, NoticeBoardFactory.this.createEventHandlerFromRunnable(NoticeBoardFactory.this.eventHandlerFactory.getViewChangeActionRunnable(ENoticeItem.TO_WAREHOUSES)), false, false);
                s = NoticeBoardFactory.this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.storageManager", new Object[0], NoticeBoardFactory.this.locale.getCurrentLocal());
                content.addEntry(s, NoticeBoardFactory.this.createEventHandlerFromRunnable(NoticeBoardFactory.this.eventHandlerFactory.getViewChangeActionRunnable(ENoticeItem.TO_OFFICE_TRADING)), false, false);
            }
        });
    }

    private void initializeNoticeBoard(final ScrollPaneContent content, MarketBoothDialogMetaDataJFX metaData) {
        this.threadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                String s = NoticeBoardFactory.this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.stockPrices", new Object[0], NoticeBoardFactory.this.locale.getCurrentLocal());
                content.addEntry(s, NoticeBoardFactory.this.createEventHandlerFromRunnable(NoticeBoardFactory.this.eventHandlerFactory.getViewChangeActionRunnable(ENoticeItem.MB_STOCK_PRICES)), false, true);
                s = NoticeBoardFactory.this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.consumptionProduction", new Object[0], NoticeBoardFactory.this.locale.getCurrentLocal());
                content.addEntry(s, NoticeBoardFactory.this.createEventHandlerFromRunnable(NoticeBoardFactory.this.eventHandlerFactory.getViewChangeActionRunnable(ENoticeItem.MB_CONSUMPTION_PRODUCTION)), false, false);
            }
        });
    }

    private void initializeNoticeBoard(final ScrollPaneContent content, ShipYardMetaDataJFX metaData) {
        this.threadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                String s = NoticeBoardFactory.this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.construction", new Object[0], NoticeBoardFactory.this.locale.getCurrentLocal());
                content.addEntry(s, NoticeBoardFactory.this.createEventHandlerFromRunnable(NoticeBoardFactory.this.eventHandlerFactory.getViewChangeActionRunnable(ENoticeItem.SHIPYARD_CONSTRUCTION)), false, false);
                s = NoticeBoardFactory.this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.ShipRepairDialogV2.repair", new Object[0], NoticeBoardFactory.this.locale.getCurrentLocal());
                content.addEntry(s, NoticeBoardFactory.this.createEventHandlerFromRunnable(NoticeBoardFactory.this.eventHandlerFactory.getViewChangeActionRunnable(ENoticeItem.SHIPYARD_REPAIR)), false, false);
                s = NoticeBoardFactory.this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.constructionList", new Object[0], NoticeBoardFactory.this.locale.getCurrentLocal());
                content.addEntry(s, NoticeBoardFactory.this.createEventHandlerFromRunnable(NoticeBoardFactory.this.eventHandlerFactory.getViewChangeActionRunnable(ENoticeItem.SHIPYARD_CONSTRUCTION_LIST)), false, false);
                s = NoticeBoardFactory.this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.repairList", new Object[0], NoticeBoardFactory.this.locale.getCurrentLocal());
                content.addEntry(s, NoticeBoardFactory.this.createEventHandlerFromRunnable(NoticeBoardFactory.this.eventHandlerFactory.getViewChangeActionRunnable(ENoticeItem.SHIPYARD_REPAIR_LIST)), false, false);
                s = NoticeBoardFactory.this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.upgradeShip", new Object[0], NoticeBoardFactory.this.locale.getCurrentLocal());
                content.addEntry(s, NoticeBoardFactory.this.createEventHandlerFromRunnable(NoticeBoardFactory.this.eventHandlerFactory.getViewChangeActionRunnable(ENoticeItem.SHIPYARD_UPGRADE)), false, false);
                s = NoticeBoardFactory.this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.renameShip", new Object[0], NoticeBoardFactory.this.locale.getCurrentLocal());
                content.addEntry(s, NoticeBoardFactory.this.createEventHandlerFromRunnable(NoticeBoardFactory.this.eventHandlerFactory.getViewChangeActionRunnable(ENoticeItem.SHIPYARD_RENAME)), false, false);
            }
        });
    }

    private void initializeNoticeBoard(final ScrollPaneContent content, final TavernNoticeMetaDataJFX metaData) {
        this.threadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                TavernState tavernState = metaData.tavernState;
                ObservableList present = tavernState.presentPersonsProperty();
                ArrayList sideRoom = Lists.newArrayList();
                ArrayList mainRoom = Lists.newArrayList();
                IPlayer player = metaData.getCityProxy().getPlayer();
                for (IPerson pers : present) {
                    if (pers instanceof ISideRoomPerson) {
                        if (tavernState.isTalkingToOtherPlayer((ITavernPerson)((ISideRoomPerson)pers), player) || (pers instanceof ITreasureMapOwner || pers instanceof IPirateHunter) && player.getSegmentedMap() != null) continue;
                        sideRoom.add((ISideRoomPerson)pers);
                        continue;
                    }
                    mainRoom.add(pers);
                }
                for (IPerson pers : mainRoom) {
                    String s = NoticeBoardFactory.this.messageSource.getMessage(pers.getClass().getName() + ".noticeboardTitle", new Object[0], NoticeBoardFactory.this.locale.getCurrentLocal());
                    boolean active = false;
                    if (((ObservableMap)tavernState.talkingToProperty().get()).containsKey((Object)pers) && ((IPlayer)((ObservableMap)tavernState.talkingToProperty().get()).get((Object)pers)).equals(player)) {
                        active = true;
                    }
                    content.addEntry(s, NoticeBoardFactory.this.createEventHandlerFromRunnable(NoticeBoardFactory.this.eventHandlerFactory.getTavernChangeActionHandler(pers, tavernState, player)), false, active);
                }
                if (!sideRoom.isEmpty()) {
                    String s = NoticeBoardFactory.this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.sideRoom", new Object[0], NoticeBoardFactory.this.locale.getCurrentLocal());
                    boolean active = false;
                    for (Map.Entry entry : ((ObservableMap)tavernState.talkingToProperty().get()).entrySet()) {
                        if (!(entry.getKey() instanceof ISideRoomPerson) || !((IPlayer)entry.getValue()).equals(player)) continue;
                        active = true;
                        break;
                    }
                    content.addEntry(s, NoticeBoardFactory.this.createEventHandlerFromRunnable(NoticeBoardFactory.this.eventHandlerFactory.getTavernTalkToSidreroomPersonAction((IPerson)sideRoom.get(0), tavernState, player)), false, active);
                }
            }
        });
    }

    private EventHandler<MouseEvent> createEventHandlerFromRunnable(final Runnable run) {
        return new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                run.run();
            }
        };
    }
}

