/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.notice;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.NavigationStateChange;
import ch.sahits.game.event.NoticeBoardClose;
import ch.sahits.game.event.NoticeBoardUpdate;
import ch.sahits.game.event.data.ClockTickDayChange;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.graphic.display.notice.ECityHallBoard;
import ch.sahits.game.graphic.display.notice.EGeneralNoticeBoard;
import ch.sahits.game.graphic.display.notice.ELoanerSceneNoticeBoard;
import ch.sahits.game.graphic.display.notice.EMarketPlaceNoticeBoard;
import ch.sahits.game.graphic.display.notice.EPortSceneNoticeBoard;
import ch.sahits.game.graphic.display.notice.EShipyardNoticeBoard;
import ch.sahits.game.graphic.display.notice.ETavernNoticeBoard;
import ch.sahits.game.javafx.control.NoticeBoard;
import ch.sahits.game.javafx.control.ScrollPaneEntry;
import ch.sahits.game.javafx.util.INoticeBoardDestinction;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.event.PersonLeavesTavernEvent;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import javafx.application.Platform;
import javafx.scene.Node;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class OpenPatricianNoticeBoard
extends NoticeBoard {
    static final Logger logger = LogManager.getLogger(OpenPatricianNoticeBoard.class);
    private ICityPlayerProxyJFX lastProxy;
    private INoticeBoardDestinction lastDestinction;
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;

    @PostConstruct
    private void initializeEventRegistration() {
        this.clientServerEventBus.register((Object)this);
        this.clientEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregister() {
        this.clientServerEventBus.unregister((Object)this);
        this.clientEventBus.unregister((Object)this);
    }

    @Subscribe
    public void handleNoticeBoardUpdate(NoticeBoardUpdate event) {
        ViewChangeCityPlayerProxyJFX proxy = (ViewChangeCityPlayerProxyJFX)event.getProxy();
        this.lastProxy = proxy;
        this.updateNoticeBoard(proxy);
    }

    @Subscribe
    public void updateDisplayMessages(DisplayMessage message) {
        EViewChangeEvent viewChange;
        if (this.lastProxy instanceof ViewChangeCityPlayerProxyJFX && (viewChange = (EViewChangeEvent)((ViewChangeCityPlayerProxyJFX)this.lastProxy).getViewChangeEvent()) == EViewChangeEvent.MESSAGES) {
            Platform.runLater(() -> this.updateNoticeBoard((ViewChangeCityPlayerProxyJFX)this.lastProxy));
        }
    }

    @Subscribe
    public void handleNAvigationChange(NavigationStateChange event) {
        switch (event.getChange()) {
            case DISABLE_NAVIGATION: {
                this.disableNavigationItems();
                break;
            }
            case ENABLE_NAVIGATION: {
                this.enableNavigationItems();
                break;
            }
            default: {
                logger.info("Not interested in navigation change event: " + event.getChange());
            }
        }
    }

    private void disableNavigationItems() {
        for (Node child : this.contentContainer.getChildren()) {
            if (!(child instanceof ScrollPaneEntry)) continue;
            child.disableProperty().setValue(Boolean.valueOf(true));
        }
    }

    private void enableNavigationItems() {
        for (Node child : this.contentContainer.getChildren()) {
            if (!(child instanceof ScrollPaneEntry)) continue;
            child.disableProperty().setValue(Boolean.valueOf(false));
        }
    }

    private void updateNoticeBoard(ViewChangeCityPlayerProxyJFX proxy) {
        INoticeBoardDestinction destinction;
        this.lastDestinction = destinction = this.map((EViewChangeEvent)proxy.getViewChangeEvent());
        if (destinction != null) {
            this.contentContainer.clearContents();
            this.noticeBoardFactory.populateNoticeBoardContent(this.contentContainer, destinction, (ICityPlayerProxyJFX)proxy, this.getFont());
        } else {
            logger.warn(proxy.getViewChangeEvent() + " is not a supported notice board change event");
        }
    }

    @Subscribe
    public void handlePersonLeaves(PersonLeavesTavernEvent event) {
        if (this.lastProxy != null && this.lastProxy instanceof ViewChangeCityPlayerProxyJFX && this.lastDestinction == ETavernNoticeBoard.TAVERN) {
            this.updateNoticeBoard((ViewChangeCityPlayerProxyJFX)this.lastProxy);
        }
    }

    @Subscribe
    public void handleCloseNoticeBoard(NoticeBoardClose event) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                OpenPatricianNoticeBoard.this.contentContainer.clearContents();
            }
        });
        this.lastProxy = null;
        this.lastDestinction = null;
    }

    @Subscribe
    public void handleDayChange(ClockTickDayChange event) {
        if (this.lastProxy != null && this.lastDestinction == ETavernNoticeBoard.TAVERN) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    OpenPatricianNoticeBoard.this.contentContainer.clearContents();
                    OpenPatricianNoticeBoard.this.noticeBoardFactory.populateNoticeBoardContent(OpenPatricianNoticeBoard.this.contentContainer, OpenPatricianNoticeBoard.this.lastDestinction, OpenPatricianNoticeBoard.this.lastProxy, OpenPatricianNoticeBoard.this.getFont());
                }
            });
        }
    }

    private INoticeBoardDestinction map(EViewChangeEvent viewChange) {
        switch (viewChange) {
            case NOTICE_MARKET_BOOTH: {
                return EMarketPlaceNoticeBoard.MARKET_BOOTH;
            }
            case NOTICE_SHIPYARD: {
                return EShipyardNoticeBoard.SHIPYARD;
            }
            case NOTICE_TAVERN: {
                return ETavernNoticeBoard.TAVERN;
            }
            case NOTICE_TRADE: {
                return EPortSceneNoticeBoard.TRADING;
            }
            case NOTICE_TRADING_OFFICE: {
                return EPortSceneNoticeBoard.TRADING_OFFICE;
            }
            case NOTICE_LOANER: {
                return ELoanerSceneNoticeBoard.LOANER;
            }
            case MESSAGES: {
                return EGeneralNoticeBoard.MESSAGES;
            }
            case NOTICE_CITY_HALL_BOARD: {
                return ECityHallBoard.NOTICE_BOARD;
            }
            case NOTICE_CITY_HALL_TREASURY: {
                return ECityHallBoard.MAYORS_OFFICE;
            }
            case NOTICE_CITY_HALL_ELDERMAN: {
                return ECityHallBoard.ALDERMAN_OFFICE;
            }
            case NOTICE_CITY_HALL_MEETINGROOM: {
                return ECityHallBoard.MEETING_ROOM;
            }
            case MAIN_VIEW_CHURCH: {
                return EGeneralNoticeBoard.CHURCH;
            }
        }
        return null;
    }
}

