/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.scene;

import ch.sahits.game.event.EGameStatusChange;
import ch.sahits.game.event.GameStateChange;
import ch.sahits.game.event.data.IGameStateChangeData;
import ch.sahits.game.event.data.NewGame;
import ch.sahits.game.graphic.display.SceneChangeable;
import ch.sahits.game.graphic.display.scene.MainGameScene;
import ch.sahits.game.graphic.display.util.GameOptionsService;
import ch.sahits.game.graphic.image.IFontLoader;
import ch.sahits.game.javafx.OpenPatricianScene;
import ch.sahits.game.javafx.control.OpenPatricianSlider;
import ch.sahits.game.javafx.control.OpenPatricianSpinner;
import ch.sahits.game.javafx.control.OpenPatricianStoneButton;
import ch.sahits.game.javafx.control.OpenPatricianWoodenTextInput;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.UniquePrototype;
import ch.sahits.game.openpatrician.engine.ClockTickTimer;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.Difficulty;
import ch.sahits.game.openpatrician.model.EGameSpeed;
import ch.sahits.game.openpatrician.model.EObjective;
import ch.sahits.game.openpatrician.model.GameFactory;
import ch.sahits.game.openpatrician.model.IGame;
import ch.sahits.game.openpatrician.sound.ITrackPlayer;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import ch.sahits.game.util.UIFactory;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Font;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.util.StringUtils;

@UniquePrototype
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class InGameOptionsScene
extends OpenPatricianScene {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    @Autowired
    private UIFactory uiFactory;
    @Autowired
    private GameFactory gameFactory;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private GameOptionsService gameOptions;
    @Autowired
    private Date date;
    @Autowired
    private IFontLoader fontLoader;
    @Autowired
    private ITrackPlayer soundPlayer;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    private ClockTickTimer timer;
    private IGame game;
    private Font font24;
    private SceneChangeable sceneChangeable;
    private OpenPatricianSlider speed;
    private EGameSpeed currentSpeed;
    private OpenPatricianSpinner lodableGames;

    public InGameOptionsScene() {
        super((Region)new StackPane());
        this.getRoot().getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource(this.getStyleSheetFilename()).toExternalForm());
    }

    public SceneChangeable getSceneChangeable() {
        return this.sceneChangeable;
    }

    public void setSceneChangeable(SceneChangeable sceneChangeable) {
        this.sceneChangeable = sceneChangeable;
    }

    private String getStyleSheetFilename() {
        return "newGame.css";
    }

    @PreDestroy
    private void unregister() {
        this.clientServerEventBus.unregister((Object)this);
    }

    @PostConstruct
    private void createControls() {
        this.clientServerEventBus.register((Object)this);
        this.game = this.gameFactory.getGame();
        this.currentSpeed = this.game.getGameSpeed();
        this.font24 = this.fontLoader.createDefaultFont(24);
        StackPane root = (StackPane)this.getRoot();
        GridPane grid = new GridPane();
        grid.getStyleClass().add((Object)"grid");
        grid.setAlignment(Pos.CENTER);
        grid.getColumnConstraints().add((Object)new ColumnConstraints(200.0));
        grid.getColumnConstraints().add((Object)new ColumnConstraints(300.0));
        grid.getColumnConstraints().add((Object)new ColumnConstraints(250.0));
        grid.getColumnConstraints().add((Object)new ColumnConstraints(100.0));
        Label loadLbl = new Label(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.InGameOptionsScene.load", new Object[0], this.locale.getCurrentLocal()));
        grid.add((Node)loadLbl, 0, 0);
        this.lodableGames = new OpenPatricianSpinner(this.font24);
        grid.add((Node)this.lodableGames, 1, 0);
        GridPane.setHalignment((Node)this.lodableGames, (HPos)HPos.LEFT);
        this.lodableGames.setOptionsMap(this.gameOptions.getSavegames());
        this.lodableGames.setMaxWidth(250.0);
        OpenPatricianStoneButton loadBtn = new OpenPatricianStoneButton(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.InGameOptionsScene.load", new Object[0], this.locale.getCurrentLocal()), this.font24);
        loadBtn.setOnAction(this.createLoadAction());
        grid.add((Node)loadBtn, 3, 0);
        GridPane.setHalignment((Node)loadBtn, (HPos)HPos.LEFT);
        Label saveLbl = new Label(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.InGameOptionsScene.save", new Object[0], this.locale.getCurrentLocal()));
        grid.add((Node)saveLbl, 0, 1);
        OpenPatricianSpinner saveableGames = new OpenPatricianSpinner(this.font24);
        grid.add((Node)saveableGames, 1, 1);
        GridPane.setHalignment((Node)saveableGames, (HPos)HPos.LEFT);
        saveableGames.setOptionsMap(this.gameOptions.getSavegames());
        saveableGames.setMaxWidth(250.0);
        OpenPatricianWoodenTextInput newSaveGame = new OpenPatricianWoodenTextInput(this.font24);
        newSaveGame.setSize(25);
        grid.add((Node)newSaveGame, 2, 1);
        OpenPatricianStoneButton saveBtn = new OpenPatricianStoneButton(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.InGameOptionsScene.save", new Object[0], this.locale.getCurrentLocal()), this.font24);
        grid.add((Node)saveBtn, 3, 1);
        GridPane.setHalignment((Node)saveBtn, (HPos)HPos.LEFT);
        Label gameSpeedLbl = new Label(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.NewGameScene.gameSpeed", new Object[0], this.locale.getCurrentLocal()));
        grid.add((Node)gameSpeedLbl, 0, 2);
        this.speed = new OpenPatricianSlider(this.font24, 200);
        this.speed.setValues(this.gameOptions.getGameSpeedList());
        int index = 0;
        this.currentSpeed = this.game.getGameSpeed();
        for (int i = 0; i < EGameSpeed.values().length; ++i) {
            if (!this.currentSpeed.equals((Object)EGameSpeed.values()[i])) continue;
            index = i;
            break;
        }
        this.speed.selectedIndexProperty().setValue((Number)index);
        grid.add((Node)this.speed, 1, 2);
        GridPane.setHalignment((Node)this.speed, (HPos)HPos.LEFT);
        OpenPatricianStoneButton quit = new OpenPatricianStoneButton(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.InGameOptionsScene.quit", new Object[0], this.locale.getCurrentLocal()), this.font24);
        quit.setOnAction(mouseEvent -> {
            mouseEvent.consume();
            this.soundPlayer.clearPlayList();
            Platform.exit();
            System.exit(0);
        });
        grid.add((Node)quit, 0, 6);
        GridPane.setHalignment((Node)quit, (HPos)HPos.LEFT);
        OpenPatricianStoneButton back = new OpenPatricianStoneButton(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.InGameOptionsScene.back", new Object[0], this.locale.getCurrentLocal()), this.font24);
        grid.add((Node)back, 3, 6);
        GridPane.setHalignment((Node)back, (HPos)HPos.RIGHT);
        back.setOnAction(this.getBackEvent());
        saveBtn.setOnAction(this.createSaveAction(saveableGames, newSaveGame, back));
        root.getChildren().add((Object)grid);
    }

    public void initializeState() {
        System.out.println("Pause timer");
        this.timer.pause();
    }

    private EventHandler<MouseEvent> getBackEvent() {
        return event -> {
            EGameSpeed currentSpeed;
            EGameSpeed gameSpeed = EGameSpeed.values()[this.speed.getSelectedIndex()];
            if (gameSpeed != (currentSpeed = this.game.getGameSpeed())) {
                this.game.setGameSpeed(gameSpeed);
            }
            MainGameScene mainGame = this.uiFactory.getMainGameScene(this.getRoot().getWidth(), this.getRoot().getHeight());
            this.getSceneChangeable().changeScene(mainGame);
            this.soundPlayer.play();
            this.timer.resume();
        };
    }

    private EventHandler<MouseEvent> createSaveAction(OpenPatricianSpinner saveableGames, OpenPatricianWoodenTextInput newSaveGame, OpenPatricianStoneButton back) {
        return event -> {
            String savegameName = newSaveGame.getText();
            if (StringUtils.isEmpty((Object)savegameName)) {
                savegameName = (String)saveableGames.getSelectedValue();
            }
            if (savegameName != null) {
                this.gameOptions.save(savegameName);
            } else {
                this.logger.warn("Game was not saved as no file name was specified.");
            }
            back.getOnAction().handle(event);
        };
    }

    private EventHandler<MouseEvent> createLoadAction() {
        return event -> {
            NewGame newGameDTO = NewGame.builder().difficulty(Difficulty.CHANDLER).firstName("FirstName").lastName("Lastname").hometown("BREMEN").objective(EObjective.ENDLESS).speed(EGameSpeed.SLOW).startYear(1300).male(true).mapName("/standartHanseaticMap.xml").environmentInitialisation(false).build();
            this.date.resetStartYear(0);
            GameStateChange stateChange = new GameStateChange(EGameStatusChange.LOAD_GAME_INIT);
            stateChange.setStateChangeData((IGameStateChangeData)newGameDTO);
            this.clientServerEventBus.post((Object)stateChange);
            while (this.date.getStartYear() == null) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    this.logger.warn("Interrupted while waiting for the startyear to be set.");
                }
            }
        };
    }

    @Subscribe
    public void handleGameStateChange(GameStateChange stateChange) {
        if (stateChange.getStatusChange() == EGameStatusChange.GAME_INITIALISATION_COMPLETE) {
            System.out.println("Load and replace the game");
            this.gameOptions.load((String)this.lodableGames.getSelectedValue());
        }
        if (stateChange.getStatusChange() == EGameStatusChange.GAME_LOADED) {
            this.uiFactory.invalidate();
            MainGameScene mainGameScene1 = this.uiFactory.getMainGameScene(this.getRoot().getWidth(), this.getRoot().getHeight());
            mainGameScene1.initializeGameView(null);
            Platform.runLater(() -> this.getBackEvent().handle(null));
        }
    }
}

