/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.event.task;

import ch.sahits.game.graphic.event.task.IBreakInAction;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.Random;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DEPENDS_ON_SERIALIZED_BEAN, EClassCategory.PROTOTYPE_BEAN})
class BreakInAction
extends TimedTask
implements IBreakInAction {
    @Autowired
    private Date date;
    @Autowired
    @XStreamOmitField
    private Random rnd;
    @Autowired
    @XStreamOmitField
    private Locale locale;
    @Autowired
    @XStreamOmitField
    @Qualifier(value="messageSource")
    private MessageSource messageSource;
    @Autowired
    @Qualifier(value="clientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientEventBus;
    private final IPlayer opponent;

    public BreakInAction(IPlayer opponent) {
        this.opponent = opponent;
    }

    @PostConstruct
    private void initializ() {
        this.setExecutionTime(this.date.getCurrentDate().plusDays(5));
    }

    @Override
    public void run() {
        int bounty = (int)Math.abs((double)(this.opponent.getCash() / 2000L) * this.rnd.nextDouble());
        this.opponent.updateCash(-bounty);
        String s = this.messageSource.getMessage("ch.sahits.game.graphic.event.task.BreakInAction.message", new Object[]{bounty, this.opponent.getLastName()}, this.locale.getCurrentLocal());
        DisplayMessage msg = new DisplayMessage(s);
        this.clientEventBus.post((Object)msg);
    }
}

