/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.javafx.display;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.NoticeBoardClose;
import ch.sahits.game.graphic.display.dialog.util.EDialogType;
import ch.sahits.game.graphic.display.gameplay.internal.EScene;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.graphic.display.notice.ENoticeItem;
import ch.sahits.game.graphic.javafx.display.IDialogContoller;
import ch.sahits.game.graphic.javafx.display.ISceneEventHandler;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ObjectPropertyType;
import ch.sahits.game.openpatrician.util.StartNewGameBean;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
@ClassCategory(value={EClassCategory.HANDLER})
public class CityHallSceneEventHandler
implements ISceneEventHandler {
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    @ObjectPropertyType(value=EScene.class)
    private ObjectProperty<EScene> currentScene = new SimpleObjectProperty((Object)this, "currentScene", (Object)EScene.PORT);
    private IDialogContoller dialogContoller;

    @Override
    public ObjectProperty<EScene> currentSceneProperty() {
        return this.currentScene;
    }

    @Override
    public void setDialogContoller(IDialogContoller dialogContoller) {
        this.dialogContoller = dialogContoller;
    }

    @Override
    public void handleEvent(Object eventNotice) {
        Preconditions.checkNotNull((Object)this.dialogContoller, (Object)"Dialog controller must be initialized first");
        if (eventNotice instanceof ViewChangeCityPlayerProxyJFX) {
            ViewChangeCityPlayerProxyJFX cityProxy = (ViewChangeCityPlayerProxyJFX)eventNotice;
            if (cityProxy.getViewChangeEvent() == EViewChangeEvent.MAIN_VIEW_MARKET) {
                this.clientEventBus.post((Object)new NoticeBoardClose());
                this.currentScene.set((Object)EScene.MARKET);
                this.dialogContoller.changeScene();
            }
            if (cityProxy.getViewChangeEvent() == EViewChangeEvent.NOTICE_CITY_HALL_MEETINGROOM) {
                this.dialogContoller.setNewDialog(EDialogType.CITY_HALL_MEETING_ROOM);
            }
        }
        if (eventNotice instanceof ENoticeItem) {
            EDialogType dialogType;
            switch ((ENoticeItem)((Object)eventNotice)) {
                case CITY_HALL_NOTICE: {
                    dialogType = EDialogType.CITY_HALL_NOTICE;
                    break;
                }
                case CITY_HALL_OUTRIGGER: {
                    dialogType = EDialogType.CITY_HALL_OUTRIGGER;
                    break;
                }
                case CITY_HALL_TOWN_INFO: {
                    dialogType = EDialogType.CITY_HALL_TOWN_INFO;
                    break;
                }
                case CITY_HALL_TREASURY: {
                    dialogType = EDialogType.CITY_HALL_TREASURY;
                    break;
                }
                case CITY_HALL_HANSEATIC_INFO: {
                    dialogType = EDialogType.CITY_HALL_HANSEATIC_INFO;
                    break;
                }
                case CITY_HALL_CITY_WALL: {
                    dialogType = EDialogType.CITY_HALL_CITY_WALL;
                    break;
                }
                case CITY_HALL_ELDERMAN_OFFICE: {
                    dialogType = EDialogType.CITY_HALL_ALDERMAN_OFFICE;
                    break;
                }
                case CITY_HALL_MEETING_ROOM: {
                    dialogType = EDialogType.CITY_HALL_MEETING_ROOM;
                    break;
                }
                default: {
                    throw new RuntimeException("Not yet implemented eventNotice: " + eventNotice);
                }
            }
            this.dialogContoller.replaceDialog(dialogType);
        }
    }
}

