/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.javafx.display;

import ch.sahits.game.event.handler.impl.EventHandlerFactory;
import ch.sahits.game.javafx.control.DisplayMessageOverlayLabel;
import ch.sahits.game.javafx.control.TextSizingUtility;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@LazySingleton
@ClassCategory(value={EClassCategory.HANDLER})
public class DisplayMessageOverlay
extends VBox {
    private static final int DISPLAY_MESSAGE_FOR_SECONDS = 15;
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    @Autowired
    @Qualifier(value="uiTimer")
    private Timer uiTimer;
    @Autowired
    private TextSizingUtility sizeing;
    @Autowired
    private EventHandlerFactory eventHandlerFactory;

    @PostConstruct
    private void init() {
        this.clientEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregister() {
        this.clientEventBus.unregister((Object)this);
    }

    @Subscribe
    public void handleMessage(DisplayMessage message) {
        System.out.println("Caught display message: " + message.getMessage());
        final DisplayMessageOverlayLabel label = new DisplayMessageOverlayLabel(message.getMessage(), this.sizeing);
        if (message.hasDialogTemplate()) {
            label.setLinkText(true);
            EventHandler<MouseEvent> openDialogEvenHandler = this.createEventHandlerFromRunnable(this.eventHandlerFactory.getViewChangeActionRunnable(message.getDialogTemplate()));
            label.setOnMouseReleased(openDialogEvenHandler);
        }
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                Platform.runLater(() -> DisplayMessageOverlay.this.getChildren().remove((Object)label));
            }
        };
        this.uiTimer.schedule(task, 15000L);
        Platform.runLater(() -> this.getChildren().add(0, (Object)label));
    }

    private EventHandler<MouseEvent> createEventHandlerFromRunnable(final Runnable run) {
        return new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                run.run();
            }
        };
    }
}

