/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.javafx.display;

import ch.sahits.game.graphic.image.EScaleDirection;
import ch.sahits.game.graphic.image.ImageScaleState;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import java.util.List;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Polygon;

@ClassCategory(value={EClassCategory.JAVAFX})
public class MainGameImageView
extends Group {
    private boolean withPolygonShading = false;
    private Color[] colors = new Color[]{Color.RED, Color.GREEN, Color.BLUE, Color.YELLOW, Color.PINK};

    public MainGameImageView(double width, double height, ImageView imgView, ImageScaleState state) {
        this.setManaged(false);
        if (System.getProperty("javafx.polygon.shading") != null) {
            this.withPolygonShading = true;
        }
        this.setImageView(width, height, imgView, state);
    }

    void setImageView(double width, double height, ImageView imgView, ImageScaleState state) {
        this.getChildren().clear();
        double x = Math.max((width - imgView.getBoundsInLocal().getWidth()) / 2.0, 0.0);
        double y = Math.max((height - imgView.getBoundsInLocal().getHeight()) / 2.0, 0.0);
        if (x > 0.0) {
            state.border();
            state.setBorderDirection(EScaleDirection.HORIZONTAL);
            state.setBordered((int)x);
        } else if (y > 0.0) {
            state.border();
            state.setBorderDirection(EScaleDirection.VERTICAL);
            state.setBordered((int)y);
        }
        imgView.setLayoutX(x);
        imgView.setLayoutY(y);
        this.getChildren().add((Object)imgView);
    }

    public void resetPolygons(List<Polygon> polygons) {
        ImageView imageView = this.getImageView();
        for (int i = 0; i < polygons.size(); ++i) {
            Polygon polygon = polygons.get(i);
            if (imageView != null) {
                polygon.setLayoutX(imageView.getLayoutX());
                polygon.setLayoutY(imageView.getLayoutY());
            }
            if (this.withPolygonShading) {
                polygon.setFill((Paint)this.colors[i % this.colors.length]);
                polygon.setOpacity(0.5);
            } else {
                polygon.setFill((Paint)Color.TRANSPARENT);
            }
            this.getChildren().add((Object)polygon);
        }
    }

    private ImageView getImageView() {
        for (Node node : this.getChildren()) {
            if (!(node instanceof ImageView)) continue;
            return (ImageView)node;
        }
        return null;
    }
}

