/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.javafx.display;

import ch.sahits.game.event.ViewChangeEvent;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.dialog.util.DialogFactory;
import ch.sahits.game.graphic.display.dialog.util.EDialogType;
import ch.sahits.game.graphic.display.gameplay.internal.EScene;
import ch.sahits.game.graphic.display.gameplay.internal.PolygonInitializerFactory;
import ch.sahits.game.graphic.image.IDataImageLoader;
import ch.sahits.game.graphic.image.IFontLoader;
import ch.sahits.game.graphic.image.IImageUtilities;
import ch.sahits.game.graphic.image.ImageScaleState;
import ch.sahits.game.graphic.image.model.ImageData;
import ch.sahits.game.graphic.javafx.display.DisplayMessageOverlay;
import ch.sahits.game.graphic.javafx.display.IDialogContoller;
import ch.sahits.game.graphic.javafx.display.MainGameImageView;
import ch.sahits.game.graphic.javafx.display.SceneEventHandlerFactory;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.DialogCloseing;
import ch.sahits.game.openpatrician.annotation.DialogOpening;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ObjectPropertyType;
import ch.sahits.game.openpatrician.annotation.UniquePrototype;
import ch.sahits.game.openpatrician.dialog.Dialog;
import ch.sahits.game.openpatrician.dialog.DialogTemplate;
import ch.sahits.game.openpatrician.spring.DependentAnnotationConfigApplicationContext;
import ch.sahits.game.openpatrician.spring.DialogScope;
import ch.sahits.game.openpatrician.util.IRebinabable;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Dimension2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Rectangle;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@UniquePrototype
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class MainGameView
extends Group
implements IDialogContoller,
IRebinabable {
    private static final Logger logger = LogManager.getLogger(MainGameView.class);
    public static final int MINMIMAL_DISPLAY_HEIGHT = 766;
    private double controlWidth;
    private double controlHeight;
    @Autowired
    private IImageUtilities imageUtils;
    @Autowired
    @Qualifier(value="mainScreenXMLImageLoader")
    private IDataImageLoader xmlLoader;
    @Autowired
    private IFontLoader fontLoader;
    @Autowired
    private DialogFactory dialogFactory;
    private Rectangle placeHolder;
    private MainGameImageView imgView;
    private Dialog dialog;
    @Autowired
    private DialogScope dialogScope;
    @ObjectPropertyType(value=EScene.class)
    private ObjectProperty<EScene> currentScene = new SimpleObjectProperty((Object)this, "currentScene", (Object)EScene.PORT);
    @Autowired
    private SceneEventHandlerFactory sceneEventHandlerFactory;
    @Autowired
    private PolygonInitializerFactory polygonInitFactory;
    @Autowired
    private ClientViewState viewState;
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    @Autowired
    private DisplayMessageOverlay dispMesgOverlay;
    @Autowired
    private DependentAnnotationConfigApplicationContext context;
    private StackPane stack;

    public MainGameView(double width, double heigth) {
        this.setManaged(false);
        this.controlWidth = width;
        this.controlHeight = heigth;
    }

    @PostConstruct
    private void createComponents() {
        this.setUpImageView();
        this.sceneEventHandlerFactory.currentSceneProperty().bindBidirectional(this.currentScene);
        this.sceneEventHandlerFactory.setUpDialogController(this);
        this.polygonInitFactory.currentSceneProperty().bindBidirectional(this.currentScene);
        this.stack = new StackPane();
        this.stack.getChildren().add((Object)this.imgView);
        this.placeHolder = new Rectangle(this.controlWidth, this.controlHeight);
        this.placeHolder.setFill((Paint)Color.BLACK);
        this.dispMesgOverlay.setLayoutY(10.0);
        this.dispMesgOverlay.setLayoutX(10.0);
        this.getChildren().addAll((Object[])new Node[]{this.placeHolder, this.stack, this.dispMesgOverlay});
        this.clientEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregister() {
        this.clientEventBus.unregister((Object)this);
    }

    private String getImageNameFromScene() {
        switch ((EScene)((Object)this.currentScene.get())) {
            case MARKET: {
                return "images/scene/marketPlaceScene";
            }
            case PORT: {
                return "images/scene/portScene";
            }
            case SHIPYARD: {
                return "images/scene/shipYard";
            }
            case TAVERN: {
                return "images/scene/tavernIterior";
            }
            case CITY_HALL: {
                return "images/scene/cityhall";
            }
            case LOANER: {
                return "images/scene/loaner";
            }
            case CHURCH: {
                return "images/scene/churchInterior";
            }
        }
        throw new RuntimeException(this.currentScene.get() + " is not implemented");
    }

    private void setUpImageView() {
        String imageName = this.getImageNameFromScene();
        Image tmpImg = this.xmlLoader.getImage(imageName);
        ImageData imgData = this.xmlLoader.getImageData(imageName);
        Dimension2D targetDim = new Dimension2D(this.controlWidth, this.controlHeight);
        ImageScaleState state = new ImageScaleState(new Dimension2D(tmpImg.getWidth(), tmpImg.getHeight()), targetDim, imgData.getCrop(), imgData.getMaxCrop());
        logger.debug("State of the port scene before: " + state);
        this.imgView = new MainGameImageView(this.controlWidth, this.controlHeight, this.imageUtils.cropAndScale(imageName, state), state);
        List<Polygon> polygons = this.polygonInitFactory.getScenePolygonInitializer().initialzePolygons(state);
        this.imgView.resetPolygons(polygons);
        logger.debug("State of the port scene after : " + state);
    }

    public void widthChange(double oldWidth, double newWidth) {
        String imageName = this.getImageNameFromScene();
        Image tmpImg = this.xmlLoader.getImage(imageName);
        ImageData imgData = this.xmlLoader.getImageData(imageName);
        Dimension2D targetDim = new Dimension2D(newWidth, this.controlHeight);
        ImageScaleState state = new ImageScaleState(new Dimension2D(tmpImg.getWidth(), tmpImg.getHeight()), targetDim, imgData.getCrop(), imgData.getMaxCrop());
        ImageView tmpImgView = this.imageUtils.cropAndScale(imageName, state);
        this.imgView.setImageView(newWidth, this.controlHeight, tmpImgView, state);
        List<Polygon> polygons = this.polygonInitFactory.getScenePolygonInitializer().initialzePolygons(state);
        this.imgView.resetPolygons(polygons);
        this.placeHolder.setWidth(newWidth);
        this.controlWidth = newWidth;
    }

    public void heightChange(double oldHeight, double newHeigth) {
        String imageName = this.getImageNameFromScene();
        Image tmpImg = this.xmlLoader.getImage(imageName);
        ImageData imgData = this.xmlLoader.getImageData(imageName);
        Dimension2D targetDim = new Dimension2D(this.controlWidth, newHeigth);
        ImageScaleState state = new ImageScaleState(new Dimension2D(tmpImg.getWidth(), tmpImg.getHeight()), targetDim, imgData.getCrop(), imgData.getMaxCrop());
        ImageView tmpImgView = this.imageUtils.cropAndScale(imageName, state);
        this.imgView.setImageView(this.controlWidth, newHeigth, tmpImgView, state);
        List<Polygon> polygons = this.polygonInitFactory.getScenePolygonInitializer().initialzePolygons(state);
        this.imgView.resetPolygons(polygons);
        this.placeHolder.setHeight(newHeigth);
        this.controlHeight = newHeigth;
    }

    @Subscribe
    public void handleViewChange(ViewChangeEvent event) {
        if (event.getAddresse().equals(MainGameView.class)) {
            if (event.getEventNotice() instanceof DialogTemplate) {
                this.setNewDialog((DialogTemplate)event.getEventNotice());
            } else {
                this.sceneEventHandlerFactory.getSceneEventHandler().handleEvent(event.getEventNotice());
            }
        }
    }

    @Override
    public void replaceDialog(EDialogType dialogType) {
        this.closeDialog();
        while (this.dialog != null) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.setNewDialog(dialogType);
    }

    @Override
    @DialogCloseing
    public void closeDialog() {
        if (Platform.isFxApplicationThread()) {
            this.closeDialogUnwrapped();
        } else {
            Platform.runLater(() -> this.closeDialogUnwrapped());
        }
    }

    private void closeDialogUnwrapped() {
        if (this.dialog != null) {
            this.context.removePrototypeBean((Object)this.dialog);
            this.getChildren().remove((Object)this.dialog);
            this.dialog = null;
            this.dialogScope.closeScope();
        }
    }

    @Override
    @DialogOpening
    public void setNewDialog(EDialogType dialogType) {
        this.dialog = this.dialogFactory.getDialog(dialogType, this.viewState.getCurrentCityProxy().get());
        this.setNewDialog();
    }

    @Override
    @DialogOpening
    public void setNewDialog(DialogTemplate template) {
        this.dialog = this.dialogFactory.getDialog(template);
        this.setNewDialog();
    }

    private void setNewDialog() {
        this.dialogScope.openScope();
        this.dialog.setLayoutX((this.controlWidth - 518.0) / 2.0);
        this.dialog.setLayoutY((this.controlHeight - 691.0) / 2.0);
        if (Platform.isFxApplicationThread()) {
            this.getChildren().add((Object)this.dialog);
        } else {
            Platform.runLater(() -> this.getChildren().add((Object)this.dialog));
        }
    }

    @Override
    public void changeScene() {
        if (Platform.isFxApplicationThread()) {
            this.changeSceneUnwrapped();
        } else {
            Platform.runLater(() -> this.changeSceneUnwrapped());
        }
    }

    private void changeSceneUnwrapped() {
        this.closeDialog();
        this.stack.getChildren().removeAll((Object[])new Node[]{this.imgView});
        this.setUpImageView();
        this.stack.getChildren().add((Object)this.imgView);
    }

    public void rebind() {
        this.setUpImageView();
    }
}

