/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.javafx.display;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.graphic.display.dialog.util.EDialogType;
import ch.sahits.game.graphic.display.gameplay.internal.EScene;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.graphic.display.notice.ENoticeItem;
import ch.sahits.game.graphic.javafx.display.IDialogContoller;
import ch.sahits.game.graphic.javafx.display.ISceneEventHandler;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ObjectPropertyType;
import ch.sahits.game.openpatrician.util.StartNewGameBean;
import com.google.common.base.Preconditions;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
@ClassCategory(value={EClassCategory.HANDLER})
public class PortSceneEventHandler
implements ISceneEventHandler {
    @ObjectPropertyType(value=EScene.class)
    private ObjectProperty<EScene> currentScene = new SimpleObjectProperty((Object)this, "currentScene", (Object)EScene.PORT);
    private IDialogContoller dialogContoller;

    @Override
    public ObjectProperty<EScene> currentSceneProperty() {
        return this.currentScene;
    }

    @Override
    public void setDialogContoller(IDialogContoller dialogContoller) {
        this.dialogContoller = dialogContoller;
    }

    @Override
    public void handleEvent(Object eventNotice) {
        Preconditions.checkNotNull((Object)this.dialogContoller, (Object)"Dialog controller must be initialized first");
        if (eventNotice instanceof ViewChangeCityPlayerProxyJFX) {
            ViewChangeCityPlayerProxyJFX cityProxy = (ViewChangeCityPlayerProxyJFX)eventNotice;
            if (cityProxy.getViewChangeEvent() == EViewChangeEvent.NOTICE_TRADE) {
                this.dialogContoller.setNewDialog(EDialogType.CITY_TO_SHIP);
            }
            if (cityProxy.getViewChangeEvent() == EViewChangeEvent.NOTICE_TRADING_OFFICE) {
                this.dialogContoller.setNewDialog(EDialogType.TO_BALANCE);
            }
            if (cityProxy.getViewChangeEvent() == EViewChangeEvent.MAIN_VIEW_MARKET) {
                this.currentScene.set((Object)EScene.MARKET);
                this.dialogContoller.changeScene();
            }
            if (cityProxy.getViewChangeEvent() == EViewChangeEvent.MAIN_VIEW_SHIPYARD) {
                this.currentScene.set((Object)EScene.SHIPYARD);
                this.dialogContoller.changeScene();
            }
            if (cityProxy.getViewChangeEvent() == EViewChangeEvent.MAIN_VIEW_TAVERN) {
                this.currentScene.set((Object)EScene.TAVERN);
                this.dialogContoller.changeScene();
            }
            if (cityProxy.getViewChangeEvent() == EViewChangeEvent.MAIN_VIEW_LOANER) {
                this.currentScene.set((Object)EScene.LOANER);
                this.dialogContoller.changeScene();
            }
        }
        if (eventNotice instanceof ENoticeItem) {
            EDialogType dialogType;
            switch ((ENoticeItem)((Object)eventNotice)) {
                case PORT_CITY_TO_SHIP: {
                    dialogType = EDialogType.CITY_TO_SHIP;
                    break;
                }
                case PORT_CITY_TO_STORAGE: {
                    dialogType = EDialogType.CITY_TO_STORAGE;
                    break;
                }
                case PORT_STORAGE_TO_SHIP: {
                    dialogType = EDialogType.STORAGE_TO_SHIP;
                    break;
                }
                case TO_BALANCE: {
                    dialogType = EDialogType.TO_BALANCE;
                    break;
                }
                case TO_PERSONAL: {
                    dialogType = EDialogType.TO_PERSONAL;
                    break;
                }
                case TO_CONSUMPTION_PRODUCTION: {
                    dialogType = EDialogType.TO_CONSUMPTION_PRODUCTION;
                    break;
                }
                case TO_OFFICE_TRADING: {
                    dialogType = EDialogType.TO_OFFICE_TRADING;
                    break;
                }
                case TO_WAREHOUSES: {
                    dialogType = EDialogType.TO_WAREHOUSES;
                    break;
                }
                case TO_WEAPONS: {
                    dialogType = EDialogType.TO_WEAPONS;
                    break;
                }
                default: {
                    throw new RuntimeException("Not yet implemented eventNotice: " + eventNotice);
                }
            }
            this.dialogContoller.replaceDialog(dialogType);
        }
    }
}

