/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.javafx.control;

import ch.sahits.game.event.NavigationStateChange;
import ch.sahits.game.event.data.NewGameClient;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.image.IImageUtilities;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.model.IMap;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.util.IRebinabable;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import javafx.application.Platform;
import javafx.geometry.Dimension2D;
import javafx.geometry.Rectangle2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@LazySingleton
@ClassCategory(value={EClassCategory.JAVAFX, EClassCategory.SINGLETON_BEAN})
public class MiniMap
extends Group
implements IRebinabable {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    @Autowired
    private IMap map;
    @Autowired
    private IImageUtilities imageUtilities;
    @Autowired
    private ClientViewState viewState;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    private ImageView imgView;
    private boolean navigationDisabled = false;

    @PostConstruct
    private void initializeControl() {
        this.clientServerEventBus.register((Object)this);
        this.clientEventBus.register((Object)this);
        this.setManaged(false);
        this.imgView = new ImageView();
        this.imgView.setFitWidth(236.0);
        this.imgView.setFitHeight(192.0);
        this.imgView.setPreserveRatio(false);
        this.getChildren().addAll((Object[])new Node[]{this.imgView});
    }

    @Subscribe
    public void initializeState(NewGameClient newGameDTO) {
        IPlayer player = newGameDTO.getPlayer();
        this.initializeMapImage(player);
    }

    private void initializeMapImage(IPlayer player) {
        Image mapImage = this.imageUtilities.createMapWithCities(this.map, player);
        mapImage = this.imageUtilities.createImageWithShipsInCities(this.map, player, mapImage);
        Dimension2D dim = this.map.getDimension();
        double factor = 192.0 / dim.getHeight();
        double widthOrigImg = 236.0 / factor;
        double xlocation = player.getHometown().getCoordinates().getX();
        double x = Math.max(0.0, xlocation - widthOrigImg / 2.0);
        Rectangle2D viewport = new Rectangle2D(x, 0.0, widthOrigImg, dim.getHeight());
        Image transferableMap = mapImage;
        Platform.runLater(() -> {
            this.imgView.setViewport(viewport);
            this.imgView.setImage(transferableMap);
        });
    }

    @Subscribe
    public void handleNAvigationChange(NavigationStateChange event) {
        switch (event.getChange()) {
            case DISABLE_NAVIGATION: {
                this.navigationDisabled = true;
                break;
            }
            case ENABLE_NAVIGATION: {
                this.navigationDisabled = false;
                break;
            }
            default: {
                this.logger.info("Not interested in navigation change event: " + event.getChange());
            }
        }
    }

    public void rebind() {
        this.initializeMapImage(this.viewState.getPlayer());
    }
}

