/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.javafx.model;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ListType;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.util.StartNewGameBean;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import javafx.beans.property.SimpleListProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.SINGLETON_BEAN})
public class DisplayMessages {
    @XStreamOmitField
    private final Logger logger = LogManager.getLogger(this.getClass());
    @Autowired
    @Qualifier(value="clientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientEventBus;
    @ListType(value=DisplayMessage.class)
    private SimpleListProperty<DisplayMessage> messages = new SimpleListProperty();

    public DisplayMessages() {
        this.messages.set(FXCollections.observableArrayList());
    }

    @PostConstruct
    private void init() {
        this.clientEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregister() {
        this.logger.debug("Unregister event bus in PreDestroy");
        this.clientEventBus.unregister((Object)this);
    }

    public boolean add(DisplayMessage element) {
        if (this.messages.size() == 50) {
            this.messages.remove(50);
        }
        this.messages.add(0, (Object)element);
        return true;
    }

    @Subscribe
    public void handleMessage(DisplayMessage message) {
        this.add(message);
    }

    public ObservableList<DisplayMessage> messagesProperty() {
        return this.messages;
    }
}

