package ch.sahits.game.graphic.display.dialog.action;


import ch.sahits.game.graphic.display.dialog.util.ITransferableJFX;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;

import java.util.Map;
import java.util.Map.Entry;

/**
 * This action handles the case of transfering wares from the ship into the storage
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Dec 24, 2011
 *
 */
@ClassCategory(EClassCategory.HANDLER)
class Ship2StorageJFXAction implements Runnable {
	private final IWare ware;
	private final ITransferableJFX transfer;

	public Ship2StorageJFXAction(IWare ware, ITransferableJFX transfer) {
		super();
		this.ware = ware;
		this.transfer=transfer;
	}

	@Override
	public void run() {
		INavigableVessel ship = transfer.getVessel();
        final AmountablePrice<IWare> amountable = ship.getWare(this.ware);
        int availableAmountShip = amountable.getAmount();
		final IPlayer player = transfer.getPlayer();
		ITradingOffice office = player.findTradingOffice(transfer.getCity());
		if (availableAmountShip>0 && office!=null){
			int amount2Move = transfer.getAmount(availableAmountShip); // This is ware specific size
			int avgPrice = amountable.getAVGPrice();
			int moved = ship.unload(this.ware, amount2Move);
			office.move(this.ware, moved,avgPrice);
			if (ship instanceof IConvoy) {
				// Handle this for any other ship in the convoy as if the ware was sold to the convoy owner at cost.
				IConvoy convoy = (IConvoy) ship;
				Map<IPlayer, Integer> capacityMap = convoy.getCapacityPerOwner();
				long totalCash = avgPrice * moved;
				double totalCapacity = convoy.getCapacity();
				for (Entry<IPlayer, Integer> entry : capacityMap.entrySet()) {
					if (!entry.getKey().equals(player)) {
						double percentage = entry.getValue()/totalCapacity;
						long partialAmount = Math.round(totalCash*percentage);
						entry.getKey().getCompany().updateCash(partialAmount);
						player.getCompany().updateCash(-partialAmount);
					}
				}
			}
		}

	}

}
