package ch.sahits.game.graphic.display.dialog.action;


import ch.sahits.game.graphic.display.dialog.util.ITransferableJFX;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;

import java.util.Map;
import java.util.Map.Entry;

/**
 * This action handles the transfer of wares from the storage to the ship.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Dec 24, 2011
 *
 */
@ClassCategory(EClassCategory.HANDLER)
public class Storage2ShipJFXAction implements Runnable {
	private final IWare ware;
	private final ITransferableJFX transfer;

	public Storage2ShipJFXAction(IWare ware, ITransferableJFX transfer) {
		super();
		this.ware = ware;
		this.transfer=transfer;
	}

	@Override
	public void run() {
		INavigableVessel ship = transfer.getVessel();
        final IPlayer player = transfer.getPlayer();
        ITradingOffice office = player.findTradingOffice(transfer.getCity());
		if (office!=null && office.getWare(ware).getAmount()>0){
            final AmountablePrice<IWare> amountable = office.getWare(this.ware);
            int availableAmountStorage = amountable.getAmount();
            int amount2Move = transfer.getAmount(availableAmountStorage); // This is ware specific size
            int avgPrice = amountable.getAVGPrice();
			int moved = office.move(this.ware, -amount2Move,avgPrice);
			ship.load(this.ware, moved, avgPrice);
			if (ship instanceof IConvoy) {
				// Handle this for any other ship in the convoy as if the ware was bought from the convoy owner at cost.
				IConvoy convoy = (IConvoy) ship;
				Map<IPlayer, Integer> capacityMap = convoy.getCapacityPerOwner();
				long totalCash = -avgPrice * moved;
				double totalCapacity = convoy.getCapacity();
				for (Entry<IPlayer, Integer> entry : capacityMap.entrySet()) {
                    if (!entry.getKey().equals(player)) {
                        double percentage = entry.getValue() / totalCapacity;
                        long partialAmount = Math.round(totalCash * percentage);
                        entry.getKey().getCompany().updateCash(partialAmount);
                        player.getCompany().updateCash(-partialAmount);
                    }
				}
			}
		}
	}
	
}
