package ch.sahits.game.graphic.display.model;

import ch.sahits.game.event.IViewChangeEvent;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import javafx.collections.ObservableList;

/**
 * Proxy object for city player for view changes.
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Dec 19, 2011
 *
 */
@ClassCategory(EClassCategory.DEPENDS_ON_SERIALIZED_BEAN)
public class ViewChangeCityPlayerProxyJFX implements ICityPlayerProxyJFX {
	
	private final IViewChangeEvent viewchange;
	private final ICityPlayerProxyJFX proxy;
	/**
	 * Constructor by making a copy of the passed proxy
	 * @param proxy
	 */
	public ViewChangeCityPlayerProxyJFX(ICityPlayerProxyJFX proxy,IViewChangeEvent event){
		this.proxy=proxy;
		this.viewchange=event;
	}
	
	public IViewChangeEvent getViewChangeEvent(){
		return viewchange;
	}

	@Override
	public INavigableVessel getActiveShip() {
		return proxy.getActiveShip();
	}

	@Override
	public ObservableList<INavigableVessel> getPlayersNavalVessels() {
		return proxy.getPlayersNavalVessels();
	}
	@Override
	public ICity getCity() {
		return proxy.getCity();
	}
	@Override
	public void setCity(ICity city) {
		proxy.setCity(city);
	}

	public IHumanPlayer getPlayer() {
		return proxy.getPlayer();
	}

	@Override
	public void activateShip(INavigableVessel ship) {
		proxy.activateShip(ship);
	}

	@Override
	public ObservableList<IShip> getPlayersShips() {
		return proxy.getPlayersShips();
	}

	@Override
	public void arrive(INavigableVessel ship) {
		proxy.arrive(ship);
	}

	@Override
	public void leave(INavigableVessel ship) {
		proxy.leave(ship);
	}
}
