package ch.sahits.game.util;

import ch.sahits.game.graphic.display.OpenPaticianApplicationWindow;
import ch.sahits.game.graphic.display.scene.CreditsScene;
import ch.sahits.game.graphic.display.scene.HanseaticHistoryScene;
import ch.sahits.game.graphic.display.scene.InGameOptionsScene;
import ch.sahits.game.graphic.display.scene.LoadGameScene;
import ch.sahits.game.graphic.display.scene.MainGameScene;
import ch.sahits.game.graphic.display.scene.NewGameScene;
import ch.sahits.game.graphic.display.scene.StartupScene;
import ch.sahits.game.graphic.image.IDataImageLoader;
import ch.sahits.game.graphic.image.IFontLoader;
import ch.sahits.game.graphic.image.IJavaFXControlLoader;
import ch.sahits.game.graphic.image.impl.FontLoader;
import ch.sahits.game.graphic.javafx.display.MainGameView;
import ch.sahits.game.javafx.OpenPatricianScene;
import ch.sahits.game.javafx.control.GameStatus;
import ch.sahits.game.javafx.control.MainMenu;
import ch.sahits.game.javafx.control.MiniMap;
import ch.sahits.game.javafx.control.NoticeBoard;
import ch.sahits.game.javafx.control.SubMenu;
import ch.sahits.game.javafx.control.ViewStatus;
import ch.sahits.game.openpatrician.IInvalidatable;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.collections.NonReplacableMap;
import ch.sahits.game.openpatrician.util.RandomNameLoader;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

import javax.annotation.PostConstruct;
import java.util.Iterator;
import java.util.Map.Entry;

/**
 * Factory class for various instances.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 01, 2014
 */
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class UIFactory implements IInvalidatable{
    @Autowired
    private ApplicationContext context;
    /**
     * Scenes must be declared as prototypes as they have constructor arguments, even though they actually
     * are singletons. Therefore cache them here with the bean name.
     */
    private final NonReplacableMap<String, OpenPatricianScene> sceneMap = new NonReplacableMap<>();

    private IJavaFXControlLoader jfxControlLoader;
    @PostConstruct
    private void init() {
        jfxControlLoader = new JavaFXControlLoader();
    }
    /**
     * Retrieve the XML image loader for the main screen
     * @return
     */
    public IDataImageLoader getXMLImageLoader(){
        return (IDataImageLoader) context.getBean("mainScreenXMLImageLoader");
    }
    public MainGameScene getMainGameScene(double width, double heigth) {
        if (!sceneMap.containsKey("mainGameScene")) {
            sceneMap.put("mainGameScene", (OpenPatricianScene) context.getBean("mainGameScene", width, heigth, getXMLImageLoader(), jfxControlLoader));
        }
        return (MainGameScene) sceneMap.get("mainGameScene");
    }
    public StartupScene getStartupScene() {
        if (!sceneMap.containsKey("startupScene")) {
            sceneMap.put("startupScene", (StartupScene) context.getBean("startupScene"));
        }
        return (StartupScene) sceneMap.get("startupScene");
    }
    public HanseaticHistoryScene getHanseaticHistoryScene() {
        if (!sceneMap.containsKey("hanseaticHistoryScene")) {
            sceneMap.put("hanseaticHistoryScene", (HanseaticHistoryScene) context.getBean("hanseaticHistoryScene"));
        }
        return (HanseaticHistoryScene) sceneMap.get("hanseaticHistoryScene");
    }

    public CreditsScene getCreditsScene() {
        if (!sceneMap.containsKey("creditsScene")) {
            sceneMap.put("creditsScene", (CreditsScene) context.getBean("creditsScene"));
        }
        return (CreditsScene) sceneMap.get("creditsScene");
    }
    public NewGameScene getNewGameScene() {
        if (!sceneMap.containsKey("newGameScene")){
            RandomNameLoader firstNameLoader = (RandomNameLoader) context.getBean("firstNameLoader");
            RandomNameLoader lastNameLoader = (RandomNameLoader) context.getBean("lastNameLoader");

            NewGameScene newGameScene = (NewGameScene) context.getBean("newGameScene", firstNameLoader, lastNameLoader);
            newGameScene.setSceneChangeable(OpenPaticianApplicationWindow.getApplication());
            sceneMap.put("newGameScene", newGameScene);
        }
        return (NewGameScene) sceneMap.get("newGameScene");
    }

    public LoadGameScene getLoadGameScene() {
        if (!sceneMap.containsKey("loadGameScene")){

            LoadGameScene loadGameScene = (LoadGameScene) context.getBean("loadGameScene");
            loadGameScene.setSceneChangeable(OpenPaticianApplicationWindow.getApplication());
            sceneMap.put("loadGameScene", loadGameScene);
        }
        return (LoadGameScene) sceneMap.get("loadGameScene");
    }

    public InGameOptionsScene getInGameOptionsScene() {
        if (!sceneMap.containsKey("inGameOptionsScene")) {
            sceneMap.put("inGameOptionsScene", (InGameOptionsScene) context.getBean("inGameOptionsScene"));
        }
        return (InGameOptionsScene) sceneMap.get("inGameOptionsScene");
    }
    public IJavaFXControlLoader getJavaFXControlLoader() {
        return jfxControlLoader;
    }

    @Override
    public void invalidate() {
        for (Iterator<Entry<String, OpenPatricianScene>> iterator = sceneMap.entrySet().iterator(); iterator.hasNext(); ) {
            Entry<String, OpenPatricianScene> next = iterator.next();
            System.out.println("Remove "+next.getKey());
            iterator.remove();
        }
    }

    private class JavaFXControlLoader implements IJavaFXControlLoader {

        @Override
        public MiniMap getMiniMap() {
            return (MiniMap) context.getBean("miniMap");
        }

        @Override
        public MainMenu getMainMenu() {
            return (MainMenu) context.getBean("mainMenu");
        }

        @Override
        public SubMenu getSubMenu() {
            return (SubMenu) context.getBean("subMenu");
        }

        @Override
        public NoticeBoard getNoticeBoard() {
            NoticeBoard noticeBoard = context.getBean(NoticeBoard.class);
            return noticeBoard;
        }

        @Override
        public ViewStatus getViewStatus() {
            return (ViewStatus) context.getBean("viewStatus");
        }

        @Override
        public IFontLoader getFontLoader() {
            return context.getBean(FontLoader.class);
        }

        @Override
        public GameStatus getGameStatus() {
            return context.getBean(GameStatus.class);
        }
        @Override
        public MainGameView getMainGameView(double width, double heigth) {
            Object[] args = new Object[]{width, heigth};
            return (MainGameView) context.getBean("mainGameView", args);
        }

    }
}
