/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.action;

import ch.sahits.game.graphic.display.dialog.util.ITransferableJFX;
import ch.sahits.game.javafx.bindings.ConstantIntegerBinding;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import com.google.common.base.Preconditions;
import java.util.Map;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.util.Pair;

@ClassCategory(value={EClassCategory.HANDLER})
class City2ShipJFXAction
implements Runnable {
    private final IWare ware;
    private final ITransferableJFX transfer;

    public City2ShipJFXAction(IWare ware, ITransferableJFX transfer) {
        this.ware = ware;
        this.transfer = transfer;
    }

    @Override
    public void run() {
        ICity city = this.transfer.getCity();
        int availableAmountCity = city.getWare(this.ware).getAmount();
        if (availableAmountCity > 0) {
            int loaded;
            int amount2Move = this.transfer.getAmount(availableAmountCity);
            short sizeAsBarrels = this.ware.getSizeAsBarrels();
            IPlayer player = this.transfer.getPlayer();
            ITradingOffice office = player.findTradingOffice(city);
            INavigableVessel vessel = this.transfer.getVessel();
            if (sizeAsBarrels == 1) {
                if (office == null) {
                    amount2Move = Math.min(amount2Move, vessel.getCapacity());
                }
            } else {
                int temp = Math.min(amount2Move * sizeAsBarrels, vessel.getCapacity());
                amount2Move = temp / sizeAsBarrels;
            }
            int avgPrice = this.ware.buyPrice((IntegerProperty)new SimpleIntegerProperty(availableAmountCity), (IntegerBinding)new ConstantIntegerBinding(amount2Move));
            long cash = 0L;
            if (vessel instanceof IShip) {
                cash = player.getCompany().getCash();
            } else {
                IConvoy convoy = (IConvoy)vessel;
                for (IPlayer p : convoy.getPlayers()) {
                    cash += p.getCompany().getCash();
                }
            }
            Pair<Integer, Integer> affordable = this.calculateAffordableAmount(cash, amount2Move, avgPrice, availableAmountCity);
            amount2Move = (Integer)affordable.getKey();
            avgPrice = (Integer)affordable.getValue();
            if (amount2Move <= 0) {
                return;
            }
            int movedAmount = city.move(this.ware, -amount2Move, (ICitizen)player);
            if (amount2Move != -movedAmount) {
                avgPrice = this.ware.buyPrice((IntegerProperty)new SimpleIntegerProperty(city.getWare(this.ware).getAmount() + movedAmount), (IntegerBinding)new ConstantIntegerBinding(movedAmount));
                amount2Move = -movedAmount;
            }
            if (office == null) {
                loaded = vessel.load(this.ware, amount2Move, avgPrice);
            } else {
                int capacity = vessel.getCapacity();
                if (amount2Move > capacity) {
                    int loadOntoShip = capacity;
                    int storeInOffice = amount2Move - capacity;
                    loaded = vessel.load(this.ware, loadOntoShip, avgPrice);
                    loaded += office.move(this.ware, storeInOffice);
                } else {
                    loaded = vessel.load(this.ware, amount2Move, avgPrice);
                }
            }
            if (vessel instanceof IShip) {
                player.updateCash(-avgPrice * loaded);
            } else {
                IConvoy convoy = (IConvoy)vessel;
                Map capacityMap = convoy.getCapacityPerOwner();
                long totalCash = -avgPrice * loaded;
                double totalCapacity = convoy.getCapacity();
                for (Map.Entry entry : capacityMap.entrySet()) {
                    double percentage = (double)((Integer)entry.getValue()).intValue() / totalCapacity;
                    long partialAmount = Math.round((double)totalCash * percentage);
                    ((IPlayer)entry.getKey()).getCompany().updateCash(partialAmount);
                }
            }
        }
    }

    Pair<Integer, Integer> calculateAffordableAmount(long cash, int desiredAmount, int avgPrice, int availableAmountCity) {
        if (cash < (long)avgPrice * (long)desiredAmount) {
            int amountAprox = (int)(cash / (long)avgPrice);
            if (amountAprox > 0) {
                int newTempPrice;
                int tempPrice = this.ware.buyPrice((IntegerProperty)new SimpleIntegerProperty(availableAmountCity), (IntegerBinding)new ConstantIntegerBinding(amountAprox));
                Preconditions.checkArgument(((long)(amountAprox * tempPrice) <= cash ? 1 : 0) != 0, (Object)"Buying fewer items never results in a higher avg price");
                while ((long)(amountAprox * tempPrice + tempPrice) < cash && (long)(++amountAprox * (newTempPrice = this.ware.buyPrice((IntegerProperty)new SimpleIntegerProperty(availableAmountCity), (IntegerBinding)new ConstantIntegerBinding(amountAprox)))) <= cash) {
                    tempPrice = newTempPrice;
                }
                return new Pair((Object)amountAprox, (Object)tempPrice);
            }
            return new Pair((Object)0, (Object)0);
        }
        return new Pair((Object)desiredAmount, (Object)avgPrice);
    }
}

