/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.shipyard;

import ch.sahits.game.event.NoticeBoardClose;
import ch.sahits.game.graphic.display.dialog.CloseButtonDialog;
import ch.sahits.game.graphic.image.IFontLoader;
import ch.sahits.game.graphic.image.impl.XMLImageLoader;
import ch.sahits.game.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.javafx.control.OpenPatricianSmallWaxButton;
import ch.sahits.game.javafx.control.PaginationV2;
import ch.sahits.game.javafx.control.PaginationV2Builder;
import ch.sahits.game.javafx.control.PlaceHolder;
import ch.sahits.game.javafx.model.ECellConstraint;
import ch.sahits.game.javafx.model.ITableCell;
import ch.sahits.game.javafx.model.Table;
import ch.sahits.game.javafx.model.TableHeader;
import ch.sahits.game.javafx.model.TableRow;
import ch.sahits.game.javafx.util.JavaFXUtils;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.IShipyard;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.EShipType;
import ch.sahits.game.openpatrician.model.util.ModelTranslations;
import ch.sahits.game.openpatrician.util.TextParser;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

public abstract class BaseShipyardDialog
extends CloseButtonDialog {
    private final Logger logger = LogManager.getLogger(this.getClass());
    protected final ICityPlayerProxyJFX city;
    private IntegerProperty currentShipTypeIndex;
    protected final EShipType[] shipTypes;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private Locale locale;
    @Autowired
    @Qualifier(value="resourceReference")
    private MessageSource resources;
    @Autowired
    private TextParser textParser;
    @Autowired
    @Qualifier(value="mainScreenXMLImageLoader")
    private XMLImageLoader imageLoader;
    @Autowired
    private JavaFXUtils fxUtils;
    @Autowired
    private IFontLoader fontLoader;
    @Autowired
    private ModelTranslations modelTranslations;
    private ECellConstraint cellConstraint;
    private int numberOfColumns;
    protected BooleanBinding enablePreviousNext;
    protected int mainTableYPosition;

    public BaseShipyardDialog(ICityPlayerProxyJFX city) {
        this.city = city;
        this.currentShipTypeIndex = new SimpleIntegerProperty((Object)this, "currentShipTypeIndex", 0);
        IShipyard shipyard = city.getCity().getCityState().getShipyardState();
        this.shipTypes = shipyard.getBuildableShipTypes();
        this.enablePreviousNext = new BooleanBinding(){

            protected boolean computeValue() {
                return true;
            }
        };
        this.mainTableYPosition = 286;
    }

    @PostConstruct
    private void initializeComponents() {
        if (this.hasShips()) {
            Label titleLbl = new Label();
            titleLbl.getStyleClass().add((Object)"dialogText");
            String shipType = this.modelTranslations.getLocalDisplayName(this.getCurrentShipType());
            titleLbl.setText(shipType);
            this.currentShipTypeIndex.addListener((observable, oldValue1, newValue1) -> {
                String st = this.modelTranslations.getLocalDisplayName(this.getCurrentShipType());
                titleLbl.setText(st);
            });
            StackPane titlePane = new StackPane();
            titlePane.setLayoutY(60.0);
            titlePane.getChildren().addAll((Object[])new Node[]{new PlaceHolder(518.0, 1.0), titleLbl});
            this.getContent().add((Object)titlePane);
            ImageView sideView = new ImageView();
            sideView.imageProperty().bind(this.shipSideImageBinding());
            sideView.setLayoutY(70.0);
            sideView.setLayoutX(30.0);
            EventHandler<? super MouseEvent> historyDisplayHandler = this.createHistoryDisplayHandler();
            sideView.setOnMouseReleased(historyDisplayHandler);
            ImageView frontView = new ImageView();
            frontView.imageProperty().bind(this.shipFrontImageBinding());
            frontView.setLayoutY(70.0);
            frontView.setLayoutX(289.0);
            frontView.setOnMouseReleased(historyDisplayHandler);
            this.getContent().addAll((Object[])new Node[]{sideView, frontView});
            Table topTable = this.createTopTable();
            GridPane topTablePane = new GridPane();
            topTablePane.setLayoutX(50.0);
            topTablePane.setLayoutY(250.0);
            RowConstraints rowConstraint = new RowConstraints(48.0);
            rowConstraint.setValignment(VPos.TOP);
            topTablePane.getRowConstraints().add((Object)rowConstraint);
            for (TableRow row : topTable) {
                for (int i = 0; i < topTable.getNumberOfColumns(); ++i) {
                    int colWidth = topTable.getColumnWidth(i);
                    ColumnConstraints colConstraint = new ColumnConstraints((double)colWidth);
                    colConstraint.setHalignment(topTable.getAligenment(i));
                    topTablePane.getColumnConstraints().add((Object)colConstraint);
                    ITableCell cell = row.get(i);
                    String textStyleClass = "tableCell";
                    this.fxUtils.addCellToGridPane(topTablePane, -1, null, i, cell, topTable.getAligenment(i), "tableCell");
                }
            }
            topTablePane.getStyleClass().add((Object)"tableFont");
            Table mainTable = this.createMainTable();
            GridPane mainTablePane = new GridPane();
            mainTablePane.setLayoutX(30.0);
            mainTablePane.setLayoutY((double)this.mainTableYPosition);
            rowConstraint = this.getRowConstraints();
            mainTablePane.getRowConstraints().add((Object)rowConstraint);
            TableHeader header = mainTable.getHeader();
            this.numberOfColumns = mainTable.getNumberOfColumns();
            int currentCol = 0;
            block6: for (int i = 0; i < this.numberOfColumns && header.size() > 0; ++i) {
                int colWidth = mainTable.getColumnWidth(i);
                ColumnConstraints colConstraint = new ColumnConstraints((double)colWidth);
                colConstraint.setHalignment(header.getAligenment(i));
                mainTablePane.getColumnConstraints().add((Object)colConstraint);
                ITableCell cell = header.get(i);
                String textStyleClass = "tableHeader";
                this.fxUtils.addCellToGridPane(mainTablePane, -1, null, currentCol++, cell, header.getAligenment(i), "tableHeader");
                this.cellConstraint = header.getCellConstraint(cell);
                if (this.cellConstraint == null) continue;
                switch (this.cellConstraint) {
                    case COLSPAN2: {
                        --this.numberOfColumns;
                        ++currentCol;
                        continue block6;
                    }
                    case COLSPAN4: {
                        this.numberOfColumns -= 3;
                        currentCol += 3;
                        continue block6;
                    }
                    default: {
                        throw new RuntimeException("Unhandled case");
                    }
                }
            }
            for (int rowNum = 0; rowNum < mainTable.getNumberOfRows(); ++rowNum) {
                TableRow row = mainTable.get(rowNum);
                mainTablePane.getRowConstraints().add((Object)rowConstraint);
                int iterationLimit = Math.min(mainTable.getNumberOfColumns(), row.size());
                for (int col = 0; col < iterationLimit; ++col) {
                    ITableCell cell = row.get(col);
                    HPos hAlignment = mainTable.getAligenment(col);
                    String textStyleClass = "tableCell";
                    this.fxUtils.addCellToGridPane(mainTablePane, rowNum, row, col, cell, hAlignment, "tableCell");
                }
            }
            mainTablePane.getStyleClass().add((Object)"tableFont");
            this.getContent().addAll((Object[])new Node[]{topTablePane, mainTablePane});
            Group footerText = this.createFooterText();
            footerText.setLayoutX(50.0);
            footerText.setLayoutY(454.0);
            int actionButtonX = 197;
            OpenPatricianSmallWaxButton previous = new OpenPatricianSmallWaxButton("<");
            previous.getStyleClass().add((Object)"actionButton");
            previous.setLayoutX(131.0);
            previous.setLayoutY(579.0);
            previous.setOnAction(this.createPreviousAction());
            OpenPatricianSmallWaxButton next = new OpenPatricianSmallWaxButton(">");
            next.getStyleClass().add((Object)"actionButton");
            next.setLayoutX(325.0);
            next.setLayoutY(579.0);
            next.setOnAction(this.createNextAction());
            OpenPatricianLargeWaxButton action = new OpenPatricianLargeWaxButton(this.getActionText());
            action.getStyleClass().add((Object)"actionButton");
            action.setOnAction(this.getAction());
            action.setLayoutX(197.0);
            action.setLayoutY(603.0);
            BooleanBinding actionEnabled = this.actionEnabledBinding();
            action.setDisable(!actionEnabled.get());
            actionEnabled.addListener((observableValue, oldValue, newValue) -> action.setDisable(newValue == false));
            this.enablePreviousNext.addListener((observableValue, oldVBoolean, newValue) -> {
                next.setDisable(newValue == false);
                previous.setDisable(newValue == false);
            });
            this.getContent().addAll((Object[])new Node[]{footerText, previous, next, action});
        } else {
            Text text = new Text(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.BaseShipyardDialog.noShip", new Object[0], this.locale.getCurrentLocal()));
            text.getStyleClass().add((Object)"dialogText");
            text.setLayoutX(50.0);
            text.setLayoutY(250.0);
            this.getContent().addAll((Object[])new Node[]{text});
        }
    }

    private EventHandler<? super MouseEvent> createHistoryDisplayHandler() {
        return mouseEvent -> {
            ch.sahits.game.openpatrician.util.model.Text historyText = this.getHistoryText(this.getCurrentShipType());
            Insets insets = new Insets(15.0, 15.0, 15.0, 30.0);
            Font headerFont = this.fontLoader.createDefaultFont(24);
            Font defaultFont = this.fontLoader.createDefaultFont(18);
            ArrayList<Node> firstPageContent = new ArrayList<Node>(this.getContent().size());
            for (Node node : this.getContent()) {
                firstPageContent.add(node);
            }
            PaginationV2 pagination = PaginationV2Builder.create().backButtonLabel(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.CreditsScene.back", new Object[0], this.locale.getCurrentLocal())).nextButtonLabel(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.CreditsScene.next", new Object[0], this.locale.getCurrentLocal())).text(historyText).contentMaxWidth(458.0).contentMaxHeight(567.0).padding(insets).navigationLabelFont(defaultFont).headerFont(headerFont).paragraphFont(defaultFont).centeredFont(defaultFont).firstLastPageAction((EventHandler)new ReplaceFirstPage(firstPageContent)).build();
            pagination.setLayoutY(30.0);
            this.replaceContent(new Node[]{pagination});
        };
    }

    private ch.sahits.game.openpatrician.util.model.Text getHistoryText(EShipType type) {
        String resourceName = this.resources.getMessage(this.getHistoryResourceName(type), new Object[0], this.locale.getCurrentLocal());
        URL url = this.getClass().getClassLoader().getResource(resourceName);
        try {
            InputStream is = url.openStream();
            return this.textParser.parse(is);
        }
        catch (IOException e) {
            this.logger.warn("History text could not be found: " + url.toExternalForm());
            return new ch.sahits.game.openpatrician.util.model.Text();
        }
    }

    private String getHistoryResourceName(EShipType type) {
        switch (type) {
            case SNAIKKA: {
                return "history.snaikka";
            }
            case CRAYER: {
                return "history.crayer";
            }
            case COG: {
                return "history.cog";
            }
            case HOLK: {
                return "history.holk";
            }
        }
        throw new IllegalStateException("The ship type " + type + " is not handled.");
    }

    protected RowConstraints getRowConstraints() {
        RowConstraints rowConstraint = new RowConstraints(24.0);
        return rowConstraint;
    }

    protected EventHandler<MouseEvent> createNextAction() {
        return new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (BaseShipyardDialog.this.currentShipTypeIndex.get() == BaseShipyardDialog.this.shipTypes.length - 1) {
                    BaseShipyardDialog.this.currentShipTypeIndex.set(0);
                } else {
                    BaseShipyardDialog.this.currentShipTypeIndex.set(BaseShipyardDialog.this.currentShipTypeIndex.get() + 1);
                }
            }
        };
    }

    protected EventHandler<MouseEvent> createPreviousAction() {
        return new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (BaseShipyardDialog.this.currentShipTypeIndex.get() == 0) {
                    BaseShipyardDialog.this.currentShipTypeIndex.set(BaseShipyardDialog.this.shipTypes.length - 1);
                } else {
                    BaseShipyardDialog.this.currentShipTypeIndex.set(BaseShipyardDialog.this.currentShipTypeIndex.get() - 1);
                }
            }
        };
    }

    protected abstract EventHandler<MouseEvent> getAction();

    protected abstract String getActionText();

    protected abstract Group createFooterText();

    protected abstract Table createMainTable();

    protected abstract Table createTopTable();

    protected abstract BooleanBinding actionEnabledBinding();

    private ObjectBinding<Image> shipSideImageBinding() {
        return new ObjectBinding<Image>(){

            protected Image computeValue() {
                switch (BaseShipyardDialog.this.getCurrentShipType()) {
                    case SNAIKKA: {
                        return BaseShipyardDialog.this.imageLoader.getImage("images/schnikka_side");
                    }
                    case CRAYER: {
                        return BaseShipyardDialog.this.imageLoader.getImage("images/crayer_side");
                    }
                    case COG: {
                        return BaseShipyardDialog.this.imageLoader.getImage("images/cog_side");
                    }
                    case HOLK: {
                        return BaseShipyardDialog.this.imageLoader.getImage("images/holk_side");
                    }
                }
                throw new RuntimeException("Unknown ships type: " + BaseShipyardDialog.this.getCurrentShipType());
            }
        };
    }

    private ObjectBinding<Image> shipFrontImageBinding() {
        return new ObjectBinding<Image>(){

            protected Image computeValue() {
                switch (BaseShipyardDialog.this.getCurrentShipType()) {
                    case SNAIKKA: {
                        return BaseShipyardDialog.this.imageLoader.getImage("images/schnikka_front");
                    }
                    case CRAYER: {
                        return BaseShipyardDialog.this.imageLoader.getImage("images/crayer_front");
                    }
                    case COG: {
                        return BaseShipyardDialog.this.imageLoader.getImage("images/cog_front");
                    }
                    case HOLK: {
                        return BaseShipyardDialog.this.imageLoader.getImage("images/holk_front");
                    }
                }
                throw new RuntimeException("Unknown ships type: " + BaseShipyardDialog.this.getCurrentShipType());
            }
        };
    }

    protected final EShipType getCurrentShipType() {
        return this.shipTypes[this.currentShipTypeIndex.get()];
    }

    public IntegerProperty currentShipTypeIndexProperty() {
        return this.currentShipTypeIndex;
    }

    protected boolean hasShips() {
        return true;
    }

    @Override
    public void executeOnCloseButtonClicked() {
        this.clientEventBus.post((Object)new NoticeBoardClose());
        super.executeOnCloseButtonClicked();
    }

    public ICity getCity() {
        return this.city.getCity();
    }

    public IPlayer getPlayer() {
        return this.city.getPlayer();
    }

    private class ReplaceFirstPage
    implements EventHandler<MouseEvent> {
        private final List<Node> firstPageContent;

        public ReplaceFirstPage(List<Node> firstPageContent) {
            this.firstPageContent = firstPageContent;
        }

        public void handle(MouseEvent mouseEvent) {
            BaseShipyardDialog.this.replaceContent(this.firstPageContent);
        }
    }

    protected class BuyAmountBinding
    extends IntegerBinding {
        private final IntegerProperty stored;
        private final IntegerBinding needed;

        public BuyAmountBinding(IWare ware, IntegerBinding requiredAmount) {
            ITradingOffice office = BaseShipyardDialog.this.getPlayer().findTradingOffice(BaseShipyardDialog.this.getCity());
            this.stored = office.getWare(ware).amountProperty();
            this.needed = requiredAmount;
            super.bind(new Observable[]{this.stored, requiredAmount});
        }

        protected int computeValue() {
            return Math.max(0, this.needed.get() - this.stored.get());
        }
    }

    protected class PriceBinding
    extends IntegerBinding {
        private final IWare ware;
        private final IntegerProperty available;
        private final BuyAmountBinding buyAmount;

        public PriceBinding(IWare ware, BuyAmountBinding buyAmount) {
            this.ware = ware;
            this.available = BaseShipyardDialog.this.getCity().getWare(ware).amountProperty();
            this.buyAmount = buyAmount;
            super.bind(new Observable[]{buyAmount, this.available});
        }

        protected int computeValue() {
            if (this.buyAmount.get() > 0) {
                return this.ware.buyPrice(this.available, (IntegerBinding)this.buyAmount);
            }
            return 0;
        }
    }
}

