/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.tavern;

import ch.sahits.game.event.handler.impl.EventHandlerFactory;
import ch.sahits.game.graphic.display.dialog.tavern.TavernBaseSideRoomPersonDialog;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.people.IFugitive;
import ch.sahits.game.openpatrician.model.people.IPerson;
import ch.sahits.game.openpatrician.model.people.ISideRoomPerson;
import ch.sahits.game.openpatrician.model.ship.IShip;
import java.util.HashMap;
import javafx.beans.binding.BooleanBinding;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernFugativeDialog
extends TavernBaseSideRoomPersonDialog {
    @Autowired
    private EventHandlerFactory eventHandlerFactory;

    public TavernFugativeDialog(ICityPlayerProxyJFX city) {
        super(city, (ISideRoomPerson)city.getCity().getCityState().getTavernState().getFugative());
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernFugitiveDialog.title", new Object[0], this.locale.getCurrentLocal()));
        this.initializeButtons();
        IFugitive fugitive = (IFugitive)this.currentPerson.get();
        DecoratedText text = new DecoratedText();
        text.setLayoutX(30.0);
        text.setLayoutY(100.0);
        text.setWrappingWidth(458);
        String loadedText = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernFugitiveDialog.dialog", new Object[0], this.locale.getCurrentLocal());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("destination", fugitive.getDestination().getName());
        parameters.put("amount", fugitive.getPremium());
        DecoratedText dt = this.decoratedTextFactory.createDecoratedText(loadedText, parameters);
        this.getContent().addAll((Object[])new Node[]{dt});
    }

    @Override
    protected BooleanBinding disableAcceptButton() {
        return new BooleanBinding(){
            {
                if (TavernFugativeDialog.this.city.getActiveShip() instanceof IShip) {
                    ((IShip)TavernFugativeDialog.this.city.getActiveShip()).passengerPresentProperty();
                }
            }

            protected boolean computeValue() {
                return !(TavernFugativeDialog.this.city.getActiveShip() instanceof IShip) || TavernFugativeDialog.this.city.getPlayersShips().isEmpty() || ((IShip)TavernFugativeDialog.this.city.getActiveShip()).passengerPresentProperty().get();
            }
        };
    }

    @Override
    protected EventHandler<MouseEvent> createAcceptHandler() {
        return new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                IShip ship = null;
                if (TavernFugativeDialog.this.city.getActiveShip() instanceof IShip) {
                    ship = (IShip)TavernFugativeDialog.this.city.getActiveShip();
                }
                if (ship != null) {
                    IFugitive fugitive = (IFugitive)TavernFugativeDialog.this.currentPerson.get();
                    ship.addPassenger((IPerson)fugitive);
                    TavernFugativeDialog.this.eventHandlerFactory.getPassengerLeavingOnShipArrivalHandler(ship, fugitive.getDestination(), (IPlayer)TavernFugativeDialog.this.city.getPlayer(), fugitive.getPremium());
                    TavernFugativeDialog.this.clientEventBus.post((Object)new DisplayMessage("ch.sahits.game.graphic.display.dialog.TavernFugitiveDialog.acceptMessage", new Object[]{ship.getName()}));
                    fugitive.leave();
                    TavernFugativeDialog.this.executeOnCloseButtonClicked();
                }
            }
        };
    }
}

