/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.util;

import ch.sahits.game.event.EGameStatusChange;
import ch.sahits.game.event.GameStateChange;
import ch.sahits.game.event.data.MapUpdateCityAdd;
import ch.sahits.game.event.data.PauseGame;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.LazySingleton;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.PlayerList;
import ch.sahits.game.openpatrician.model.event.TargetedEvent;
import ch.sahits.game.openpatrician.persistence.LoadAndSaveService;
import ch.sahits.game.openpatrician.util.LocalStorage;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;

@LazySingleton
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class GameOptionsService {
    private static final String SAVEGAME_FILE_EXTENSTION = ".ops";
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private LoadAndSaveService loadAndSave;
    private File savegameDir;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @Qualifier(value="timerEventBus")
    private AsyncEventBus timerEventBus;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private LocalStorage localStorage;

    @PostConstruct
    private void init() {
        this.savegameDir = this.localStorage.getSavegameDirectory();
    }

    public List<String> getGameSpeedList() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.NewGameScene.break", new Object[0], this.locale.getCurrentLocal()));
        l.add(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.NewGameScene.slow", new Object[0], this.locale.getCurrentLocal()));
        l.add(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.NewGameScene.normal", new Object[0], this.locale.getCurrentLocal()));
        l.add(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.NewGameScene.fast", new Object[0], this.locale.getCurrentLocal()));
        return l;
    }

    public Map<String, String> getSavegames() {
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(GameOptionsService.SAVEGAME_FILE_EXTENSTION);
            }
        };
        String[] savegames = this.savegameDir.list(filter);
        HashMap<String, String> map = new HashMap<String, String>();
        for (String savegame : savegames) {
            String savegameName = savegame.substring(0, savegame.indexOf(46));
            map.put(savegameName, savegameName);
        }
        return map;
    }

    public void save(String savegameName) {
        String fileName = this.savegameDir + File.separator + savegameName + SAVEGAME_FILE_EXTENSTION;
        this.loadAndSave.serialize(fileName);
    }

    public void load(String savegameName) {
        this.timerEventBus.post((Object)new PauseGame());
        Thread.yield();
        String fileName = this.savegameDir + File.separator + savegameName + SAVEGAME_FILE_EXTENSTION;
        this.loadAndSave.restore(fileName);
        this.clientServerEventBus.post((Object)new GameStateChange(EGameStatusChange.GAME_LOADED));
        PlayerList players = (PlayerList)this.context.getBean(PlayerList.class);
        for (IPlayer player : players) {
            if (!(player instanceof IHumanPlayer)) continue;
            this.clientServerEventBus.post((Object)new TargetedEvent((IHumanPlayer)player, (Object)new MapUpdateCityAdd(null, player)));
        }
    }
}

