/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.javafx.display;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.NavigationStateChange;
import ch.sahits.game.event.NoticeBoardClose;
import ch.sahits.game.event.data.ENavigationStateChange;
import ch.sahits.game.graphic.display.gameplay.internal.EScene;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.graphic.javafx.display.IDialogContoller;
import ch.sahits.game.graphic.javafx.display.ISceneEventHandler;
import ch.sahits.game.javafx.model.EDialogType;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ObjectPropertyType;
import ch.sahits.game.openpatrician.sound.IPlayableTrack;
import ch.sahits.game.openpatrician.sound.ITrackLoader;
import ch.sahits.game.openpatrician.sound.ITrackPlayer;
import ch.sahits.game.openpatrician.util.StartNewGameBean;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import java.util.Timer;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
@ClassCategory(value={EClassCategory.HANDLER})
public class ChurchSceneEventHandler
implements ISceneEventHandler {
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    @Autowired
    @Qualifier(value="uiTimer")
    private Timer timer;
    @Autowired
    private ITrackLoader trackLoader;
    @Autowired
    private ITrackPlayer soundPlayer;
    @ObjectPropertyType(value=EScene.class)
    private ObjectProperty<EScene> currentScene = new SimpleObjectProperty((Object)this, "currentScene", (Object)EScene.PORT);
    private IDialogContoller dialogContoller;
    private boolean navigationDisabled = false;

    @PostConstruct
    private void initialize() {
        IPlayableTrack backgroundSound = this.trackLoader.loadTrack("organ");
        this.currentScene.addListener((observable, oldScene, newScene) -> {
            if (newScene == EScene.CHURCH) {
                this.soundPlayer.add(backgroundSound);
                this.soundPlayer.play();
            } else {
                this.soundPlayer.stop();
                this.soundPlayer.clearPlayList();
            }
        });
    }

    @Override
    public ObjectProperty<EScene> currentSceneProperty() {
        return this.currentScene;
    }

    @Override
    public void setDialogContoller(IDialogContoller dialogContoller) {
        this.dialogContoller = dialogContoller;
    }

    @Override
    public void handleEvent(Object eventNotice) {
        ViewChangeCityPlayerProxyJFX cityProxy;
        Preconditions.checkNotNull((Object)this.dialogContoller, (Object)"Dialog controller must be initialized first");
        if (eventNotice instanceof ViewChangeCityPlayerProxyJFX && (cityProxy = (ViewChangeCityPlayerProxyJFX)eventNotice).getViewChangeEvent() == EViewChangeEvent.MAIN_VIEW_MARKET && !this.navigationDisabled) {
            this.clientEventBus.post((Object)new NoticeBoardClose());
            this.currentScene.set((Object)EScene.MARKET);
            this.dialogContoller.changeScene();
        }
        if (eventNotice instanceof EDialogType) {
            if (eventNotice == EDialogType.CHURCH_PRAY) {
                this.pray();
            } else {
                this.dialogContoller.replaceDialog((EDialogType)eventNotice, new Object[0]);
            }
        }
    }

    private void pray() {
        this.dialogContoller.closeDialog();
        NavigationStateChange changeEvent = new NavigationStateChange(ENavigationStateChange.DISABLE_NAVIGATION);
        this.clientEventBus.post((Object)changeEvent);
        this.navigationDisabled = true;
        final IPlayableTrack track = this.trackLoader.loadTrack("pater-noster");
        double length = track.getLength();
        long lengthMS = (long)(length * 1000.0);
        this.soundPlayer.stop();
        track.play();
        ChangeListener<Boolean> playingChangeListener = new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                System.out.println("Enable navigation now: " + System.currentTimeMillis());
                NavigationStateChange changeBackEvent = new NavigationStateChange(ENavigationStateChange.ENABLE_NAVIGATION);
                ChurchSceneEventHandler.this.clientEventBus.post((Object)changeBackEvent);
                ChurchSceneEventHandler.this.soundPlayer.play();
                ChurchSceneEventHandler.this.navigationDisabled = false;
                track.playingProperty().removeListener((ChangeListener)this);
            }
        };
        track.playingProperty().addListener((ChangeListener)playingChangeListener);
    }
}

