/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.javafx.display;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.graphic.display.gameplay.internal.EScene;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.graphic.javafx.display.IDialogContoller;
import ch.sahits.game.graphic.javafx.display.ISceneEventHandler;
import ch.sahits.game.javafx.model.EDialogType;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ObjectPropertyType;
import ch.sahits.game.openpatrician.util.StartNewGameBean;
import com.google.common.base.Preconditions;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
@Lazy
@DependentInitialisation(value=StartNewGameBean.class)
@ClassCategory(value={EClassCategory.HANDLER})
public class MarketSceneEventHandler
implements ISceneEventHandler {
    @ObjectPropertyType(value=EScene.class)
    private ObjectProperty<EScene> currentScene = new SimpleObjectProperty((Object)this, "currentScene", (Object)EScene.PORT);
    private IDialogContoller dialogContoller;

    @Override
    public ObjectProperty<EScene> currentSceneProperty() {
        return this.currentScene;
    }

    @Override
    public void setDialogContoller(IDialogContoller dialogContoller) {
        this.dialogContoller = dialogContoller;
    }

    @Override
    public void handleEvent(Object eventNotice) {
        Preconditions.checkNotNull((Object)this.dialogContoller, (Object)"Dialog controller must be initialized first");
        if (eventNotice instanceof ViewChangeCityPlayerProxyJFX) {
            ViewChangeCityPlayerProxyJFX cityProxy = (ViewChangeCityPlayerProxyJFX)eventNotice;
            if (cityProxy.getViewChangeEvent() == EViewChangeEvent.NOTICE_MARKET_BOOTH) {
                this.dialogContoller.setNewDialog(EDialogType.MB_STOCK_PRICES, new Object[0]);
            }
            if (cityProxy.getViewChangeEvent() == EViewChangeEvent.MAIN_VIEW_PORT) {
                this.currentScene.set((Object)EScene.PORT);
                this.dialogContoller.changeScene();
            }
            if (cityProxy.getViewChangeEvent() == EViewChangeEvent.MAIN_VIEW_CITY_HALL) {
                this.currentScene.set((Object)EScene.CITY_HALL);
                this.dialogContoller.changeScene();
            }
            if (cityProxy.getViewChangeEvent() == EViewChangeEvent.MAIN_VIEW_CHURCH) {
                this.currentScene.set((Object)EScene.CHURCH);
                this.dialogContoller.changeScene();
            }
        }
        if (eventNotice instanceof EDialogType) {
            this.dialogContoller.replaceDialog((EDialogType)eventNotice, new Object[0]);
        }
    }
}

