package ch.sahits.game.event.handler;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import org.joda.time.DateTime;
/**
 * This timed task serves as notice, in the case that the player does not
 * pay his debt before the deadline. In that case something will be impounded.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Feb 23, 2013
 *
 */
@ClassCategory(EClassCategory.DEPENDS_ON_SERIALIZED_BEAN)
public class LoanerRepayDeptByPlayer extends TimedTask {  // fixme: andi 8/3/15: this should be a bean that is serialized
	private final IPlayer player;
	// Need additional information city or loaner object

	public LoanerRepayDeptByPlayer(DateTime executionTime, IPlayer debitor) {
		super();
        setExecutionTime(executionTime);
		player = debitor;
	}

	@Override
	public void run() {

	}

}
