package ch.sahits.game.graphic.display;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.EShipUpgrade;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.ship.ShipFactory;
import ch.sahits.game.openpatrician.model.weapon.EWeapon;
import javafx.event.EventHandler;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import lombok.Setter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationContext;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Feb 02, 2016
 */
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class CheatKeyEventListener implements EventHandler<KeyEvent> {
    private final Logger logger = LogManager.getLogger(getClass());
    @Setter
    private ClientViewState viewState;
    @Setter
    private ApplicationContext context;

    private boolean cheatModeActive = false;
    @Override
    public void handle(KeyEvent event) {
        if (event.getCode().equals(KeyCode.F10)) {
            cheatModeActive = !cheatModeActive;
            logger.debug("Toggle cheatmode. Cheat active: {}", cheatModeActive);
        } else {
            if (cheatModeActive && event.isControlDown()) {
                 if (event.getCode().equals(KeyCode.S)) {
                     // create a ship
                     IHumanPlayer player = viewState.getPlayer();
                     ICity city = viewState.getCurrentCityProxy().get().getCity();
                     ShipFactory shipFactory = context.getBean(ShipFactory.class);
                     IShip ship = shipFactory.createCrayer("Cheat ship name", EShipUpgrade.LEVEL1, 350);
                     player.addShip(ship);
                     player.addSelectableVessel(ship);
                     ship.setOwner(player);
                     ship.setLocation(city.getCoordinates());
                     viewState.getCurrentCityProxy().get().arrive(ship);
                     logger.debug("Cheat created a new ship in "+city.getName());
                 }
                if (event.getCode().equals(KeyCode.W)) {
                    // add weapons to active ship
                    INavigableVessel vessel = viewState.getCurrentCityProxy().get().getActiveShip();
                    if (vessel instanceof IShip) {
                        IShip ship = (IShip) vessel;
                        ship.move(EWeapon.CANNON, 1);
                        logger.debug("Cheated one cannon onto the active ship: "+ship.getName());
                    }
                }
            }
        }
    }
}
