package ch.sahits.game.graphic.display.dialog.tavern;

import ch.sahits.game.event.data.CourierPatrolStateInternal;
import ch.sahits.game.event.handler.impl.EventHandlerFactory;
import ch.sahits.game.graphic.event.task.ClientTaskFactory;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.people.ICourier;
import ch.sahits.game.openpatrician.model.ship.IShip;
import javafx.beans.binding.BooleanBinding;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.PostConstruct;
import java.util.HashMap;
import java.util.Random;

/**
 * Dialog for accepting the packages of a courier.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 *         Created on Dec 23, 2013
 */
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernCourierDialog extends TavernBaseSideRoomPersonDialog {
    private static final int AMOUNT = 3;
    @Autowired
    private Random rnd;
    @Autowired
    private EventHandlerFactory eventHandlerFactory;
    @Autowired
    private ClientTaskFactory taskFactory;


    public TavernCourierDialog(ICityPlayerProxyJFX city) {
        super(city, city.getCity().getCityState().getTavernState().getCourier());
    }
    @PostConstruct
    private void initializeDialog(){
        setTitle( messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernCourierDialog.title", new Object[]{}, locale.getCurrentLocal()));
        initializeButtons();

        String loadedText = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernCourierDialog.dialog", new Object[0], locale.getCurrentLocal());

        HashMap<String, Object> parameters = new HashMap<>();
        parameters.put("city", city.getCity().getName());
        parameters.put("amount", AMOUNT);
        DecoratedText dt = decoratedTextFactory.createDecoratedText(loadedText, parameters);

        getContent().add(dt);

    }

    @Override
    protected EventHandler<MouseEvent> createAcceptHandler() {
        return mouseEvent -> {
            if (!tavernDialogUtil.noShipWithEnoughCapacityAvailable(city, AMOUNT)) {
                for (IShip ship : city.getPlayersShips()) {
                    if (ship.getCapacity() >= AMOUNT*10) {
                        final ICourier courier = (ICourier) currentPerson.get();
                        ship.addPassenger(courier);
                        CourierPatrolStateInternal patrolState = new CourierPatrolStateInternal(courier.getPremium(), courier.getDestinations());
                        IPlayer player = city.getPlayer();
                        int minutes = rnd.nextInt(600);
                        DateTime postMessage = date.getCurrentDate().plusMinutes(minutes);
                        String cityName = patrolState.nextDestination().get().getName();
                        taskFactory.getPostponedDisplayMessage(postMessage, "ch.sahits.game.graphic.display.dialog.TavernPatrolDialog.acceptMessage", new Object[]{ship.getName(), cityName});
                        DateTime firstDeadline = date.getCurrentDate().plusDays(6);
                        eventHandlerFactory.getNextCourierPatrolStationHanlder(ship, patrolState.nextDestination().get(), patrolState, player, firstDeadline);
                        courier.leave();
                        executeOnCloseButtonClicked();
                        break;
                    }
                }
            }
        };
    }

    @Override
    protected BooleanBinding disableAcceptButton() {
        return new BooleanBinding() {
            {
                super.bind(city.getPlayersShips());
                if (city.getActiveShip() instanceof IShip) {
                    ((IShip)city.getActiveShip()).passengerPresentProperty();
                }
            }
            @Override
            protected boolean computeValue() {
                return !(city.getActiveShip() instanceof IShip) || tavernDialogUtil.noShipWithEnoughCapacityAvailable(city, AMOUNT) || ((IShip)city.getActiveShip()).passengerPresentProperty().get();
            }
        };
    }

}
