package ch.sahits.game.graphic.display.dialog.tavern;

import ch.sahits.game.event.handler.impl.EventHandlerFactory;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.dialog.Dialog;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.people.IFugitive;
import ch.sahits.game.openpatrician.model.ship.IShip;
import javafx.beans.binding.BooleanBinding;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.PostConstruct;
import java.util.HashMap;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 *         Created on Dec 28, 2013
 */
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernFugativeDialog extends TavernBaseSideRoomPersonDialog {
    @Autowired
    private EventHandlerFactory eventHandlerFactory;


    public TavernFugativeDialog(ICityPlayerProxyJFX city) {
        super(city, city.getCity().getCityState().getTavernState().getFugative());
    }
    @PostConstruct
    private void initializeDialog() {
        setTitle(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernFugitiveDialog.title", new Object[]{}, locale.getCurrentLocal()));
        initializeButtons();
        IFugitive fugitive = (IFugitive) currentPerson.get();
        DecoratedText text = new DecoratedText();
        text.setLayoutX(2 * Dialog.FRAME_BORDER);
        text.setLayoutY(100);
        text.setWrappingWidth(Dialog.WRAPPING_WIDTH);

        String loadedText = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernFugitiveDialog.dialog", new Object[0], locale.getCurrentLocal());

        HashMap<String, Object> parameters = new HashMap<>();
        parameters.put("destination", fugitive.getDestination().getName());
        parameters.put("amount", fugitive.getPremium());
        DecoratedText dt = decoratedTextFactory.createDecoratedText(loadedText, parameters);

        getContent().addAll(dt);
    }

    @Override
    protected BooleanBinding disableAcceptButton() {
        return new BooleanBinding() {
            {
                super.bind(city.getPlayersShips());
                if (city.getActiveShip() instanceof IShip) {
                    ((IShip)city.getActiveShip()).passengerPresentProperty();
                }
            }
            @Override
            protected boolean computeValue() {
                return !(city.getActiveShip() instanceof IShip) || city.getPlayersShips().isEmpty() || ((IShip)city.getActiveShip()).passengerPresentProperty().get();
            }
        };
    }

    @Override
    protected EventHandler<MouseEvent> createAcceptHandler() {
        return new EventHandler<MouseEvent>() {
            @Override
            public void handle(MouseEvent mouseEvent) {
                IShip ship = null;
                if (city.getActiveShip() instanceof IShip) {
                    ship = (IShip) city.getActiveShip();
                }
                if (ship!=null) {
                    IFugitive fugitive = (IFugitive) currentPerson.get();
                    ship.addPassenger(fugitive);
                    eventHandlerFactory.getPassengerLeavingOnShipArrivalHandler(ship, fugitive.getDestination(), city.getPlayer(), fugitive.getPremium());
                    clientEventBus.post(new DisplayMessage("ch.sahits.game.graphic.display.dialog.TavernFugitiveDialog.acceptMessage", new Object[]{ship.getName()}));
                    fugitive.leave();
                    executeOnCloseButtonClicked();
                }
            }
        };
    }
}
