package ch.sahits.game.graphic.display.dialog.util;

import ch.sahits.game.javafx.model.EDialogType;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.ETransferAmount;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;

/**
 * This interfaces defines methods that are accessed by the Transfer actions
 * @author Andi Hotz, (c) Sahits GmbH, 2011
 * Created on Dec 11, 2011
 *
 */
public interface ITransferableJFX {


	/**
	 * Retrieve the vessel associated.
	 * @return
     */
	INavigableVessel getVessel();

	/**
	 * Retrieve the city.
	 * @return
     */
	ICity getCity();

	/**
	 * Retrieve the player.
	 * @return
     */
	IPlayer getPlayer();
	/**
	 * Retrieve the dialog type of this transfer
	 * @return transfer dialog type
	 */
	EDialogType getDialogType();
	/**
	 * Retrieve the amount that should be transferred.
	 * @param availableAmountCity
	 * @return
	 */
	int getAmount(int availableAmountCity);
	/**
	 * Retreive the amount category that is movable
	 * @return
	 */
	ETransferAmount getMovableAmount();

}
