package ch.sahits.game.graphic.display.gameplay.internal;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.NoticeBoardUpdate;
import ch.sahits.game.event.ViewChangeEvent;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.graphic.javafx.display.MainGameView;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.util.StartNewGameBean;
import com.google.common.eventbus.AsyncEventBus;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 *         Created on Dec 13, 2013
 */
@Component
@Lazy
@DependentInitialisation(StartNewGameBean.class)
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class MarketScenePolygonInitializer extends ScenePolygonInitialzer {
    @Autowired
    private ClientViewState viewState;
    @Autowired
    @Qualifier("clientEventBus")
    private AsyncEventBus clientEventBus;

    public MarketScenePolygonInitializer() {
        super("images/scene/marketPlaceScene");
    }

    @Override
    protected EventHandler<MouseEvent> createEventHandler(String name) {
        switch (name) {
            case "MarketBooth": {
                return new EventHandler<MouseEvent>() {

                    @Override
                    public void handle(MouseEvent arg0) {
                        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.NOTICE_MARKET_BOOTH);
                        clientEventBus.post(new NoticeBoardUpdate(proxy));
                        clientEventBus.post(new ViewChangeEvent(MainGameView.class, proxy));
                    }
                };
            }
            case "Floor" : {
                return new EventHandler<MouseEvent>() {

                    @Override
                    public void handle(MouseEvent arg0) {
                        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.MAIN_VIEW_PORT);
                        clientEventBus.post(new ViewChangeEvent(MainGameView.class, proxy));
                        proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.NOTICE_HIDE);
                        clientEventBus.post(new NoticeBoardUpdate(proxy));
                    }
                };
            }
            case "CityHall" : {
                return new EventHandler<MouseEvent>() {

                    @Override
                    public void handle(MouseEvent arg0) {
                        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.MAIN_VIEW_CITY_HALL);
                        clientEventBus.post(new ViewChangeEvent(MainGameView.class, proxy));
                        proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.NOTICE_HIDE);
                        clientEventBus.post(new NoticeBoardUpdate(proxy));
                    }
                };

            }
            case "Church" : {
                return mouseEvent -> {
                    ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.MAIN_VIEW_CHURCH);
                    clientEventBus.post(new ViewChangeEvent(MainGameView.class, proxy));
                    clientEventBus.post(new NoticeBoardUpdate(proxy));
                };
            }
            default:
                throw new IllegalStateException("Unhandled polygon action: "+name);
        }

    }
}
