package ch.sahits.game.graphic.event.task;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.people.IBuyer;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.util.ModelTranslations;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

import java.util.List;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Feb 23, 2014
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
class BuyWares extends TimedTask {

    private final IPlayer player;
    private final ICity city;
    private final AmountablePrice<IWare> amountable;
    private final IWare ware;
    @Autowired
    @Qualifier("clientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientEventBus;
    @Autowired
    @XStreamOmitField
    private Locale locale;
    @Autowired
    @XStreamOmitField
    private ModelTranslations translator;
    @Autowired
    @XStreamOmitField
    @Qualifier("messageSource")
    private MessageSource messageSource;

    public BuyWares(ICityPlayerProxyJFX cityPlayerProxy, IBuyer buyer) {
        super();
        setExecutionTime(buyer.getTimeFrame());
        player = cityPlayerProxy.getPlayer();
        city = cityPlayerProxy.getCity();
        amountable = buyer.getAmountablePrice();
        ware = buyer.getWare();
    }

    @Override
    public void run() {
        ITradingOffice tradingOffice = player.findTradingOffice(city);
        int amountRequired = amountable.getAmount();
        int retrieved = 0;
        if (tradingOffice != null) {
            AmountablePrice<IWare> amountable = tradingOffice.getWare(ware);
            if (amountable.getAmount()>0) {
                retrieved = tradingOffice.move(ware, -amountRequired);
                player.getCompany().updateCash(amountable.getAVGPrice() * retrieved);
            }
        }
        if (retrieved<amountRequired) {
            List<INavigableVessel> ships = player.findShips(city);
            for (INavigableVessel ship : ships) {
                if (ship instanceof IShip) {
                    AmountablePrice<IWare> amountable = ship.getWare(ware);
                    if (amountable.getAmount() > 0) {
                        int toRetrieve = amountRequired - retrieved;
                        retrieved += tradingOffice.move(ware, -toRetrieve);
                        player.getCompany().updateCash(amountable.getAVGPrice() * retrieved);
                        if (retrieved >= amountRequired) {
                            break;
                        }
                    }
                }
            }
        }
        if (retrieved<amountRequired) {
            DisplayMessage msg;
            if (retrieved == 0) {

                msg = new DisplayMessage("ch.sahits.game.graphic.event.task.BuyWares.message1", new Object[]{ ware, city.getName()});
            } else {

                msg = new DisplayMessage("ch.sahits.game.graphic.event.task.BuyWares.message2", new Object[]{retrieved,  ware, amountable.getAmount(), city.getName()});
            }
            clientEventBus.post(msg);
        }

    }}
