package ch.sahits.game.graphic.event.task;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

import javax.annotation.PostConstruct;
import java.util.Random;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Feb 23, 2014
 */
@Prototype
@ClassCategory({EClassCategory.DEPENDS_ON_SERIALIZED_BEAN, EClassCategory.PROTOTYPE_BEAN})
class DelayedCaughtAction extends TimedTask implements IDelayedCaughtAction {
    private final IPlayer player;
    @Autowired
    private Date date;
    @Autowired
    @XStreamOmitField
    private Random rnd;
    @Autowired
    @Qualifier("clientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientEventBus;
    @Autowired
    @XStreamOmitField
    private Locale locale;

    @Autowired
    @XStreamOmitField
    @Qualifier("messageSource")
    private MessageSource messageSource;
    public DelayedCaughtAction(IPlayer player) {
        super();
        this.player = player;
    }
    @PostConstruct
    private void initialize() {
        setExecutionTime(date.getCurrentDate().plusDays(5));
    }

    @Override
    public void run() {
        int penalty = (int)(Math.abs(player.getCash()/200*rnd.nextDouble()));
        DisplayMessage msg = new DisplayMessage("ch.sahits.game.graphic.event.task.DelayedCaughtAction.message", new Object[]{penalty});
        clientEventBus.post(msg);
        player.updateCash(-penalty);
    }
}
