package ch.sahits.game.graphic.event.task;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.dialog.DialogTemplate;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

import javax.annotation.PostConstruct;

/**
 * Post a display message in the form of a dialog template, but postpone it.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Apr 06, 2015
 */
@Prototype
@ClassCategory({EClassCategory.DEPENDS_ON_SERIALIZED_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class PostponedDisplayDialogMessage extends TimedTask {
    private final DialogTemplate template;
    @Autowired
    private TimedUpdatableTaskList taskList;
    @Autowired
    @Qualifier("clientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientEventBus;
    @Autowired
    @XStreamOmitField
    private Locale locale;
    @Autowired
    @XStreamOmitField
    @Qualifier("messageSource")
    private MessageSource messageSource;


    public PostponedDisplayDialogMessage(DateTime executionTime, DialogTemplate template) {
        super();
        setExecutionTime(executionTime);
        this.template = template;
    }
    @PostConstruct
    private void initialize() {
        taskList.add(this);
    }


    @Override
    public void run() {

        DisplayMessage msg = new DisplayMessage(template.getTitleKey(), template, template.getMessageArgs());
        clientEventBus.post(msg);
    }
}
