/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.event.data;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ListType;
import ch.sahits.game.openpatrician.model.city.ICity;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;

@ClassCategory(value={EClassCategory.DEPENDS_ON_SERIALIZED_BEAN})
public class PatrolInternalState {
    private final int premium;
    private final int bonusPerAttack;
    private int numberOfAttacks = 0;
    @ListType(value=ICity.class)
    private List<ICity> cities = Lists.newArrayList();

    public PatrolInternalState(int premium, int bonusPerAttack, ICity[] destinations) {
        this.premium = premium;
        this.cities = Lists.newArrayList((Object[])destinations);
        this.bonusPerAttack = bonusPerAttack;
    }

    public int getPremium() {
        return this.premium;
    }

    public int getBonusPerAttack() {
        return this.bonusPerAttack;
    }

    public int getNumberOfAttacks() {
        return this.numberOfAttacks;
    }

    public void incAttackCounter() {
        ++this.numberOfAttacks;
    }

    public void removeFirstCity() {
        this.cities.remove(0);
    }

    public Optional<ICity> nextDestination() {
        if (this.cities.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.cities.get(0));
    }
}

