/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.action;

import ch.sahits.game.graphic.display.dialog.util.ITransferableJFX;
import ch.sahits.game.javafx.bindings.ConstantIntegerBinding;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.product.ETransferAmount;
import ch.sahits.game.openpatrician.model.product.IWare;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;

@ClassCategory(value={EClassCategory.HANDLER})
class Storage2CityJFXAction
implements Runnable {
    private final IWare ware;
    private final ITransferableJFX transfer;

    public Storage2CityJFXAction(IWare ware, ITransferableJFX transfer) {
        this.ware = ware;
        this.transfer = transfer;
    }

    @Override
    public void run() {
        int amountInStorage;
        ITradingOffice office = this.transfer.getPlayer().findTradingOffice(this.transfer.getCity());
        if (office != null && (amountInStorage = office.getWare(this.ware).getAmount()) > 0) {
            int availableAmountCity = this.transfer.getCity().getWare(this.ware).getAmount();
            int amount2Move = this.transfer.getAmount(amountInStorage);
            int avgPrice = this.transfer.getMovableAmount() == ETransferAmount.MAX ? this.ware.getMaxValueSell() : this.ware.sellPrice((IntegerProperty)new SimpleIntegerProperty(availableAmountCity), (IntegerBinding)new ConstantIntegerBinding(amount2Move));
            this.transfer.getCity().move(this.ware, amount2Move, (ICitizen)this.transfer.getPlayer());
            int sold = office.move(this.ware, -amount2Move);
            this.transfer.getPlayer().updateCash(avgPrice * sold);
        }
    }
}

