/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.shipyard;

import ch.sahits.game.event.data.ShipyardOrderBuild;
import ch.sahits.game.graphic.display.dialog.shipyard.BaseShipyardDialog;
import ch.sahits.game.javafx.control.BaleAmountAlwaysVisible;
import ch.sahits.game.javafx.control.BarrelAmount;
import ch.sahits.game.javafx.control.BarrelAmountAlwaysVisible;
import ch.sahits.game.javafx.control.CoinPriceAlwaysVisible;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.model.ControlTableCell;
import ch.sahits.game.javafx.model.ECellConstraint;
import ch.sahits.game.javafx.model.ITableCell;
import ch.sahits.game.javafx.model.StaticTextTableCell;
import ch.sahits.game.javafx.model.Table;
import ch.sahits.game.javafx.model.TableHeader;
import ch.sahits.game.javafx.model.TableRow;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.MapType;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.EShipUpgrade;
import ch.sahits.game.openpatrician.model.ship.IShipWeaponsLocation;
import ch.sahits.game.openpatrician.model.ship.ShipFactory;
import ch.sahits.game.openpatrician.model.ship.impl.ShipWeaponsLocationFactory;
import ch.sahits.game.openpatrician.model.util.ModelTranslations;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import java.util.HashMap;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.IntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="shipyardConstructionDialog")
@Scope(value="prototype")
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.SINGLETON_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class ShipyardConstructionDialogV2
extends BaseShipyardDialog {
    @Autowired
    private ShipFactory shipFactory;
    @Autowired
    private ShipWeaponsLocationFactory weaponsLocationFactory;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    private Locale locale;
    @Autowired
    private ModelTranslations translator;
    @Autowired
    private MessageSource messageSource;
    private static final EWare[] MATERIALS = new EWare[]{EWare.WOOD, EWare.CLOTH, EWare.IRON, EWare.HEMP, EWare.PITCH};
    @MapType(key=IWare.class, value=IntegerProperty.class)
    private HashMap<IWare, IntegerProperty> availableMap = new HashMap();
    @MapType(key=IWare.class, value=IntegerBinding.class)
    private HashMap<IWare, IntegerBinding> priceMap = new HashMap();
    @MapType(key=IWare.class, value=BaseShipyardDialog.BuyAmountBinding.class)
    private HashMap<IWare, BaseShipyardDialog.BuyAmountBinding> buyAmountMap = new HashMap();

    public ShipyardConstructionDialogV2(ICityPlayerProxyJFX city) {
        super(city);
    }

    @PostConstruct
    private void init() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.ShipyardConstructionDialogV2.title", new Object[0], this.locale.getCurrentLocal()));
    }

    @Override
    protected EventHandler<MouseEvent> getAction() {
        return new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                ICity city = ShipyardConstructionDialogV2.this.getCity();
                ITradingOffice office = ShipyardConstructionDialogV2.this.getPlayer().findTradingOffice(ShipyardConstructionDialogV2.this.getCity());
                for (EWare ware : MATERIALS) {
                    int buyAmount = ((BaseShipyardDialog.BuyAmountBinding)((Object)ShipyardConstructionDialogV2.this.buyAmountMap.get(ware))).get();
                    city.move((IWare)ware, -buyAmount, (ICitizen)ShipyardConstructionDialogV2.this.getPlayer());
                    int needed = ShipyardConstructionDialogV2.this.shipFactory.getConstructionAmount(ShipyardConstructionDialogV2.this.getCurrentShipType(), ware);
                    int fromWarhouse = needed - buyAmount;
                    office.move((IWare)ware, -fromWarhouse);
                }
                ShipyardOrderBuild event = new ShipyardOrderBuild(city.getCityState().getShipyardState(), ShipyardConstructionDialogV2.this.getCurrentShipType(), ShipyardConstructionDialogV2.this.getPlayer());
                ShipyardConstructionDialogV2.this.clientServerEventBus.post((Object)event);
                ShipyardConstructionDialogV2.this.getPlayer().getCompany().updateCash((long)(-ShipyardConstructionDialogV2.this.calculateTotalBuildCosts()));
                ShipyardConstructionDialogV2.this.executeOnCloseButtonClicked();
            }
        };
    }

    @Override
    protected String getActionText() {
        return this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.ShipyardConstructionDialogV2.build", new Object[0], this.locale.getCurrentLocal());
    }

    @Override
    protected Group createFooterText() {
        IntegerBinding totalPriceBinding = new IntegerBinding(){
            {
                for (EWare ware : MATERIALS) {
                    super.bind(new Observable[]{ShipyardConstructionDialogV2.this.getPriceBinding((IWare)ware, null)});
                }
            }

            protected int computeValue() {
                return ShipyardConstructionDialogV2.this.calculateTotalBuildCosts();
            }
        };
        Group g = new Group();
        String t = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.ShipyardConstructionDialogV2.totalSum", new Object[0], this.locale.getCurrentLocal());
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("price", totalPriceBinding.get());
        DecoratedText dt = this.decoratedTextFactory.createDecoratedText(t, parameters);
        g.getChildren().add((Object)dt);
        return g;
    }

    private int calculateTotalBuildCosts() {
        int total = this.getCity().getCityState().getShipyardState().calculateConstructionCosts(this.getCurrentShipType());
        for (EWare ware : MATERIALS) {
            total += this.getPriceBinding((IWare)ware, null).get();
        }
        return total;
    }

    @Override
    protected Table createMainTable() {
        Table model = new Table();
        TableHeader header = new TableHeader(5);
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.ShipyardConstructionDialogV2.materials", new Object[0], this.locale.getCurrentLocal())), ECellConstraint.COLSPAN2);
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.ShipyardConstructionDialogV2.stored", new Object[0], this.locale.getCurrentLocal())));
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.ShipyardConstructionDialogV2.buy", new Object[0], this.locale.getCurrentLocal())));
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.ShipyardConstructionDialogV2.costs", new Object[0], this.locale.getCurrentLocal())));
        header.setAligenment(0, HPos.CENTER);
        header.setAligenment(2, HPos.CENTER);
        header.setAligenment(3, HPos.CENTER);
        header.setAligenment(4, HPos.CENTER);
        model.setHeader(header);
        model.setAligenment(0, HPos.RIGHT);
        model.setAligenment(1, HPos.RIGHT);
        model.setAligenment(2, HPos.RIGHT);
        model.setAligenment(3, HPos.RIGHT);
        model.setAligenment(4, HPos.RIGHT);
        model.setColumnWidth(new Integer[]{70, 70, 70, 70, 100});
        for (EWare ware : MATERIALS) {
            TableRow row = new TableRow();
            row.add((ITableCell)new StaticTextTableCell(this.translator.getLocalDisplayName(ware)));
            IntegerBinding needed = this.getNeededWareBinding(ware);
            if (ware.isBarrelSizedWare()) {
                BarrelAmountAlwaysVisible barrelAmount = new BarrelAmountAlwaysVisible();
                barrelAmount.amountProperty().bind((ObservableValue)needed.asString());
                row.add((ITableCell)new ControlTableCell((Node)barrelAmount));
            } else {
                BaleAmountAlwaysVisible baleAmount = new BaleAmountAlwaysVisible();
                baleAmount.amountProperty().bind((ObservableValue)needed.asString());
                row.add((ITableCell)new ControlTableCell((Node)baleAmount));
            }
            IntegerProperty stored = this.getStoredAmount((IWare)ware);
            if (ware.isBarrelSizedWare()) {
                BarrelAmountAlwaysVisible barrelAmount = new BarrelAmountAlwaysVisible();
                barrelAmount.amountProperty().bind((ObservableValue)stored.asString());
                row.add((ITableCell)new ControlTableCell((Node)barrelAmount));
            } else {
                BaleAmountAlwaysVisible baleAmount = new BaleAmountAlwaysVisible();
                baleAmount.amountProperty().bind((ObservableValue)stored.asString());
                row.add((ITableCell)new ControlTableCell((Node)baleAmount));
            }
            BaseShipyardDialog.BuyAmountBinding buyAmount = new BaseShipyardDialog.BuyAmountBinding(this, (IWare)ware, needed);
            this.buyAmountMap.put((IWare)ware, buyAmount);
            if (ware.isBarrelSizedWare()) {
                BarrelAmountAlwaysVisible barrelAmount = new BarrelAmountAlwaysVisible();
                barrelAmount.amountProperty().bind((ObservableValue)buyAmount.asString());
                row.add((ITableCell)new ControlTableCell((Node)barrelAmount));
            } else {
                BaleAmountAlwaysVisible baleAmount = new BaleAmountAlwaysVisible();
                baleAmount.amountProperty().bind((ObservableValue)buyAmount.asString());
                row.add((ITableCell)new ControlTableCell((Node)baleAmount));
            }
            IntegerBinding priceBinding = this.getPriceBinding((IWare)ware, buyAmount);
            CoinPriceAlwaysVisible price = new CoinPriceAlwaysVisible();
            price.amountProperty().bind((ObservableValue)priceBinding.asString());
            row.add((ITableCell)new ControlTableCell((Node)price));
            model.add(row);
        }
        return model;
    }

    private IntegerProperty getStoredAmount(IWare ware) {
        if (!this.availableMap.containsKey(ware)) {
            ITradingOffice office = this.getPlayer().findTradingOffice(this.getCity());
            IntegerProperty stored = office.getWare(ware).amountProperty();
            this.availableMap.put(ware, stored);
        }
        return this.availableMap.get(ware);
    }

    private IntegerBinding getPriceBinding(IWare ware, BaseShipyardDialog.BuyAmountBinding buyAmount) {
        if (!this.priceMap.containsKey(ware)) {
            BaseShipyardDialog.PriceBinding priceBinding = new BaseShipyardDialog.PriceBinding(this, ware, buyAmount);
            this.priceMap.put(ware, priceBinding);
        }
        return this.priceMap.get(ware);
    }

    private IntegerBinding getNeededWareBinding(final EWare ware) {
        return new IntegerBinding(){
            {
                super.bind(new Observable[]{ShipyardConstructionDialogV2.this.currentShipTypeIndexProperty()});
            }

            protected int computeValue() {
                return ShipyardConstructionDialogV2.this.shipFactory.getConstructionAmount(ShipyardConstructionDialogV2.this.getCurrentShipType(), ware);
            }
        };
    }

    @Override
    protected Table createTopTable() {
        int capacity = this.shipFactory.calculateInitialCapacity(this.getCurrentShipType(), this.getCity().getCoordinates().getX());
        IShipWeaponsLocation shipWeapons = this.weaponsLocationFactory.getShipWeaponsLocation(this.getCurrentShipType(), EShipUpgrade.NONE);
        Table model = new Table();
        TableHeader header = new TableHeader(5);
        model.setHeader(header);
        model.setColumnWidth(new Integer[]{70, 70, 70, 70, 70});
        TableRow row = new TableRow();
        BarrelAmount capacityAmount = new BarrelAmount();
        capacityAmount.setAmount(Integer.valueOf(capacity));
        row.add((ITableCell)new ControlTableCell((Node)capacityAmount));
        row.add((ITableCell)new StaticTextTableCell(String.valueOf(shipWeapons.getNumberOfSmallSlots())));
        row.add((ITableCell)new StaticTextTableCell(String.valueOf(shipWeapons.getNumberOfLargeSlots())));
        row.add((ITableCell)new StaticTextTableCell(String.valueOf(this.shipFactory.getShipSpeed(this.getCurrentShipType()))));
        row.add((ITableCell)new StaticTextTableCell(String.valueOf(this.shipFactory.getMinimalSailors(this.getCurrentShipType()))));
        model.add(row);
        return model;
    }

    @Override
    protected BooleanBinding actionEnabledBinding() {
        return new BooleanBinding(){
            {
                for (EWare ware : MATERIALS) {
                    IntegerProperty stored = ShipyardConstructionDialogV2.this.getStoredAmount((IWare)ware);
                    IntegerBinding price = ShipyardConstructionDialogV2.this.getPriceBinding((IWare)ware, null);
                    IntegerProperty available = ShipyardConstructionDialogV2.this.getCity().getWare((IWare)ware).amountProperty();
                    super.bind(new Observable[]{stored, price, available});
                }
                super.bind(new Observable[]{ShipyardConstructionDialogV2.this.getPlayer().getCompany().cashProperty()});
            }

            protected boolean computeValue() {
                long buildCosts;
                long cash = ShipyardConstructionDialogV2.this.getPlayer().getCompany().getCash();
                if (cash < (buildCosts = (long)ShipyardConstructionDialogV2.this.calculateTotalBuildCosts())) {
                    return false;
                }
                for (EWare ware : MATERIALS) {
                    int storedAmount = ShipyardConstructionDialogV2.this.getStoredAmount((IWare)ware).get();
                    int available = ShipyardConstructionDialogV2.this.getCity().getWare((IWare)ware).getAmount();
                    int needed = ShipyardConstructionDialogV2.this.shipFactory.getConstructionAmount(ShipyardConstructionDialogV2.this.getCurrentShipType(), ware);
                    if (needed <= storedAmount + available) continue;
                    return false;
                }
                return true;
            }
        };
    }
}

