/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.tavern;

import ch.sahits.game.graphic.display.dialog.tavern.TavernBaseSideRoomPersonDialog;
import ch.sahits.game.graphic.event.task.ClientTaskFactory;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.people.IBuyer;
import ch.sahits.game.openpatrician.model.people.ISideRoomPerson;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.util.ModelTranslations;
import java.util.HashMap;
import javafx.beans.binding.BooleanBinding;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernBuyerDialog
extends TavernBaseSideRoomPersonDialog {
    @Autowired
    private TimedUpdatableTaskList timedTaskList;
    @Autowired
    private ClientTaskFactory taskFactory;
    @Autowired
    private ModelTranslations translator;

    public TavernBuyerDialog(ICityPlayerProxyJFX city) {
        super(city, (ISideRoomPerson)city.getCity().getCityState().getTavernState().getBuyer());
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernBuyerDialog.title", new Object[0], this.locale.getCurrentLocal()));
        this.initializeButtons();
        IBuyer buyer = (IBuyer)this.currentPerson.get();
        String iconTemplate = buyer.getWare().isBarrelSizedWare() ? "icon:Barrel" : "icon:Bale";
        int p = buyer.getAmountablePrice().getAVGPrice() * buyer.getAmountablePrice().getAmount();
        String loadedText = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernBuyerDialog.dialog", new Object[]{iconTemplate}, this.locale.getCurrentLocal());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("name", buyer.getName());
        parameters.put("amount", buyer.getAmountablePrice().getAmount());
        parameters.put("ware", this.translator.getLocalDisplayName((EWare)buyer.getWare()));
        parameters.put("price", p);
        DecoratedText dt = this.decoratedTextFactory.createDecoratedText(loadedText, parameters);
        this.getContent().addAll((Object[])new Node[]{dt});
    }

    @Override
    protected EventHandler<MouseEvent> createAcceptHandler() {
        return new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                IBuyer buyer = (IBuyer)TavernBuyerDialog.this.currentPerson.get();
                TavernBuyerDialog.this.timedTaskList.add((TimedTask)TavernBuyerDialog.this.taskFactory.getBuyWares(TavernBuyerDialog.this.city, buyer));
                buyer.leave();
                TavernBuyerDialog.this.executeOnCloseButtonClicked();
            }
        };
    }

    @Override
    protected BooleanBinding disableAcceptButton() {
        return new BooleanBinding(){

            protected boolean computeValue() {
                return false;
            }
        };
    }
}

