/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.tavern;

import ch.sahits.game.graphic.display.dialog.tavern.TavernBaseSideRoomPersonDialog;
import ch.sahits.game.graphic.event.task.ClientTaskFactory;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.MapSegmentedImage;
import ch.sahits.game.openpatrician.model.people.IPirateHunter;
import ch.sahits.game.openpatrician.model.people.ISideRoomPerson;
import ch.sahits.game.openpatrician.server.MapLocationDetectionModel;
import ch.sahits.game.openpatrician.util.MapSegmentImageFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import javafx.application.Platform;
import javafx.beans.binding.BooleanBinding;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernPirateHunterDialog
extends TavernBaseSideRoomPersonDialog {
    @Autowired
    private Random rnd;
    @Autowired
    private ClientTaskFactory taskFactory;
    @Autowired
    private MapSegmentImageFactory segmentFactory;
    @Autowired
    private MapLocationDetectionModel locationDetector;

    public TavernPirateHunterDialog(ICityPlayerProxyJFX city) {
        super(city, (ISideRoomPerson)city.getCity().getCityState().getTavernState().getPirateHunter());
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernPirateHunterDialog.title", new Object[0], this.locale.getCurrentLocal()));
        this.initializeButtons();
        IPirateHunter pirateHunter = (IPirateHunter)this.currentPerson.get();
        String loadedText = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernPirateHunterDialog.dialog1", new Object[0], this.locale.getCurrentLocal());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("name", pirateHunter.getClientName());
        parameters.put("amount", pirateHunter.getPremium());
        DecoratedText dt = this.decoratedTextFactory.createDecoratedText(loadedText, parameters);
        this.getContent().addAll((Object[])new Node[]{dt});
    }

    @Override
    protected EventHandler<MouseEvent> createAcceptHandler() {
        return mouseEvent -> {
            this.removeDecoratedContent();
            this.removeAcceptButton();
            MapSegmentedImage imageMap = this.segmentFactory.getRandomPirateNest();
            String loadedText = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernPirateHunterDialog.acceptMessage", new Object[]{imageMap.getImageName()}, this.locale.getCurrentLocal());
            HashMap parameters = new HashMap();
            ArrayList visibleSegs = new ArrayList();
            visibleSegs.addAll(imageMap.getSegmentIndices());
            parameters.put("visibleSegments", visibleSegs);
            DecoratedText dt = this.decoratedTextFactory.createDecoratedText(loadedText, parameters);
            Platform.runLater(() -> this.getContent().add((Object)dt));
            IPirateHunter pirateHunter = (IPirateHunter)this.currentPerson.get();
            IHumanPlayer player = this.city.getPlayer();
            player.getCompany().updateCash((long)(-pirateHunter.getPremium()));
            player.setSegmentedMap(imageMap);
            this.locationDetector.addSegment(imageMap);
            pirateHunter.leave();
            this.executeOnCloseButtonClicked();
        };
    }

    @Override
    protected BooleanBinding disableAcceptButton() {
        return new BooleanBinding(){

            protected boolean computeValue() {
                return false;
            }
        };
    }
}

