/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.scene;

import ch.sahits.game.event.EGameStatusChange;
import ch.sahits.game.event.GameStateChange;
import ch.sahits.game.event.data.IGameStateChangeData;
import ch.sahits.game.event.data.NewGame;
import ch.sahits.game.graphic.display.SceneChangeable;
import ch.sahits.game.graphic.display.scene.BaseStartupScene;
import ch.sahits.game.graphic.display.util.GameOptionsService;
import ch.sahits.game.javafx.OpenPatricianScene;
import ch.sahits.game.javafx.control.OpenPatricianRadioButton;
import ch.sahits.game.javafx.control.OpenPatricianSlider;
import ch.sahits.game.javafx.control.OpenPatricianSpinner;
import ch.sahits.game.javafx.control.OpenPatricianStoneButton;
import ch.sahits.game.javafx.control.OpenPatricianWoodenTextInput;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.data.map.Cities;
import ch.sahits.game.openpatrician.data.map.City;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.Difficulty;
import ch.sahits.game.openpatrician.model.EGameSpeed;
import ch.sahits.game.openpatrician.model.EObjective;
import ch.sahits.game.openpatrician.model.GameFactory;
import ch.sahits.game.openpatrician.model.city.CityFactory;
import ch.sahits.game.openpatrician.model.city.EKontorType;
import ch.sahits.game.openpatrician.model.ship.ShipFactory;
import ch.sahits.game.openpatrician.server.MapProviderService;
import ch.sahits.game.openpatrician.util.RandomNameLoader;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import ch.sahits.game.util.UIFactory;
import com.google.common.eventbus.AsyncEventBus;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javax.annotation.PostConstruct;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.MessageSource;
import org.springframework.oxm.Unmarshaller;

@Prototype
@ClassCategory(value={EClassCategory.PROTOTYPE_BEAN})
public class NewGameScene
extends OpenPatricianScene {
    private static final Logger logger = LogManager.getLogger(NewGameScene.class);
    private RandomNameLoader firstNameLoader;
    private RandomNameLoader lastNameLoader;
    private OpenPatricianSpinner<String> objective;
    private OpenPatricianSlider speed;
    private OpenPatricianSlider difficulty;
    private OpenPatricianSpinner<Integer> startYear;
    private OpenPatricianSpinner<String> hometown;
    private OpenPatricianSpinner<String> map;
    private OpenPatricianRadioButton femaleRadioButton;
    private OpenPatricianRadioButton maleRadioButton;
    private OpenPatricianWoodenTextInput lastName;
    private OpenPatricianWoodenTextInput name;
    @Autowired
    private CityFactory cityFactory;
    @Autowired
    private GameFactory gameFactory;
    @Autowired
    private ShipFactory shipFactory;
    private SceneChangeable sceneChangeable;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @Qualifier(value="jaxb2MapMarshaller")
    private Unmarshaller unmarshaller;
    @Autowired
    private Locale locale;
    @Autowired
    private Date gameDate;
    @Autowired
    private UIFactory uiFactory;
    @Autowired
    private GameOptionsService gameOptions;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private MapProviderService mapProviderService;

    public NewGameScene(@Value(value="firstNameLoader") RandomNameLoader firstNameLoader, @Value(value="lastNameLoader") RandomNameLoader lastNameLoader) {
        super((Region)new StackPane());
        this.firstNameLoader = firstNameLoader;
        this.lastNameLoader = lastNameLoader;
        this.getRoot().getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource(this.getStyleSheetFilename()).toExternalForm());
    }

    @PostConstruct
    private void createControls() {
        StackPane root = (StackPane)this.getRoot();
        root.setId("NewGameStackPane");
        GridPane grid = new GridPane();
        grid.getStyleClass().add((Object)"grid");
        grid.setAlignment(Pos.CENTER);
        Label nameLbl = new Label(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.NewGameScene.name", new Object[0], this.locale.getCurrentLocal()));
        grid.add((Node)nameLbl, 0, 0);
        this.name = new OpenPatricianWoodenTextInput("");
        this.name.setText(this.firstNameLoader.getRandomName());
        this.name.setSize(25);
        grid.add((Node)this.name, 1, 0);
        Label lastNameLbl = new Label(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.NewGameScene.lastName", new Object[0], this.locale.getCurrentLocal()));
        grid.add((Node)lastNameLbl, 3, 0);
        this.lastName = new OpenPatricianWoodenTextInput("");
        this.lastName.setText(this.lastNameLoader.getRandomName());
        this.lastName.setSize(25);
        grid.add((Node)this.lastName, 4, 0);
        ToggleGroup toggleGroup = new ToggleGroup();
        Label sexLbl = new Label(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.NewGameScene.sex", new Object[0], this.locale.getCurrentLocal()));
        grid.add((Node)sexLbl, 0, 1);
        this.maleRadioButton = new OpenPatricianRadioButton(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.NewGameScene.male", new Object[0], this.locale.getCurrentLocal()));
        this.maleRadioButton.setSelected(true);
        this.maleRadioButton.setToggleGroup(toggleGroup);
        this.maleRadioButton.setUnselectedLabel(this.messageSource.getMessage("no", new Object[0], this.locale.getCurrentLocal()));
        this.maleRadioButton.setSelectedLabel(this.messageSource.getMessage("yes", new Object[0], this.locale.getCurrentLocal()));
        grid.add((Node)this.maleRadioButton, 1, 1);
        GridPane.setHalignment((Node)this.maleRadioButton, (HPos)HPos.LEFT);
        this.femaleRadioButton = new OpenPatricianRadioButton(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.NewGameScene.female", new Object[0], this.locale.getCurrentLocal()));
        this.femaleRadioButton.setSelected(false);
        this.femaleRadioButton.setToggleGroup(toggleGroup);
        this.femaleRadioButton.setUnselectedLabel(this.messageSource.getMessage("no", new Object[0], this.locale.getCurrentLocal()));
        this.femaleRadioButton.setSelectedLabel(this.messageSource.getMessage("yes", new Object[0], this.locale.getCurrentLocal()));
        grid.add((Node)this.femaleRadioButton, 3, 1);
        GridPane.setHalignment((Node)this.femaleRadioButton, (HPos)HPos.LEFT);
        Label mapLbl = new Label(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.NewGameScene.map", new Object[0], this.locale.getCurrentLocal()));
        grid.add((Node)mapLbl, 0, 2);
        this.map = new OpenPatricianSpinner();
        this.map.setOptionsMap(this.getMapList());
        this.map.selectedIndexProperty().set(0);
        this.map.selectedIndexProperty().addListener((observable, oldValue, newValue) -> this.hometown.setOptionsMap(this.getHomeTowns4Map()));
        grid.add(this.map, 1, 2);
        GridPane.setHalignment(this.map, (HPos)HPos.LEFT);
        Label hometownLbl = new Label(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.NewGameScene.hometown", new Object[0], this.locale.getCurrentLocal()));
        grid.add((Node)hometownLbl, 3, 2);
        this.hometown = new OpenPatricianSpinner();
        this.hometown.setOptionsMap(this.getHomeTowns4Map());
        this.map.selectedIndexProperty().addListener((observableValue, number, number2) -> {
            this.hometown.setOptionsMap(this.getHomeTowns4Map());
            this.hometown.selectedIndexProperty().set(0);
        });
        grid.add(this.hometown, 4, 2);
        GridPane.setHalignment(this.hometown, (HPos)HPos.LEFT);
        Label startYearLbl = new Label(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.NewGameScene.startYear", new Object[0], this.locale.getCurrentLocal()));
        grid.add((Node)startYearLbl, 0, 3);
        this.startYear = new OpenPatricianSpinner();
        Map<String, Integer> startYears = this.getStartYears();
        this.startYear.setOptionsMap(startYears);
        this.startYear.selectedIndexProperty().set(0);
        grid.add(this.startYear, 1, 3);
        GridPane.setHalignment(this.startYear, (HPos)HPos.LEFT);
        Label difficultyLbl = new Label(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.NewGameScene.difficulty", new Object[0], this.locale.getCurrentLocal()));
        grid.add((Node)difficultyLbl, 0, 4);
        this.difficulty = new OpenPatricianSlider(200);
        this.difficulty.getStyleClass().addAll((Object[])new String[]{"defaultTextSize24"});
        this.difficulty.setValues(this.getDificutlyList());
        this.difficulty.selectedIndexProperty().setValue((Number)0);
        grid.add((Node)this.difficulty, 1, 4);
        GridPane.setHalignment((Node)this.difficulty, (HPos)HPos.LEFT);
        Label gameSpeedLbl = new Label(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.NewGameScene.gameSpeed", new Object[0], this.locale.getCurrentLocal()));
        grid.add((Node)gameSpeedLbl, 3, 4);
        this.speed = new OpenPatricianSlider(200);
        this.speed.getStyleClass().addAll((Object[])new String[]{"defaultTextSize24"});
        this.speed.setValues(this.gameOptions.getGameSpeedList());
        this.speed.selectedIndexProperty().setValue((Number)1);
        grid.add((Node)this.speed, 4, 4);
        GridPane.setHalignment((Node)this.speed, (HPos)HPos.LEFT);
        Label objectiveLbl = new Label(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.NewGameScene.objective", new Object[0], this.locale.getCurrentLocal()));
        grid.add((Node)objectiveLbl, 0, 5);
        this.objective = new OpenPatricianSpinner();
        this.objective.setOptionsMap(this.getObjectiveList());
        grid.add(this.objective, 1, 5);
        GridPane.setHalignment(this.objective, (HPos)HPos.LEFT);
        OpenPatricianStoneButton button = new OpenPatricianStoneButton(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.NewGameScene.startGame", new Object[0], this.locale.getCurrentLocal()));
        button.setOnAction((EventHandler)new NewGameAction());
        grid.add((Node)button, 1, 6);
        GridPane.setHalignment((Node)button, (HPos)HPos.LEFT);
        root.getChildren().add((Object)grid);
    }

    public SceneChangeable getSceneChangeable() {
        return this.sceneChangeable;
    }

    public void setSceneChangeable(SceneChangeable sceneChangeable) {
        this.sceneChangeable = sceneChangeable;
    }

    private Map<String, String> getMapList() {
        Map maps = this.mapProviderService.getMaps();
        HashMap<String, String> l = new HashMap<String, String>();
        for (Map.Entry entry : maps.entrySet()) {
            l.put(this.messageSource.getMessage((String)entry.getKey(), new Object[0], this.locale.getCurrentLocal()), (String)entry.getValue());
        }
        return l;
    }

    private Map<String, String> getHomeTowns4Map() {
        HashMap<String, String> l = new HashMap<String, String>();
        String selectedValue = (String)this.map.getSelectedValue();
        try {
            logger.debug("Update home towns for map " + selectedValue);
            ch.sahits.game.openpatrician.data.map.Map mapData = (ch.sahits.game.openpatrician.data.map.Map)this.unmarshaller.unmarshal(this.getSourceFromFile(selectedValue));
            Cities cities = mapData.getCities();
            for (City city : cities.getCity()) {
                if (!city.getKontorType().equals(EKontorType.KONTOR.name())) continue;
                String cityName = this.messageSource.getMessage(city.getName(), new Object[0], this.locale.getCurrentLocal());
                l.put(cityName, city.getName());
            }
        }
        catch (IOException e) {
            logger.error("Could not read city data from the selected map: " + selectedValue);
        }
        return l;
    }

    private Source getSourceFromFile(String fileName) {
        InputStream resourceAsStream = ((Object)((Object)this)).getClass().getResourceAsStream(fileName);
        return new StreamSource(resourceAsStream);
    }

    private Map<String, Integer> getStartYears() {
        TreeMap<String, Integer> l = new TreeMap<String, Integer>();
        for (int year = 1400; year >= 1300; --year) {
            String y = String.valueOf(year);
            l.put(y, year);
        }
        return l;
    }

    private List<String> getDificutlyList() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.NewGameScene.CHANDLER", new Object[0], this.locale.getCurrentLocal()));
        l.add(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.NewGameScene.MERCHANT", new Object[0], this.locale.getCurrentLocal()));
        l.add(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.NewGameScene.TRADESMAN", new Object[0], this.locale.getCurrentLocal()));
        l.add(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.NewGameScene.COUNCILMAN", new Object[0], this.locale.getCurrentLocal()));
        l.add(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.NewGameScene.PATRICIAN", new Object[0], this.locale.getCurrentLocal()));
        return l;
    }

    private Map<String, String> getObjectiveList() {
        HashMap<String, String> l = new HashMap<String, String>();
        l.put(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.NewGameScene.objective1", new Object[0], this.locale.getCurrentLocal()), "");
        l.put(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.NewGameScene.objective2", new Object[0], this.locale.getCurrentLocal()), "");
        l.put(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.NewGameScene.objective3", new Object[0], this.locale.getCurrentLocal()), "");
        l.put(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.NewGameScene.objective4", new Object[0], this.locale.getCurrentLocal()), "");
        l.put(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.NewGameScene.objective5", new Object[0], this.locale.getCurrentLocal()), "");
        l.put(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.NewGameScene.objective6", new Object[0], this.locale.getCurrentLocal()), "");
        l.put(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.NewGameScene.objective7", new Object[0], this.locale.getCurrentLocal()), "");
        l.put(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.NewGameScene.objective8", new Object[0], this.locale.getCurrentLocal()), "");
        l.put(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.NewGameScene.objective9", new Object[0], this.locale.getCurrentLocal()), "");
        l.put(this.messageSource.getMessage("ch.sahits.game.graphic.display.scene.NewGameScene.objective10", new Object[0], this.locale.getCurrentLocal()), "");
        return l;
    }

    private String getStyleSheetFilename() {
        return "newGame.css";
    }

    private class NewGameAction
    implements EventHandler<MouseEvent> {
        private NewGameAction() {
        }

        private boolean validInput() {
            if (NewGameScene.this.name.getText() == null || NewGameScene.this.name.getText().trim().equals("")) {
                logger.warn("Name may not be null");
                return false;
            }
            if (NewGameScene.this.lastName.getText() == null || NewGameScene.this.lastName.getText().trim().equals("")) {
                logger.warn("Last name may not be null");
                return false;
            }
            return true;
        }

        public void handle(MouseEvent mouseEvent) {
            if (this.validInput()) {
                NewGame newGameDTO = NewGame.builder().difficulty(Difficulty.fromIndex((int)NewGameScene.this.difficulty.getSelectedIndex())).firstName(NewGameScene.this.name.getText()).lastName(NewGameScene.this.lastName.getText()).hometown((String)NewGameScene.this.hometown.getSelectedValue()).objective(EObjective.values()[NewGameScene.this.objective.getSelectedIndex()]).speed(EGameSpeed.values()[NewGameScene.this.speed.getSelectedIndex()]).startYear(((Integer)NewGameScene.this.startYear.getSelectedValue()).intValue()).male(NewGameScene.this.maleRadioButton.isSelected() && !NewGameScene.this.femaleRadioButton.isSelected()).mapName((String)NewGameScene.this.map.getSelectedValue()).singleplayer(true).environmentInitialisation(true).build();
                GameStateChange stateChange = new GameStateChange(EGameStatusChange.NEW_GAME);
                stateChange.setStateChangeData((IGameStateChangeData)newGameDTO);
                NewGameScene.this.clientServerEventBus.post((Object)stateChange);
                while (NewGameScene.this.gameDate.getStartYear() == null) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        logger.warn("Interrupted while waiting for the startyear to be set.");
                    }
                }
                double width = NewGameScene.this.getRoot().getWidth();
                double height = NewGameScene.this.getRoot().getHeight();
                this.changeScene(NewGameScene.this.uiFactory.getMainGameScene(width, height));
            }
        }

        public void changeScene(OpenPatricianScene scene) {
            double oldWidth = 0.0;
            double oldHeight = 0.0;
            double newWidth = NewGameScene.this.sceneChangeable.getSceneWidth();
            double newHeight = NewGameScene.this.sceneChangeable.getSceneHeight();
            NewGameScene.this.sceneChangeable.changeScene(scene);
            scene.widthChange(oldWidth, newWidth);
            scene.heightChange(oldHeight, newHeight);
            if (scene instanceof BaseStartupScene) {
                ((BaseStartupScene)scene).setSceneChangeable(NewGameScene.this.sceneChangeable);
            }
        }
    }
}

